/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omfapplication;

import java.io.IOException;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataNames;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmCounter;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmCounterRegistration;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmMoClassCounterType;
import se.ericsson.crbs.omf.omfapplication.OmfContext;
import se.ericsson.crbs.omf.omfapplication.OmfContextAlreadyExists;
import se.ericsson.crbs.omf.omfapplication.OmfContextCreateFailureException;
import se.ericsson.crbs.omf.omfapplication.OmfContextFactoryFactory;
import se.ericsson.crbs.omf.omfapplication.OmfContextId;
import se.ericsson.crbs.supsys.equipmentsupportfunction.EquipmentSupportFunctionMaoImpl;
import se.ericsson.crbs.supsys.omfapplication.MoMetaDataNamesSoam;
import se.ericsson.crbs.supsys.omfapplication.PmAttributeHandler;

public class OmfApplication
implements Mopplet {
    private static AbstractLogger logger = LoggingService.getLogger();
    private final OmfContext theOmfContext;
    private Thread theUpdateRATandFDNthread = null;

    public OmfApplication() {
        logger.traceEnter(this.getClass(), "OmfApplication");
        OmfContext omfContext = null;
        try {
            logger.traceDebug(this.getClass(), "Creating OMF Context.");
            MoMetaDataNamesSoam moMetaDataNamesSoam = new MoMetaDataNamesSoam();
            omfContext = OmfContextFactoryFactory.getOmfContextFactoryInstance((String)"").createOmfContext(new OmfContextId("SOAM"), (PmAttribute)new PmAttributeHandler(), (MoMetaDataNames)moMetaDataNamesSoam);
        }
        catch (IOException iOException) {
            logger.traceError(this.getClass(), "Error in OmfApplication Constructor!" + iOException.getMessage());
        }
        catch (OmfContextAlreadyExists omfContextAlreadyExists) {
            logger.traceError(this.getClass(), "Error in OmfApplication Constructor!" + omfContextAlreadyExists.getMessage());
        }
        catch (OmfContextCreateFailureException omfContextCreateFailureException) {
            logger.traceError(this.getClass(), "Error in OmfApplication Constructor!" + omfContextCreateFailureException.getMessage());
        }
        this.theOmfContext = omfContext;
        logger.traceReturn(this.getClass(), "OmfApplication");
    }

    public OmfApplication(OmfContext omfContext) {
        logger.traceEnter(this.getClass(), "OmfApplication");
        this.theOmfContext = omfContext;
        logger.traceReturn(this.getClass(), "OmfApplication");
    }

    public void init() {
        logger.traceEnter(this.getClass(), "init");
        logger.info(this.getClass(), "LM Loaded - soamLm");
        logger.info(this.getClass(), "Starting soamLm");
        this.theOmfContext.getGenericFactoryInitializer().initializeFactories();
        logger.traceReturn(this.getClass(), "init");
    }

    public void start() {
        ServiceRepository serviceRepository;
        PmCounterRegistration pmCounterRegistration;
        logger.traceEnter(this.getClass(), "start");
        this.theOmfContext.getGenericFactoryInitializer().startFactories();
        this.theOmfContext.getGenericFactoryInitializer().synch();
        logger.info(this.getClass(), "LM Started - soamLm");
        if (!"TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            this.theUpdateRATandFDNthread = EquipmentSupportFunctionMaoImpl.startUpdateRATandFDNthread(this.theOmfContext.getMoRepositoryWrapper());
        }
        if ((pmCounterRegistration = (PmCounterRegistration)(serviceRepository = ServiceLocatorFacade.getRepository()).getService(PmCounterRegistration.class)) == null) {
            logger.traceError(this.getClass(), "Could not locate PmCounterRegistration interface.");
            return;
        }
        PmCounter pmCounter = new PmCounter("pmMaxPowerConsumption", 1);
        PmCounter pmCounter2 = new PmCounter("pmMinPowerConsumption", 1);
        PmCounter pmCounter3 = new PmCounter("pmPowerConsumption", 150);
        PmCounter pmCounter4 = new PmCounter("pmEnergyConsumption", 1);
        PmCounter pmCounter5 = new PmCounter("pmAccumulatedEnergyConsumption", 1);
        PmCounter[] pmCounterArray = new PmCounter[]{pmCounter, pmCounter2, pmCounter3, pmCounter4, pmCounter5};
        PmMoClassCounterType[] pmMoClassCounterTypeArray = new PmMoClassCounterType[]{new PmMoClassCounterType("EnergyMeasurement", pmCounterArray)};
        boolean bl = pmCounterRegistration.registerCounters(pmMoClassCounterTypeArray);
        if (bl) {
            logger.info(this.getClass(), "Successfully registered PM counters.");
        } else {
            logger.traceError(this.getClass(), "Unable to register PM counters.");
        }
        logger.traceReturn(this.getClass(), "start");
    }

    public OmfContext getOmfContextOnlyForTest() {
        return this.theOmfContext;
    }

    public Thread getTheUpdateRATandFDNthreadOnlyForTest() {
        return this.theUpdateRATandFDNthread;
    }
}

