/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.net;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.SignalRegistry;
import enea.ose.system.ThisProcess;
import enea.ose.system.UnlinkedSignal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import se.ericsson.cello.net.FTPException;
import se.ericsson.cello.net.IllegalArgumentException;
import se.ericsson.cello.net.OsaRfaiAbortReq;
import se.ericsson.cello.net.OsaRfaiConnectBsaReq;
import se.ericsson.cello.net.OsaRfaiConnectCfm;
import se.ericsson.cello.net.OsaRfaiConnectRej;
import se.ericsson.cello.net.OsaRfaiConnectReq;
import se.ericsson.cello.net.OsaRfaiConnectReq3;
import se.ericsson.cello.net.OsaRfaiDisconnCfm;
import se.ericsson.cello.net.OsaRfaiDisconnRej;
import se.ericsson.cello.net.OsaRfaiDisconnReq;
import se.ericsson.cello.net.OsaRfaiGetCfm;
import se.ericsson.cello.net.OsaRfaiGetRej;
import se.ericsson.cello.net.OsaRfaiGetReq;
import se.ericsson.cello.net.OsaRfaiInitServiceCfm;
import se.ericsson.cello.net.OsaRfaiInitServiceRej;
import se.ericsson.cello.net.OsaRfaiInitServiceReq;
import se.ericsson.cello.net.OsaRfaiInitServiceSus;
import se.ericsson.cello.net.OsaRfaiPutCfm;
import se.ericsson.cello.net.OsaRfaiPutRej;
import se.ericsson.cello.net.OsaRfaiPutReq;
import se.ericsson.cello.net.OsaRfaiServerDownInd;
import se.ericsson.cello.net.OsaRfaiTerminateServiceCfm;
import se.ericsson.cello.net.OsaRfaiTerminateServiceReq;
import se.ericsson.cello.net.OsaRfaiUnpublishInd;
import se.ericsson.cello.net.OutOfResourcesException;
import se.ericsson.cello.net.RfaiConnectBsaReq5;
import se.ericsson.cello.net.RfaiConnectReq5;
import se.ericsson.cello.net.ServerDownException;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.SignalHelper;

public class FTPClient {
    OseProcess server;
    int attachID;
    int selectedPv = 0;
    boolean isInitiated;
    boolean isConnected;
    OseProcess client;
    static final int MAX_CLIENT_NAME_LENGTH = 41;
    static final int MAX_IPADDRESS_SIZE = 16;
    static final int MAX_IPADDRESS_SIZE5 = 256;
    static final int MAX_USERID_SIZE = 21;
    static final int MAX_USERID_SIZE3 = 255;
    static final int MAX_PASSWORD_SIZE = 21;
    static final int MAX_PATH_SIZE = 256;
    private static final String CELLO_RFAI_NAME = "CELLO_RFAI";
    private static final short OSA_RFAI_NO_PV = 0;
    private static final short OSA_RFAI_PV1 = 1;
    private static final short OSA_RFAI_PV2 = 2;
    private static final short OSA_RFAI_PV3 = 3;
    private static final short OSA_RFAI_PV4 = 4;
    private static final short OSA_RFAI_PV5 = 5;
    private static SignalRegistry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPClient() {
        String string = CELLO_RFAI_NAME;
        synchronized (CELLO_RFAI_NAME) {
            if (registry == null) {
                registry = new SignalRegistry();
                registry.add(OsaRfaiInitServiceCfm.class);
                registry.add(OsaRfaiInitServiceRej.class);
                registry.add(OsaRfaiInitServiceSus.class);
                registry.add(OsaRfaiConnectCfm.class);
                registry.add(OsaRfaiConnectRej.class);
                registry.add(OsaRfaiGetCfm.class);
                registry.add(OsaRfaiGetRej.class);
                registry.add(OsaRfaiPutCfm.class);
                registry.add(OsaRfaiPutRej.class);
                registry.add(OsaRfaiDisconnCfm.class);
                registry.add(OsaRfaiDisconnRej.class);
                registry.add(OsaRfaiTerminateServiceCfm.class);
                registry.add(OsaRfaiServerDownInd.class);
                registry.add(OsaRfaiUnpublishInd.class);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String string, String string2, String string3, String string4, String string5) throws FTPException, OutOfResourcesException, IllegalArgumentException {
        while (true) {
            try {
                this.initiateService();
                if (string2.length() >= 255 && this.selectedPv >= 3 || string2.length() >= 21 && this.selectedPv < 3 || string3.length() >= 21 || string4.length() >= 256 || string5.length() >= 256) {
                    throw new IllegalArgumentException("Username, path, or password is to big");
                }
                if (this.selectedPv < 5) {
                    try {
                        string = InetAddress.getByName(string).getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new FTPException("Invalid IP address");
                    }
                }
                if (this.selectedPv != 0) {
                    this.connect(string, string2, string3);
                    this.get(string4, string5);
                    return;
                }
                try {
                    throw new FTPException("Failed to connect: OSA_RFAI_NO_PV is not valid PV");
                }
                catch (ServerDownException serverDownException) {}
                continue;
            }
            finally {
                this.disconnect();
                this.terminateService();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBsa(String string, String string2, String string3, String string4, String string5) throws FTPException, OutOfResourcesException, IllegalArgumentException {
        while (true) {
            try {
                this.initiateService();
                if (string2.length() >= 255 && this.selectedPv >= 3 || string2.length() >= 21 && this.selectedPv < 3 || string3.length() >= 21 || string4.length() >= 256 || string5.length() >= 256) {
                    throw new IllegalArgumentException("Username, path, or password is to big");
                }
                if (this.selectedPv < 5) {
                    try {
                        string = InetAddress.getByName(string).getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new FTPException("Invalid IP address");
                    }
                }
                if (this.selectedPv >= 4) {
                    this.connectBsa(string, string2, string3);
                    this.get(string4, string5);
                    return;
                }
                try {
                    throw new FTPException("Failed to connect: OSA_RFAI_PV4 or higher is needed by RFA server for BSA function");
                }
                catch (ServerDownException serverDownException) {}
                continue;
            }
            finally {
                this.disconnect();
                this.terminateService();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, String string2, String string3, String string4, String string5) throws FTPException, OutOfResourcesException, IllegalArgumentException {
        while (true) {
            try {
                this.initiateService();
                if (string2.length() >= 255 && this.selectedPv >= 3 || string2.length() >= 21 && this.selectedPv < 3 || string3.length() >= 21 || string4.length() >= 256 || string5.length() >= 256) {
                    throw new IllegalArgumentException("Username, path, or password is to big");
                }
                if (this.selectedPv < 5) {
                    try {
                        string = InetAddress.getByName(string).getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new FTPException("Invalid IP address");
                    }
                }
                if (this.selectedPv >= 2) {
                    this.connect(string, string2, string3);
                    this.put(string4, string5);
                    return;
                }
                try {
                    throw new FTPException("Failed to put: OSA_RFAI_PV2 or higher is needed by RFA server for put function");
                }
                catch (ServerDownException serverDownException) {}
                continue;
            }
            finally {
                this.disconnect();
                this.terminateService();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBsa(String string, String string2, String string3, String string4, String string5) throws FTPException, OutOfResourcesException, IllegalArgumentException {
        while (true) {
            try {
                this.initiateService();
                if (string2.length() >= 255 && this.selectedPv >= 3 || string2.length() >= 21 && this.selectedPv < 3 || string3.length() >= 21 || string4.length() >= 256 || string5.length() >= 256) {
                    throw new IllegalArgumentException("Username, path, or password is to big");
                }
                if (this.selectedPv < 5) {
                    try {
                        string = InetAddress.getByName(string).getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new FTPException("Invalid IP address");
                    }
                }
                if (this.selectedPv >= 4) {
                    this.connectBsa(string, string2, string3);
                    this.put(string4, string5);
                    return;
                }
                try {
                    throw new FTPException("Failed to connect: OSA_RFAI_PV4 or higher is needed by RFA server fro BSA function");
                }
                catch (ServerDownException serverDownException) {}
                continue;
            }
            finally {
                this.disconnect();
                this.terminateService();
                continue;
            }
            break;
        }
    }

    public void abort() {
        if (this.client != null) {
            OsaRfaiAbortReq osaRfaiAbortReq = new OsaRfaiAbortReq();
            SignalHelper.sendWithSender((OseProcess)this.server, (OseProcess)this.client, (Signal)osaRfaiAbortReq);
        }
    }

    void initiateService() throws FTPException, ServerDownException {
        this.server = OseNameServer.lookup((String)CELLO_RFAI_NAME);
        if (this.server == null) {
            throw new FTPException("RFA server not available", 3000);
        }
        this.attachID = this.server.attach();
        OsaRfaiInitServiceReq osaRfaiInitServiceReq = new OsaRfaiInitServiceReq("RFAJI", 5, 4, 3);
        SignalHelper.send((OseProcess)this.server, (Signal)osaRfaiInitServiceReq);
        InSignal inSignal = ThisProcess.receive((SignalRegistry)registry);
        if (!(inSignal instanceof OsaRfaiInitServiceCfm)) {
            if (inSignal instanceof OsaRfaiInitServiceSus) {
                this.isInitiated = true;
                throw new FTPException("Service suspended, highest pv = " + ((OsaRfaiInitServiceSus)inSignal).highestPv);
            }
            if (inSignal instanceof OsaRfaiInitServiceRej) {
                throw new FTPException("Service rejected, highest pv = " + ((OsaRfaiInitServiceRej)inSignal).highestPv);
            }
            if (inSignal instanceof OsaRfaiServerDownInd) {
                this.handleServerDown();
                throw new ServerDownException();
            }
            if (inSignal instanceof OsaRfaiUnpublishInd) {
                this.handleUnpublish();
                throw new ServerDownException(true);
            }
            throw new FTPException("Unexpected signal received in RFAJI: " + inSignal.getSigNo());
        }
        this.isInitiated = true;
        this.selectedPv = ((OsaRfaiInitServiceCfm)inSignal).negotiatedPv;
    }

    void connect(String string, String string2, String string3) throws FTPException, ServerDownException, OutOfResourcesException {
        UnlinkedSignal unlinkedSignal;
        if (this.selectedPv >= 5) {
            unlinkedSignal = new RfaiConnectReq5(string, string2, string3);
            SignalHelper.send((OseProcess)this.server, (Signal)unlinkedSignal);
        } else if (this.selectedPv < 5 && this.selectedPv >= 3) {
            unlinkedSignal = new OsaRfaiConnectReq3(string, string2, string3);
            SignalHelper.send((OseProcess)this.server, (Signal)unlinkedSignal);
        } else {
            unlinkedSignal = new OsaRfaiConnectReq(string, string2, string3);
            SignalHelper.send((OseProcess)this.server, (Signal)unlinkedSignal);
        }
        unlinkedSignal = ThisProcess.receive((SignalRegistry)registry);
        if (unlinkedSignal instanceof OsaRfaiConnectCfm) {
            OsaRfaiConnectCfm osaRfaiConnectCfm = (OsaRfaiConnectCfm)unlinkedSignal;
            if (osaRfaiConnectCfm.result != 1) {
                throw new FTPException(((OsaRfaiConnectCfm)unlinkedSignal).additionalInfo, ((OsaRfaiConnectCfm)unlinkedSignal).faultCode);
            }
        } else {
            if (unlinkedSignal instanceof OsaRfaiConnectRej) {
                OsaRfaiConnectRej osaRfaiConnectRej = (OsaRfaiConnectRej)unlinkedSignal;
                if (osaRfaiConnectRej.faultCode == 2001) {
                    throw new OutOfResourcesException(osaRfaiConnectRej.additionalInfo);
                }
                throw new FTPException(osaRfaiConnectRej.additionalInfo);
            }
            if (unlinkedSignal instanceof OsaRfaiServerDownInd) {
                this.handleServerDown();
                throw new ServerDownException();
            }
            if (unlinkedSignal instanceof OsaRfaiUnpublishInd) {
                this.handleUnpublish();
                throw new ServerDownException(true);
            }
            throw new FTPException("Unexpected signal received in RFAJI: " + unlinkedSignal.getSigNo());
        }
        this.isConnected = true;
    }

    void connectBsa(String string, String string2, String string3) throws FTPException, ServerDownException, OutOfResourcesException {
        UnlinkedSignal unlinkedSignal;
        if (this.selectedPv >= 5) {
            unlinkedSignal = new RfaiConnectBsaReq5(string, string2, string3);
            SignalHelper.send((OseProcess)this.server, (Signal)unlinkedSignal);
        } else {
            unlinkedSignal = new OsaRfaiConnectBsaReq(string, string2, string3);
            SignalHelper.send((OseProcess)this.server, (Signal)unlinkedSignal);
        }
        unlinkedSignal = ThisProcess.receive((SignalRegistry)registry);
        if (unlinkedSignal instanceof OsaRfaiConnectCfm) {
            OsaRfaiConnectCfm osaRfaiConnectCfm = (OsaRfaiConnectCfm)unlinkedSignal;
            if (osaRfaiConnectCfm.result != 1) {
                throw new FTPException(((OsaRfaiConnectCfm)unlinkedSignal).additionalInfo, ((OsaRfaiConnectCfm)unlinkedSignal).faultCode);
            }
        } else {
            if (unlinkedSignal instanceof OsaRfaiConnectRej) {
                OsaRfaiConnectRej osaRfaiConnectRej = (OsaRfaiConnectRej)unlinkedSignal;
                if (osaRfaiConnectRej.faultCode == 2001) {
                    throw new OutOfResourcesException(osaRfaiConnectRej.additionalInfo);
                }
                throw new FTPException(osaRfaiConnectRej.additionalInfo);
            }
            if (unlinkedSignal instanceof OsaRfaiServerDownInd) {
                this.handleServerDown();
                throw new ServerDownException();
            }
            if (unlinkedSignal instanceof OsaRfaiUnpublishInd) {
                this.handleUnpublish();
                throw new ServerDownException(true);
            }
            throw new FTPException("Unexpected signal received in RFAJI: " + unlinkedSignal.getSigNo());
        }
        this.isConnected = true;
    }

    void get(String string, String string2) throws FTPException, ServerDownException {
        OsaRfaiGetReq osaRfaiGetReq = new OsaRfaiGetReq(string, string2);
        SignalHelper.send((OseProcess)this.server, (Signal)osaRfaiGetReq);
        this.client = ThisProcess.getThisProcess();
        InSignal inSignal = ThisProcess.receive((SignalRegistry)registry);
        this.client = null;
        if (inSignal instanceof OsaRfaiGetCfm) {
            int n = ((OsaRfaiGetCfm)inSignal).result;
            if (n != 1) {
                throw new FTPException(((OsaRfaiGetCfm)inSignal).additionalInfo, ((OsaRfaiGetCfm)inSignal).faultCode);
            }
        } else {
            if (inSignal instanceof OsaRfaiGetRej) {
                throw new FTPException(((OsaRfaiGetRej)inSignal).additionalInfo, ((OsaRfaiGetRej)inSignal).faultCode);
            }
            if (inSignal instanceof OsaRfaiServerDownInd) {
                this.handleServerDown();
                throw new ServerDownException();
            }
            if (inSignal instanceof OsaRfaiUnpublishInd) {
                this.handleUnpublish();
                throw new ServerDownException(true);
            }
            throw new FTPException("Unexpected signal received in RFAJI: " + inSignal.getSigNo());
        }
    }

    void put(String string, String string2) throws FTPException, ServerDownException {
        OsaRfaiPutReq osaRfaiPutReq = new OsaRfaiPutReq(string, string2);
        SignalHelper.send((OseProcess)this.server, (Signal)osaRfaiPutReq);
        this.client = ThisProcess.getThisProcess();
        InSignal inSignal = ThisProcess.receive((SignalRegistry)registry);
        this.client = null;
        if (inSignal instanceof OsaRfaiPutCfm) {
            int n = ((OsaRfaiPutCfm)inSignal).result;
            if (n != 1) {
                throw new FTPException(((OsaRfaiPutCfm)inSignal).additionalInfo, ((OsaRfaiPutCfm)inSignal).faultCode);
            }
        } else {
            if (inSignal instanceof OsaRfaiPutRej) {
                throw new FTPException(((OsaRfaiPutRej)inSignal).additionalInfo, ((OsaRfaiPutRej)inSignal).faultCode);
            }
            if (inSignal instanceof OsaRfaiServerDownInd) {
                this.handleServerDown();
                throw new ServerDownException();
            }
            if (inSignal instanceof OsaRfaiUnpublishInd) {
                this.handleUnpublish();
                throw new ServerDownException(true);
            }
            throw new FTPException("Unexpected signal received in RFAJI: " + inSignal.getSigNo());
        }
    }

    void disconnect() {
        if (!this.isConnected) {
            return;
        }
        OsaRfaiDisconnReq osaRfaiDisconnReq = new OsaRfaiDisconnReq();
        SignalHelper.send((OseProcess)this.server, (Signal)osaRfaiDisconnReq);
        InSignal inSignal = ThisProcess.receive((SignalRegistry)registry);
        if (inSignal instanceof OsaRfaiDisconnCfm) {
            this.isConnected = false;
        } else if (!(inSignal instanceof OsaRfaiDisconnRej)) {
            if (inSignal instanceof OsaRfaiServerDownInd) {
                this.handleServerDown();
            } else if (inSignal instanceof OsaRfaiUnpublishInd) {
                this.handleUnpublish();
            }
        }
    }

    void terminateService() {
        if (!this.isInitiated) {
            return;
        }
        OsaRfaiTerminateServiceReq osaRfaiTerminateServiceReq = new OsaRfaiTerminateServiceReq();
        SignalHelper.send((OseProcess)this.server, (Signal)osaRfaiTerminateServiceReq);
        InSignal inSignal = ThisProcess.receive((SignalRegistry)registry);
        if (inSignal instanceof OsaRfaiTerminateServiceCfm) {
            OseProcess.detach((int)this.attachID);
            this.attachID = 0;
            this.isInitiated = false;
        } else if (inSignal instanceof OsaRfaiServerDownInd) {
            this.handleServerDown();
        } else if (inSignal instanceof OsaRfaiUnpublishInd) {
            this.handleUnpublish();
        }
    }

    void handleUnpublish() {
        OseProcess.detach((int)this.attachID);
        this.attachID = 0;
        this.isConnected = false;
        this.isInitiated = false;
    }

    void handleServerDown() {
        this.attachID = 0;
        this.isConnected = false;
        this.isInitiated = false;
    }
}

