/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import enea.ose.system.Signal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.common.fropxy.FroLockInd;
import se.ericsson.cello.common.fropxy.MoNotifiable;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipoam.DNSClientUtils;
import se.ericsson.cello.ipoam.IpAtmLinkMo;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipoam.IpInterfaceBuildIF;
import se.ericsson.cello.ipoam.IpInterfaceGroupBuildIF;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.ipoam.IpOamMo;
import se.ericsson.cello.ipoam.IpRoutingTableMoFactory;
import se.ericsson.cello.ipoam.IpRoutingTableMoImpl;
import se.ericsson.cello.ipoam.IpomUtil;
import se.ericsson.cello.ipoam.NodeIpAddressCarrier;
import se.ericsson.cello.ipoam.fropxy.IpomIpFroChangeLinkStateCfm;
import se.ericsson.cello.ipoam.fropxy.IpomIpFroParChd;
import se.ericsson.cello.ipoam.fropxy.OsaIpFroCreateRsp;
import se.ericsson.cello.ipoam.fropxy.OsaIpFroDeleteRsp;
import se.ericsson.cello.ipoam.fropxy.OsaIpFroGetRsp;
import se.ericsson.cello.ipoam.fropxy.OsaIpFroMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaIpFroSetRsp;
import se.ericsson.cello.ipoam.ipom_dnsclient_mi;
import se.ericsson.cello.ipoam.suaccess.IpMoSU_Access;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IllegalMoTypeException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class IpMoImpl
extends CelloMao
implements IpMo,
Reservable,
FroInfo,
MoNotifiable,
IpMoSU_Access {
    private static OsaIpFroMgmntProxy ipFroProxy = OsaIpFroMgmntProxy.instance();
    private FroProxy ipHostLinkProxy = null;
    private FroProxy dnsClientProxy = null;
    private StringAttribute userLabel;
    private IntegerAttribute ipFroId;
    private IntegerAttribute ipHostLinkFroId;
    private ReferenceAttribute reservedBy;
    private ReferenceAttribute ipAccessHostEtRef;
    private ReferenceAttribute dnsAutoConfigInterfaceRef;
    private static Class[] ipAccessHostEtClass = new Class[]{IpAccessHostEtMo.class};
    private MoData moData;
    private FroData froData = null;
    private static final String RESERVED_BY_OSPF = "reservedByOspf";
    private static final String IP_FRO_ID = "ipFroId";
    public static final String IP_HOST_LINK_FRO_ID = "ipHostLinkFroId";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[]{0};
    private static String DEFAULT_USER_LABEL = "";
    public static final int ETIP_BACKDOOR_PORTNUMBER_VALUE = 22;
    public static final int ETIP_BACKDOOR_PROTOCOL_VALUE = 6;
    public static final String ETIP_BACKDOOR_PORTNUMBER = "backdoorPortNumber";
    public static final String ETIP_BACKDOOR_PROTOCOL = "backdoorProtocol";
    private static final int WORKING_MODE_MIN = 0;
    private static final int WORKING_MODE_MAX = 1;
    private static final int MAXNUM_ATMLINKS = 810;
    private static final int ENABLE = 1;
    private static final int DISABLE = 0;
    private static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1"};
    private static final String[] reservedClasses = new String[]{"se.ericsson.cello.ipoam.OspfMoImpl"};
    private static final int MO_DATA_REVISION_8 = 8000;
    private static final int MO_DATA_REVISION_14 = 14000;
    private static final int MO_DATA_REVISION_LATEST = 14000;
    protected MaoFroIndicationHandler indHandler;
    private static final TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)new ipom_dnsclient_mi());

    public static IpMoImpl create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, FroProxy froProxy, FroProxy froProxy2, MaoFroIndicationHandler maoFroIndicationHandler, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpOam");
        MoAttributeValidator.checkIdentity((String)"Ip", (String)string);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"workingMode", (AttrList)attrList, (boolean)true, (int)1, (int)0, (int)1, (String)"Ip");
        AttrList attrList2 = DNSClientUtils.extractDNSClientAttributes(attrList);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)DEFAULT_USER_LABEL, (String)"Ip", (int)128, (int)0);
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"dscp", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)63, (String)"Ip");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"udpChecksumState", (AttrList)attrList, (boolean)false, (int)1, (int)0, (int)1, (String)"Ip");
        int n4 = IpMoImpl.checkAndGetConnectionAttemptTimer(attrList);
        int n5 = IpMoImpl.checkAndGetMaxRetransmissionAttempts(attrList);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"icmpRedirect", (AttrList)attrList, (boolean)false, (boolean)true, (String)"Ip");
        int n6 = MaoFroTypeConverter.boolean2int((boolean)bl);
        String string3 = MoAttributeValidator.checkAndGetStringAttribute((String)"nodeInterfaceName", (AttrList)attrList, (boolean)false, (String)"le0", (String)"Ip");
        if (!string3.equals("le0")) {
            throw new ValueOutOfRangeException("nodeInterfaceName", "Ip", "Allowed value at create is le0");
        }
        byte[] byArray = IpMoImpl.nullTerminateByteArray(MaoFroTypeConverter.string2byteArray((String)string3, (int)string3.length()));
        String string4 = MoAttributeValidator.checkAndGetStringAttribute((String)"nodeIpv6InterfaceName", (AttrList)attrList, (boolean)false, (String)"", (String)"Ip");
        byte[] byArray2 = IpMoImpl.nullTerminateByteArray(MaoFroTypeConverter.string2byteArray((String)string4, (int)string4.length()));
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ipAccessHostEtRef", (AttrList)attrList, (boolean)false, (Class[])ipAccessHostEtClass, (String)"Ip");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Ip");
        return new IpMoImpl((IpOamMo)managedObject, n, n2, n3, n4, n5, n6, string2, byArray, byArray2, string, managedObject3, froProxy, froProxy2, maoFroIndicationHandler, attrList2, coordinator);
    }

    public IpMoImpl(MoData moData, FroProxy froProxy, FroProxy froProxy2, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.moData = moData;
        this.ipHostLinkProxy = froProxy;
        this.dnsClientProxy = froProxy2;
        this.indHandler = maoFroIndicationHandler;
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 1);
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.moData, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(14000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(IP_FRO_ID);
        moDataRecoveryHelper.assertAttribute(RESERVED_BY_OSPF);
        moDataRecoveryHelper.assertAttribute("ipAccessHostEtRef");
        moDataRecoveryHelper.assertAttribute(IP_HOST_LINK_FRO_ID);
        moDataRecoveryHelper.assertAttribute("dnsAutoConfigInterfaceRef");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.ipFroId = (IntegerAttribute)moData.getAttribute(IP_FRO_ID);
        this.reservedBy = (ReferenceAttribute)moData.getAttribute(RESERVED_BY_OSPF);
        this.ipAccessHostEtRef = (ReferenceAttribute)moData.getAttribute("ipAccessHostEtRef");
        this.ipHostLinkFroId = (IntegerAttribute)moData.getAttribute(IP_HOST_LINK_FRO_ID);
        this.dnsAutoConfigInterfaceRef = (ReferenceAttribute)moData.getAttribute("dnsAutoConfigInterfaceRef");
        ipFroProxy.registerForNotifications(null, this, this.ipFroId.getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        if (this.reservedBy.getValue(coordinator) != null) {
            throw new MoReservedNotDeletableException("Ip");
        }
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ManagedObject managedObject = this.getIpAccessHostEtRef(coordinator);
        if (managedObject != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        this.setIpAccessHostEtRef(null, coordinator);
        MoIterator moIterator = MoRepository.instance().lookupType("IpRoutingTable");
        if (moIterator != null && moIterator.size() > 0) {
            ((IpRoutingTableMoImpl)moIterator.nextElement()).deleteMo(coordinator);
        }
        OsaIpFroDeleteRsp osaIpFroDeleteRsp = ipFroProxy.sendIpFroDeleteReq(this.ipFroId.getValue(coordinator), coordinator.getTransactionID());
        this.checkSignal((Signal)osaIpFroDeleteRsp, "IP");
        this.checkIpResult(osaIpFroDeleteRsp.getResult());
        ManagedObject managedObject2 = this.getDnsAutoConfigInterfaceRef(coordinator);
        if (managedObject2 != null) {
            ((Reservable)managedObject2).release((ManagedObject)this, coordinator);
        }
        DNSClientUtils.delete(coordinator, this.dnsClientProxy, this.moData);
        this.indHandler.deregisterForNotifications(coordinator, 1);
        ipFroProxy.deregisterForNotifications(coordinator, this.ipFroId.getValue(coordinator));
        super.delete(coordinator);
        this.moData.delete(coordinator);
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Ip", (int)128, (int)0);
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        int n = 4;
        return this.getIpAttributes(n, coordinator).getOperationalState();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        int n = 5;
        return AvailConverter.convert((int)this.getIpAttributes(n, coordinator).getAvailabilityStatus());
    }

    public int getIpFroId(Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.ipFroId.getValue(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        return this.getIpFroId(coordinator);
    }

    public int getWorkingMode(Coordinator coordinator) throws MoAccessException {
        int n = 1;
        return this.getIpAttributes(n, coordinator).getWorkingMode();
    }

    public void setWorkingMode(int n, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n2 = 1;
        if (n < 0 || n > 1) {
            throw new ValueOutOfRangeException("workingMode", "Ip");
        }
        String[] stringArray = new String[]{"workingMode"};
        Object[] objectArray = new Object[]{new Integer(n)};
        IpMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        this.setIpAttributes(n2, n, coordinator);
    }

    public String[] getDnsServerAddresses(Coordinator coordinator) throws MoAccessException {
        return DNSClientUtils.getDnsServerAddresses(coordinator, this.moData, this.dnsClientProxy);
    }

    public void setDnsServerAddresses(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        DNSClientUtils.setDnsServerAddresses(stringArray, coordinator, this.moData, this.dnsClientProxy, this);
    }

    public String[] getUsedDnsServerAddresses(Coordinator coordinator) throws MoAccessException {
        return DNSClientUtils.getUsedDnsServerAddresses(coordinator, this.moData, this.dnsClientProxy);
    }

    public ManagedObject getDnsAutoConfigInterfaceRef(Coordinator coordinator) throws MoAccessException {
        return DNSClientUtils.getDnsAutoConfigInterfaceRef(coordinator, this.moData, this.dnsClientProxy);
    }

    public void setDnsAutoConfigInterfaceRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        DNSClientUtils.setDnsAutoConfigInterfaceRef(managedObject, coordinator, this.moData, this.dnsClientProxy, this);
    }

    public int getNumberOfLinks(Coordinator coordinator) throws MoAccessException {
        int n = 3;
        return this.getIpAttributes(n, coordinator).getNumberOfLinks();
    }

    public String getType() {
        return "Ip";
    }

    public boolean getIsRecursiveSearch(Coordinator coordinator) throws MoAccessException {
        return DNSClientUtils.getIsRecursiveSearch(coordinator, this.moData, this.dnsClientProxy);
    }

    public void setIsRecursiveSearch(boolean bl, Coordinator coordinator) throws MoAccessException {
        DNSClientUtils.setIsRecursiveSearch(bl, coordinator, this.moData, this.dnsClientProxy, this);
    }

    public boolean getIsSubDomainName(Coordinator coordinator) throws MoAccessException {
        return DNSClientUtils.getIsSubDomainName(coordinator, this.moData, this.dnsClientProxy);
    }

    public void setIsSubDomainName(boolean bl, Coordinator coordinator) throws MoAccessException {
        DNSClientUtils.setIsSubDomainName(bl, coordinator, this.moData, this.dnsClientProxy, this);
    }

    public boolean getIsDefDomainName(Coordinator coordinator) throws MoAccessException {
        return DNSClientUtils.getIsDefDomainName(coordinator, this.moData, this.dnsClientProxy);
    }

    public void setIsDefDomainName(boolean bl, Coordinator coordinator) throws MoAccessException, IllegalAttributeValueException {
        DNSClientUtils.setIsDefDomainName(bl, coordinator, this.moData, this.dnsClientProxy, this);
    }

    public String getDefDomainName(Coordinator coordinator) throws MoAccessException {
        return DNSClientUtils.getDefDomainName(coordinator, this.moData, this.dnsClientProxy);
    }

    public void setDefDomainName(String string, Coordinator coordinator) throws MoAccessException {
        DNSClientUtils.setDefDomainName(string, coordinator, this.moData, this.dnsClientProxy, this);
    }

    public boolean getUseHostFile(Coordinator coordinator) throws MoAccessException {
        return DNSClientUtils.getUseHostFile(coordinator, this.moData, this.dnsClientProxy);
    }

    public void setUseHostFile(boolean bl, Coordinator coordinator) throws MoAccessException {
        DNSClientUtils.setUseHostFile(bl, coordinator, this.moData, this.dnsClientProxy, this);
    }

    public int getNoOfRetrans(Coordinator coordinator) throws MoAccessException {
        return DNSClientUtils.getNoOfRetrans(coordinator, this.moData, this.dnsClientProxy);
    }

    public void setNoOfRetrans(int n, Coordinator coordinator) throws MoAccessException {
        DNSClientUtils.setNoOfRetrans(n, coordinator, this.moData, this.dnsClientProxy, this);
    }

    public int getDscp(Coordinator coordinator) throws MoAccessException {
        int n = 15;
        return this.getIpAttributes(n, coordinator).getDscp();
    }

    public void setDscp(int n, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n2 = 15;
        if (n < 0 || n > 63) {
            throw new ValueOutOfRangeException("dscp", "Ip");
        }
        String[] stringArray = new String[]{"dscp"};
        Object[] objectArray = new Object[]{new Integer(n)};
        IpMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        this.setIpAttributes(n2, n, coordinator);
    }

    public int getUdpChecksumState(Coordinator coordinator) throws MoAccessException {
        int n = 14;
        return this.getIpAttributes(n, coordinator).getUdpChecksumState();
    }

    public void setUdpChecksumState(int n, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n2 = 14;
        if (n < 0 || n > 1) {
            throw new ValueOutOfRangeException("udpChecksumState", "Ip");
        }
        String[] stringArray = new String[]{"udpChecksumState"};
        Object[] objectArray = new Object[]{new Integer(n)};
        IpMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        this.setIpAttributes(n2, n, coordinator);
    }

    public int getConnectionAttemptTimer(Coordinator coordinator) throws MoAccessException {
        int n = 16;
        return this.getIpAttributes(n, coordinator).getConnectionAttemptTimer();
    }

    public void setConnectionAttemptTimer(int n, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n2 = 16;
        if (n < 1 || n > Short.MAX_VALUE) {
            throw new ValueOutOfRangeException("connectionAttemptTimer", "Ip");
        }
        String[] stringArray = new String[]{"connectionAttemptTimer"};
        Object[] objectArray = new Object[]{new Integer(n)};
        IpMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        this.setIpAttributes(n2, n, coordinator);
    }

    public int getMaxRetransmissionAttempts(Coordinator coordinator) throws MoAccessException {
        int n = 17;
        return this.getIpAttributes(n, coordinator).getMaxRetransmissionAttempts();
    }

    public void setMaxRetransmissionAttempts(int n, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n2 = 17;
        if (n < -1) {
            throw new ValueOutOfRangeException("maxRetransmissionAttempts", "Ip");
        }
        String[] stringArray = new String[]{"maxRetransmissionAttempts"};
        Object[] objectArray = new Object[]{new Integer(n)};
        IpMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        this.setIpAttributes(n2, n, coordinator);
    }

    public boolean getIcmpRedirect(Coordinator coordinator) throws MoAccessException {
        int n = 18;
        int n2 = this.getIpAttributes(n, coordinator).getIcmpRedirect();
        return MaoFroTypeConverter.int2boolean((int)n2);
    }

    public void setIcmpRedirect(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = 18;
        String[] stringArray = new String[]{"icmpRedirect"};
        Object[] objectArray = new Object[]{bl};
        IpMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        this.setIpAttributes(n, MaoFroTypeConverter.boolean2int((boolean)bl), coordinator);
    }

    public int getRetransInterval(Coordinator coordinator) throws MoAccessException {
        return DNSClientUtils.getRetransInterval(coordinator, this.moData, this.dnsClientProxy);
    }

    public void setRetransInterval(int n, Coordinator coordinator) throws MoAccessException {
        DNSClientUtils.setRetransInterval(n, coordinator, this.moData, this.dnsClientProxy, this);
    }

    public String getNodeIpv6InterfaceName(Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 21;
        return MaoFroTypeConverter.byteArray2String((byte[])this.getIpAttributes(n, coordinator).getNodeIpv6InterfaceName());
    }

    public String getNodeIpv6Address(Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 22;
        return MaoFroTypeConverter.byteArray2String((byte[])this.getIpAttributes(n, coordinator).getNodeIpv6Address());
    }

    public void setNodeIpv6InterfaceName(String string, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoFilter moFilter = new MoFilter(){

            public boolean accept(ManagedObject managedObject) {
                return managedObject instanceof NodeIpAddressCarrier;
            }
        };
        if (!string.equals("")) {
            this.checkInterfaceNameWithFilter(string, moFilter, coordinator, Boolean.FALSE);
        }
        byte[] byArray = IpMoImpl.nullTerminateByteArray(MaoFroTypeConverter.string2byteArray((String)string, (int)string.length()));
        this.setIpAttributes(21, IpMoImpl.getNrOfU32s(byArray), byArray, coordinator);
        String[] stringArray = new String[]{"nodeIpv6InterfaceName"};
        Object[] objectArray = new Object[]{string};
        IpMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public String getNodeIpAddress(Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 20;
        int n2 = this.getIpAttributes(n, coordinator).getNodeIpAddress();
        return new IpAddress((long)n2).toString();
    }

    public String getNodeInterfaceName(Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 19;
        return MaoFroTypeConverter.byteArray2String((byte[])this.getIpAttributes(n, coordinator).getNodeInterfaceName());
    }

    public void setNodeInterfaceName(String string, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoFilter moFilter = new MoFilter(){

            public boolean accept(ManagedObject managedObject) {
                return managedObject instanceof NodeIpAddressCarrier || managedObject instanceof IpAtmLinkMo;
            }
        };
        this.checkInterfaceNameWithFilter(string, moFilter, coordinator, Boolean.TRUE);
        byte[] byArray = IpMoImpl.nullTerminateByteArray(MaoFroTypeConverter.string2byteArray((String)string, (int)string.length()));
        this.setIpAttributes(19, IpMoImpl.getNrOfU32s(byArray), byArray, coordinator);
        String[] stringArray = new String[]{"nodeInterfaceName"};
        Object[] objectArray = new Object[]{string};
        IpMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public ManagedObject getIpAccessHostEtRef(Coordinator coordinator) throws MoAccessException {
        return ((ReferenceAttribute)this.moData.getAttribute("ipAccessHostEtRef")).getValue(coordinator);
    }

    public void setIpAccessHostEtRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null && this.getIpAccessHostEtRef(coordinator) == null) {
            return;
        }
        if (managedObject == null && this.getIpAccessHostEtRef(coordinator) != null) {
            this.deleteIpHostLinkFro(coordinator);
            ((Reservable)this.getIpAccessHostEtRef(coordinator)).release((ManagedObject)this, coordinator);
            ((ReferenceAttribute)this.moData.getAttribute("ipAccessHostEtRef")).setValue(null);
        } else if (managedObject != null) {
            if (!(managedObject instanceof IpAccessHostEtMo)) {
                throw new IllegalMoTypeException("The provided ipAccessHostEtRef is not valid", "Ip");
            }
            if (this.getIpAccessHostEtRef(coordinator) != null) {
                if (managedObject.getLocalDistinguishedName().equals(this.getIpAccessHostEtRef(coordinator).getLocalDistinguishedName())) {
                    return;
                }
                if (this.froData != null) {
                    this.deleteIpHostLinkFro(coordinator);
                    ((Reservable)this.getIpAccessHostEtRef(coordinator)).release((ManagedObject)this, coordinator);
                }
            }
            this.createIpHostLinkFro(managedObject, coordinator);
            ((ReferenceAttribute)this.moData.getAttribute("ipAccessHostEtRef")).setValue(managedObject);
            ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
        }
        String[] stringArray = new String[]{"ipAccessHostEtRef"};
        Object[] objectArray = new Object[]{managedObject};
        IpMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public void deleteIpHostLinkFro(Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = this.ipHostLinkFroId.getValue(coordinator);
        this.ipHostLinkProxy.delete(coordinator, n, null);
    }

    public void createIpHostLinkFro(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        SignedIntParameter signedIntParameter;
        ArrayParameter arrayParameter;
        Object object;
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        ManagedObject managedObject2 = ((IpAccessHostEtMo)managedObject).getIpInterfaceMoRef(coordinator);
        SignedIntParameter signedIntParameter2 = null;
        int n2 = 0;
        SignedIntParameter signedIntParameter3 = null;
        if (managedObject2 instanceof IpInterfaceBuildIF) {
            signedIntParameter2 = new SignedIntParameter("ipInterfaceMoRef", ((IpInterfaceBuildIF)managedObject2).getFroId(coordinator));
            ((IpInterfaceBuildIF)managedObject2).getNetworkPrefixLength(coordinator);
            signedIntParameter3 = new SignedIntParameter("interfaceType", Integer.parseInt("A02", 16));
        } else if (managedObject2 instanceof IpInterfaceGroupBuildIF) {
            signedIntParameter2 = new SignedIntParameter("ipInterfaceMoRef", ((IpInterfaceGroupBuildIF)managedObject2).getFroId(coordinator));
            object = ((IpInterfaceGroupBuildIF)managedObject2).getPrimaryIpInterfaceRef(coordinator);
            ((IpInterfaceBuildIF)object).getNetworkPrefixLength(coordinator);
            signedIntParameter3 = new SignedIntParameter("interfaceType", Integer.parseInt("E08", 16));
        } else if (managedObject2 instanceof VpnInterfaceBuildIF) {
            signedIntParameter2 = new SignedIntParameter("ipInterfaceMoRef", ((VpnInterfaceBuildIF)managedObject2).getFroId(coordinator));
            ((VpnInterfaceBuildIF)managedObject2).getNetworkPrefixLength(coordinator);
            signedIntParameter3 = new SignedIntParameter("interfaceType", Integer.parseInt("A0B", 16));
            n2 = ((VpnInterfaceBuildIF)managedObject2).getConfigurationMode(coordinator);
        } else if (managedObject2 instanceof Ipv6InterfaceMo) {
            signedIntParameter2 = new SignedIntParameter("ipInterfaceMoRef", ((Ipv6InterfaceMo)managedObject2).getFroId(coordinator));
            n = ((IpAccessHostEtMo)managedObject).getNetworkPrefixLength(coordinator);
            signedIntParameter3 = new SignedIntParameter("interfaceType", Integer.parseInt("E15", 16));
        } else {
            throw new WrongAttributeTypeException("Ip", "Only Ipv4 or Ipv6 is supported when IpAccessHostEt MO is used as an alternative OAM access");
        }
        arrayList.add(signedIntParameter2);
        arrayList.add(signedIntParameter3);
        arrayList.add(new SignedIntParameter("confMode", n2));
        object = ((IpAccessHostEtMo)managedObject).getIpAddress(coordinator);
        if (Ipv4AddressValidation.isIpv4((String)object)) {
            arrayParameter = new ArrayParameter("ipv4Addresses");
            arrayParameter.add((Parameter)new StringParameter("ipv4Address", (String)object, 15));
            arrayList.add(arrayParameter);
        } else if (Ipv6AddressValidation.isIpv6((String)object)) {
            arrayParameter = new StructParameter("ipv6AddressInfo");
            arrayParameter.add((Parameter)new StringParameter("ipAddress", (String)object, 39));
            arrayParameter.add((Parameter)new StringParameter("prefixLength", Integer.toString(n)));
            signedIntParameter = new ArrayParameter("ipv6Addresses");
            signedIntParameter.add((Parameter)arrayParameter);
            arrayList.add(signedIntParameter);
        }
        int n3 = ((IpAccessHostEtMo)managedObject).getPiuFroid(coordinator);
        signedIntParameter = new SignedIntParameter("piuFroId", n3);
        arrayList.add(signedIntParameter);
        UnsignedIntParameter unsignedIntParameter = new UnsignedIntParameter(ETIP_BACKDOOR_PROTOCOL, 6L);
        arrayList.add(unsignedIntParameter);
        UnsignedIntParameter unsignedIntParameter2 = new UnsignedIntParameter(ETIP_BACKDOOR_PORTNUMBER, 22L);
        arrayList.add(unsignedIntParameter2);
        SignedIntParameter signedIntParameter4 = new SignedIntParameter("ipAccessHostEtFroId", ((FroInfo)managedObject).getFroId(coordinator));
        arrayList.add(signedIntParameter4);
        if (this.ipHostLinkProxy == null) {
            throw new OperationNotAllowedException("IpHostLinkFro can not be created as ipHostLinkProxy is null", "Ip");
        }
        this.froData = this.ipHostLinkProxy.create(coordinator, arrayList);
        this.ipHostLinkFroId.setValue(this.froData.getFroId());
    }

    public ManagedObject getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedBy.getValue(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Ip", (MoData)this.moData, (ReferenceAttribute)this.reservedBy, (String[])reservedClasses);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Ip", (MoData)this.moData, (ReferenceAttribute)this.reservedBy, (String[])reservedClasses);
    }

    public boolean checkAtmLinks(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.getChildren();
        int n = 0;
        if (moIterator.size() > 810) {
            while (moIterator.hasMoreElements()) {
                if (!(moIterator.nextMo() instanceof IpAtmLinkMo)) continue;
                ++n;
            }
        }
        return n < 810;
    }

    public int getPmNoOfIpInReceives(Coordinator coordinator) throws MoAccessException {
        int n = 6;
        return this.getIpAttributes(n, coordinator).getPmNoOfIpInReceives();
    }

    public int getPmNoOfHdrErrors(Coordinator coordinator) throws MoAccessException {
        int n = 7;
        return this.getIpAttributes(n, coordinator).getPmNoOfHdrErrors();
    }

    public int getPmNoOfIpAddrErrors(Coordinator coordinator) throws MoAccessException {
        int n = 8;
        return this.getIpAttributes(n, coordinator).getPmNoOfIpAddrErrors();
    }

    public int getPmNoOfIpForwDatagrams(Coordinator coordinator) throws MoAccessException {
        int n = 9;
        return this.getIpAttributes(n, coordinator).getPmNoOfIpForwDatagrams();
    }

    public int getPmNoOfIpInDiscards(Coordinator coordinator) throws MoAccessException {
        int n = 10;
        return this.getIpAttributes(n, coordinator).getPmNoOfIpInDiscards();
    }

    public int getPmNoOfIpOutDiscards(Coordinator coordinator) throws MoAccessException {
        int n = 11;
        return this.getIpAttributes(n, coordinator).getPmNoOfIpOutDiscards();
    }

    public int getPmNoOfIpReasmReqds(Coordinator coordinator) throws MoAccessException {
        int n = 12;
        return this.getIpAttributes(n, coordinator).getPmNoOfIpReasmReqds();
    }

    public int getPmNoOfIpReasmOKs(Coordinator coordinator) throws MoAccessException {
        int n = 13;
        return this.getIpAttributes(n, coordinator).getPmNoOfIpReasmOKs();
    }

    public void actionEnableLink(String string, Coordinator coordinator) throws MoAccessException {
        this.sendChangeLinkState(string, 1);
    }

    public void actionDisableLink(String string, Coordinator coordinator) throws MoAccessException {
        this.sendChangeLinkState(string, 0);
    }

    private IpMoImpl(IpOamMo ipOamMo, int n, int n2, int n3, int n4, int n5, int n6, String string, byte[] byArray, byte[] byArray2, String string2, ManagedObject managedObject, FroProxy froProxy, FroProxy froProxy2, MaoFroIndicationHandler maoFroIndicationHandler, AttrList attrList, Coordinator coordinator) throws MoAccessException {
        super((ManagedObject)ipOamMo, "Ip", string2, coordinator);
        this.ipHostLinkProxy = froProxy;
        this.dnsClientProxy = froProxy2;
        this.indHandler = maoFroIndicationHandler;
        int n7 = coordinator.getTransactionID();
        int[] nArray = new int[200];
        nArray[0] = 1;
        nArray[1] = n;
        nArray[2] = 14;
        nArray[3] = n3;
        nArray[4] = 15;
        nArray[5] = n2;
        nArray[6] = 16;
        nArray[7] = n4;
        nArray[8] = 17;
        nArray[9] = n5;
        nArray[10] = 18;
        nArray[11] = n6;
        nArray[12] = 19;
        nArray[13] = byArray.length;
        nArray[14] = 21;
        nArray[15] = byArray2.length;
        nArray[16] = 0;
        int n8 = 16;
        int[] nArray2 = IpomUtil.copyPartOfArray(n8 + 1, nArray);
        OsaIpFroCreateRsp osaIpFroCreateRsp = ipFroProxy.sendIpFroCreateReq(n7, nArray2, byArray, byArray2);
        this.checkSignal((Signal)osaIpFroCreateRsp, "IP");
        this.checkIpResult(osaIpFroCreateRsp.getResult());
        MoData moData = this.initMoData(osaIpFroCreateRsp.getFroId(), string, coordinator);
        DNSClientUtils.create(coordinator, this.dnsClientProxy, attrList, moData);
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, 1);
        IpRoutingTableMoFactory.createIpRoutingTable(this, "1", coordinator);
    }

    private MoData initMoData(int n, String string, Coordinator coordinator) throws MoAccessException {
        this.moData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.ipAccessHostEtRef = new ReferenceAttribute("ipAccessHostEtRef", true);
        this.moData.registerPersistentAttr((Attribute)this.ipAccessHostEtRef);
        ((ReferenceAttribute)this.moData.getAttribute("ipAccessHostEtRef")).setValue(null);
        this.dnsAutoConfigInterfaceRef = new ReferenceAttribute("dnsAutoConfigInterfaceRef", true);
        this.moData.registerPersistentAttr((Attribute)this.dnsAutoConfigInterfaceRef);
        ((ReferenceAttribute)this.moData.getAttribute("dnsAutoConfigInterfaceRef")).setValue(null);
        this.ipFroId = new IntegerAttribute(IP_FRO_ID, false);
        this.ipFroId.setValue(n);
        this.moData.registerPersistentAttr((Attribute)this.ipFroId);
        this.ipHostLinkFroId = new IntegerAttribute(IP_HOST_LINK_FRO_ID, false);
        this.moData.registerPersistentAttr((Attribute)this.ipHostLinkFroId);
        this.userLabel = new StringAttribute("userLabel", true);
        this.userLabel.setValue(string);
        this.moData.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new ReferenceAttribute(RESERVED_BY_OSPF, false);
        this.reservedBy.setValue(null);
        this.moData.registerPersistentAttr((Attribute)this.reservedBy);
        this.moData.setRevision(14000);
        ipFroProxy.registerForNotifications(coordinator, this, this.ipFroId.getValue(coordinator));
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        return this.moData;
    }

    private void setIpAttributes(int n, int n2, Coordinator coordinator) throws MoAccessException {
        this.setIpAttributes(n, n2, EMPTY_BYTE_ARRAY, coordinator);
    }

    private void setIpAttributes(int n, int n2, byte[] byArray, Coordinator coordinator) throws MoAccessException {
        int[] nArray = new int[]{n, n2, 0};
        OsaIpFroSetRsp osaIpFroSetRsp = ipFroProxy.sendIpFroSetReq(coordinator.getTransactionID(), this.getIpFroId(coordinator), nArray, byArray);
        this.checkSignal((Signal)osaIpFroSetRsp, "IP");
        this.checkIpResult(osaIpFroSetRsp.getResult());
    }

    private OsaIpFroGetRsp getIpAttributes(int n, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int[] nArray = new int[]{n, 0};
        OsaIpFroGetRsp osaIpFroGetRsp = ipFroProxy.sendIpFroGetReq(this.ipFroId.getValue(coordinator), MoAttributeValidator.getTransactionId((Coordinator)coordinator), nArray);
        this.checkSignal((Signal)osaIpFroGetRsp, "IP");
        if (osaIpFroGetRsp.getResult() == 100) {
            osaIpFroGetRsp.setPmCountersUnavailable();
        } else {
            this.checkIpResult(osaIpFroGetRsp.getResult());
        }
        return osaIpFroGetRsp;
    }

    private void checkSignal(Signal signal, String string) throws MoAccessException {
        if (signal == null) {
            throw new FroNotAccessibleException("Ip", string + " FRO is not accessible.");
        }
    }

    private void checkIpResult(int n) throws FroRequestFailedException {
        if (n != 0) {
            throw new FroRequestFailedException("Ip", "Ip FRO", ipFroProxy.getResultMsg(n), n);
        }
    }

    private static int checkAndGetConnectionAttemptTimer(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("connectionAttemptTimer");
        if (n == -1) {
            return 75;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("connectionAttemptTimer", "Ip");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 1 || n2 > Short.MAX_VALUE) {
            throw new ValueOutOfRangeException("connectionAttemptTimer", "Ip");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetMaxRetransmissionAttempts(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("maxRetransmissionAttempts");
        if (n == -1) {
            return 12;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("maxRetransmissionAttempts", "Ip");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < -1) {
            throw new ValueOutOfRangeException("maxRetransmissionAttempts", "Ip");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray);
    }

    private static byte[] nullTerminateByteArray(byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        if (byArray[n - 1] != 0) {
            byte[] byArray2 = new byte[n + 1];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        return byArray;
    }

    private void sendChangeLinkState(String string, int n) throws MoAccessException {
        if (string.equals(this.getNodeInterfaceName(null)) || string.equals(this.getNodeIpv6InterfaceName(null))) {
            throw new OperationNotAllowedException("Link state cannot be changed on the link holding the node IP address.", "Ip");
        }
        MoFilter moFilter = new MoFilter(){

            public boolean accept(ManagedObject managedObject) {
                return managedObject instanceof NodeIpAddressCarrier || managedObject instanceof IpAtmLinkMo;
            }
        };
        this.checkInterfaceNameWithFilter(string, moFilter, null, null);
        byte[] byArray = IpMoImpl.nullTerminateByteArray(MaoFroTypeConverter.string2byteArray((String)string, (int)7));
        IpomIpFroChangeLinkStateCfm ipomIpFroChangeLinkStateCfm = ipFroProxy.sendIpFroChangeLinkStateReq(byArray, n);
        this.checkSignal((Signal)ipomIpFroChangeLinkStateCfm, "IP");
        this.checkIpResult(ipomIpFroChangeLinkStateCfm.getResult());
    }

    public void parameterChanged(FroLockInd froLockInd, String string) {
        if (!(froLockInd instanceof IpomIpFroParChd)) {
            MessageLog.traceError(this.getClass(), (String)"Unknown signal in parameterChanged()");
            return;
        }
        IpomIpFroParChd ipomIpFroParChd = (IpomIpFroParChd)froLockInd;
        Integer n = (Integer)ipomIpFroParChd.getValue(3);
        String string2 = (String)ipomIpFroParChd.getValue(20);
        String string3 = (String)ipomIpFroParChd.getValue(22);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (n != null) {
            arrayList.add("numberOfLinks");
            arrayList2.add(n);
        }
        if (string2 != null) {
            arrayList.add("nodeIpAddress");
            arrayList2.add(string2);
        }
        if (string3 != null) {
            arrayList.add("nodeIpv6Address");
            arrayList2.add(string3);
        }
        if (arrayList.size() == 0) {
            MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            return;
        }
        IpMoImpl.sendChangeNotification(this, arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray());
    }

    private void checkInterfaceNameWithFilter(String string, MoFilter moFilter, Coordinator coordinator, Boolean bl) throws ValueOutOfRangeException, MoAccessException {
        MoRepository moRepository = MoRepository.instance();
        MoIterator moIterator = moRepository.select((ManagedObject)this, 1, moFilter);
        boolean bl2 = false;
        while (moIterator.hasMoreElements()) {
            String string2;
            ManagedObject managedObject = moIterator.nextMo();
            String string3 = this.getInterfaceName(managedObject, coordinator);
            if (!string3.equals(string)) continue;
            bl2 = true;
            if (bl == null || !(managedObject instanceof NodeIpAddressCarrier) || !this.checkInterfaceConfiguration(managedObject, coordinator, bl)) break;
            if (bl.booleanValue()) {
                if (managedObject.getType().equals("IpHostLink")) {
                    String[] stringArray = (String[])((IpHostLinkMo)managedObject).getAttribute("ipv4Addresses", coordinator);
                    boolean bl3 = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!Ipv4AddressValidation.isDefault((String)stringArray[i])) continue;
                        bl3 = true;
                    }
                    if (stringArray.length != 0 && !stringArray[0].equals("") && !bl3) break;
                    throw new OperationNotAllowedException("InterfaceName " + string + " must not be possible to set because ipv4Addresses is unspecified or not assigned.", "Ip");
                }
                String string4 = ((NodeIpAddressCarrier)managedObject).getIpv4Address(coordinator);
                if (string4 != null && !string4.equals("") && !Ipv4AddressValidation.isDefault((String)string4)) break;
                throw new OperationNotAllowedException("InterfaceName " + string + " must not be possible to set because ipv4Addresses is unspecified or not assigned.", "Ip");
            }
            if (bl.booleanValue() || (string2 = ((NodeIpAddressCarrier)managedObject).getIpv6Address(coordinator)) != null && !string2.equals("") && !Ipv6AddressValidation.isUnspecifiedIpv6((String)string2)) break;
            throw new OperationNotAllowedException("InterfaceName " + string + " must not be possible to set because ipv6Addresses is unspecified or not assigned.", "Ip");
        }
        if (!bl2) {
            throw new OperationNotAllowedException("InterfaceName " + string + " is not a valid interface name.", "Ip");
        }
    }

    private boolean checkInterfaceConfiguration(ManagedObject managedObject, Coordinator coordinator, Boolean bl) throws MoAccessException {
        ManagedObject managedObject2 = null;
        if (managedObject instanceof IpHostLinkMo) {
            managedObject2 = ((IpHostLinkMo)managedObject).getIpInterfaceMoRef(coordinator);
            if (managedObject2 instanceof VpnInterfaceMo) {
                if (((VpnInterfaceMo)managedObject2).getConfigurationMode(coordinator) == 1) {
                    if (((VpnInterfaceMo)managedObject2).getAutoDetectIpVersion(coordinator) == 0) {
                        if (bl.booleanValue() && ((VpnInterfaceMo)managedObject2).getIpVersion(coordinator) == 1) {
                            throw new OperationNotAllowedException("InterfaceName associated with IpHostLinkMo is IpV6 type which is non compatible ", "Ip");
                        }
                        if (!bl.booleanValue() && ((VpnInterfaceMo)managedObject2).getIpVersion(coordinator) == 0) {
                            throw new OperationNotAllowedException("InterfaceName associated with IpHostLinkMo is IpV4 type which is non compatible ", "Ip");
                        }
                    }
                    return false;
                }
            } else if (managedObject2 instanceof IpInterfaceMo) {
                return ((IpInterfaceMo)managedObject2).getConfigurationMode(coordinator) != 1;
            }
        }
        return true;
    }

    private String getInterfaceName(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof NodeIpAddressCarrier) {
            return ((NodeIpAddressCarrier)managedObject).getInterfaceName(coordinator);
        }
        if (managedObject instanceof IpAtmLinkMo) {
            return ((IpAtmLinkMo)managedObject).getInterfaceName(coordinator);
        }
        return null;
    }

    private static int getNrOfU32s(byte[] byArray) {
        long l = 0L;
        if (byArray.length % 4 != 0) {
            l = byArray.length / 4 + 1;
        }
        if (byArray.length % 4 == 0) {
            l = byArray.length / 4;
        }
        return (int)l;
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl();
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            Iterator iterator = map.keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (string.equals("usedDnsServerAddresses")) {
                    ArrayParameter arrayParameter = (ArrayParameter)map.get("usedDnsServerAddresses");
                    String[] stringArray = new String[arrayParameter.size()];
                    String string2 = null;
                    StringParameter stringParameter = null;
                    for (int i = 0; i < arrayParameter.size(); ++i) {
                        stringParameter = (StringParameter)arrayParameter.get(i);
                        stringArray[i] = string2 = stringParameter.getValue();
                    }
                    setRequestContextImpl.addAvcNotification("usedDnsServerAddresses", (Object)stringArray);
                    continue;
                }
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag not found");
        }
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }
}

