/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import enea.ose.system.Signal;
import se.ericsson.cello.ipoam.IpOamMo;
import se.ericsson.cello.ipoam.fropxy.OsaIpSystemFroCreateRsp;
import se.ericsson.cello.ipoam.fropxy.OsaIpSystemFroPingRsp;
import se.ericsson.cello.ipoam.fropxy.OsaIpSystemFroTraceRsp;
import se.ericsson.cello.ipoam.fropxy.OsaIpSystemMgmntProxy;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class IpOamMoImpl
extends ManagedObjectBase
implements IpOamMo {
    private MoData myData;
    private LongAttribute resourceId;
    private StringAttribute userLabel;
    private static final String RESOURCE_ID = "resourceId";
    private static final String IP_OAM_ID_VALUE = "1";
    private OsaIpSystemMgmntProxy roProxy = OsaIpSystemMgmntProxy.instance();
    private static IpOamMoImpl instance = null;
    private static final int MO_DATA_REVISION_3 = 3000;
    private static final int MO_DATA_REVISION_6 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;

    static synchronized IpOamMoImpl instance() {
        try {
            if (instance == null) {
                instance = new IpOamMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            MessageLog.traceError((Class)IpOamMoImpl.class, (String)"Create instance of IpOam MO failed", (Throwable)moNameAlreadyTakenException);
        }
        return instance;
    }

    void recover(MoData moData) {
        this.myData = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.myData, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(RESOURCE_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.resourceId = (LongAttribute)moData.getAttribute(RESOURCE_ID);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public String getType() {
        return "IpOam";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"IpOam", (int)128, (int)0);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String actionPing(String string, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        String string2 = IpAddressValidation.getHostAddress((String)string, (String)"IpOam");
        OsaIpSystemFroPingRsp osaIpSystemFroPingRsp = this.roProxy.sendOsaIpSystemFroPingReq(this.resourceId.getValue(coordinator), string2);
        this.checkSignal((Signal)osaIpSystemFroPingRsp);
        return osaIpSystemFroPingRsp.getPingRsp();
    }

    public String actionTraceroute(String string, Coordinator coordinator) throws MoAccessException {
        return this.actionTraceRoute(string, coordinator);
    }

    public String actionTraceRoute(String string, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        String string2 = IpAddressValidation.getHostAddress((String)string, (String)"IpOam");
        OsaIpSystemFroTraceRsp osaIpSystemFroTraceRsp = this.roProxy.sendOsaIpSystemFroTraceReq(this.resourceId.getValue(coordinator), string2);
        this.checkSignal((Signal)osaIpSystemFroTraceRsp);
        return osaIpSystemFroTraceRsp.getTraceRsp();
    }

    public long getFroId(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.resourceId.getValue(coordinator);
    }

    private IpOamMoImpl() throws MoNameAlreadyTakenException {
        super(((SingletonMoFactory)MoFactoryMgr.instance().lookup("ManagedElement")).getMo(), "IpOam", IP_OAM_ID_VALUE, null);
    }

    synchronized void registerData() {
        if (this.myData == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
                this.myData = new MoData(this.getLocalDistinguishedName(), "IpOam", true, coordinator);
                OsaIpSystemFroCreateRsp osaIpSystemFroCreateRsp = this.roProxy.sendOsaIpSystemFroCreateReq(coordinator.getTransactionID());
                this.checkSignal((Signal)osaIpSystemFroCreateRsp);
                this.checkResult(osaIpSystemFroCreateRsp.getResult());
                int n = osaIpSystemFroCreateRsp.getFroId();
                this.resourceId = new LongAttribute(RESOURCE_ID, false);
                this.resourceId.setValue((long)n);
                this.myData.registerPersistentAttr((Attribute)this.resourceId);
                this.userLabel = new StringAttribute("userLabel", true, "");
                this.myData.registerPersistentAttr((Attribute)this.userLabel);
                this.myData.setRevision(6000);
                this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
            }
            catch (TransactionRequiredException transactionRequiredException) {
                MessageLog.traceError(this.getClass(), (String)"start of IpOam failed", (Throwable)transactionRequiredException);
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                MessageLog.traceError(this.getClass(), (String)"start of IpOam failed", (Throwable)transactionRolledBackException);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"start of IpOam failed", (Throwable)inactiveTransactionException);
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"start of IpOam failed", (Throwable)moAccessException);
            }
        }
    }

    private void checkResult(int n) throws MoAccessException {
        if (n != 0) {
            throw new FroRequestFailedException("IpOam", "OsaIpSystem", "Result msg: " + this.roProxy.getResultMsg(n), n);
        }
    }

    private void checkSignal(Signal signal) throws MoAccessException {
        if (signal == null) {
            throw new FroNotAccessibleException("IpOam", "OsaIpSystem FRO is not accessible");
        }
    }
}

