/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam.fropxy;

import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;

public class OsaIpFroCreateReq
extends UnlinkedSignal {
    public static final int SIGNO = 66304;
    private int txId;
    private int[] conftags;
    private byte[] nodeInterfaceName;
    private byte[] nodeIpv6InterfaceName;

    public OsaIpFroCreateReq() {
        super(66304);
    }

    public OsaIpFroCreateReq(int n, int[] nArray, byte[] byArray, byte[] byArray2) {
        super(66304);
        this.txId = n;
        this.conftags = (int[])nArray.clone();
        int n2 = byArray.length;
        int n3 = 4 - n2 % 4;
        this.nodeInterfaceName = new byte[n2 + n3];
        System.arraycopy(byArray, 0, this.nodeInterfaceName, 0, n2);
        n2 = byArray2.length;
        n3 = 4 - n2 % 4;
        this.nodeIpv6InterfaceName = new byte[n2 + n3];
        System.arraycopy(byArray2, 0, this.nodeIpv6InterfaceName, 0, n2);
    }

    public int getSignalNumber() {
        return 66304;
    }

    public void initReceive() {
    }

    public void initSend() {
        SignalOutputStream signalOutputStream = this.getSignalOutputStream();
        try {
            signalOutputStream.writeU32((long)this.txId);
            for (int i = 0; i < this.conftags.length; ++i) {
                signalOutputStream.writeU32((long)this.conftags[i]);
                if (this.conftags[i] != 19 && this.conftags[i] != 21 || this.conftags[i + 1] == 0) continue;
                signalOutputStream.writeU32((long)this.conftags[i + 1]);
                if (this.conftags[i] == 19) {
                    signalOutputStream.writeS8Array(this.nodeInterfaceName);
                } else if (this.conftags[i] == 21) {
                    signalOutputStream.writeS8Array(this.nodeIpv6InterfaceName);
                } else {
                    MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("Unexcepted conftag in signal: " + this.conftags[i]));
                }
                ++i;
            }
            signalOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

