/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement;

import java.util.Arrays;
import java.util.List;
import se.ericsson.cello.equipment.MultipleSwAllocationsAllowed;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.transaction.Coordinator;

public class SlotConfigurationValidator {
    public static void checkIfAddSlotAllowed(MultipleSwAllocationsAllowed multipleSwAllocationsAllowed, SwAllocationMo swAllocationMo, Coordinator coordinator) throws OperationNotAllowedException, MoAccessException {
        ManagedObject[] managedObjectArray = multipleSwAllocationsAllowed.getSwAllocations(coordinator);
        if (managedObjectArray.length > 0) {
            if (!SlotConfigurationValidator.arePiuTypeSetsEqual(swAllocationMo, coordinator)) {
                throw new OperationNotAllowedException("Reserve of MO " + multipleSwAllocationsAllowed.getLocalDistinguishedName() + " by SwAllocation " + swAllocationMo.getLocalDistinguishedName() + " failed. The Repertoires of the SwAllocation do not have the same PiuType set. This is only allowed when the MO to be reserved is not reserved by other SwAllocation(s).", swAllocationMo.getType());
            }
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!SlotConfigurationValidator.arePiuTypeSetsEqual((SwAllocationMo)managedObjectArray[i], coordinator)) {
                    throw new OperationNotAllowedException("Reserve of MO " + multipleSwAllocationsAllowed.getLocalDistinguishedName() + " by SwAllocation " + swAllocationMo.getLocalDistinguishedName() + " failed. The MO is reserved by the SwAllocation " + managedObjectArray[i].getLocalDistinguishedName() + ". The Repertoires of that SwAllocation do not have the same PiuType set, and hence the MO can not be reserved by other SwAllocation(s).", swAllocationMo.getType());
                }
                if (SlotConfigurationValidator.areFirstPiuTypeSetsDisjoint(swAllocationMo, (SwAllocationMo)managedObjectArray[i], coordinator)) continue;
                throw new OperationNotAllowedException("Reserve of MO " + multipleSwAllocationsAllowed.getLocalDistinguishedName() + " by SwAllocation " + swAllocationMo.getLocalDistinguishedName() + " failed. The SwAllocation refers to PiuType(s) already included in reserving SwAllocation " + managedObjectArray[i].getLocalDistinguishedName(), swAllocationMo.getType());
            }
        }
    }

    public static void checkIfAddRepertoireAllowed(RepertoireMo repertoireMo, SwAllocationMo swAllocationMo, Coordinator coordinator) throws OperationNotAllowedException, MoAccessException {
        ManagedObject[] managedObjectArray = swAllocationMo.getSlotList(coordinator);
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            ManagedObject[] managedObjectArray2;
            if (!(managedObjectArray[i] instanceof MultipleSwAllocationsAllowed) || (managedObjectArray2 = ((MultipleSwAllocationsAllowed)managedObjectArray[i]).getSwAllocations(coordinator)).length <= 1) continue;
            bl = true;
            n = i;
            break;
        }
        if (bl) {
            ManagedObject[] managedObjectArray3 = swAllocationMo.getRepertoireList(coordinator);
            if (managedObjectArray3.length > 0) {
                if (!SlotConfigurationValidator.arePiuTypeSetsEqual(repertoireMo, (RepertoireMo)managedObjectArray3[0], coordinator)) {
                    throw new OperationNotAllowedException("Adding Repertoire " + repertoireMo.getLocalDistinguishedName() + " to SwAllocation " + swAllocationMo.getLocalDistinguishedName() + " failed. The PiuType set of the Repertoire has to be the same as for existing Repertoires reserved by this SwAllocation (valid when the slotList of the SwAllocation contains Mo(s) reserved by several SwAllocations).", swAllocationMo.getType());
                }
            } else {
                for (int i = n; i < managedObjectArray.length; ++i) {
                    if (!(managedObjectArray[i] instanceof MultipleSwAllocationsAllowed)) continue;
                    ManagedObject[] managedObjectArray4 = ((MultipleSwAllocationsAllowed)managedObjectArray[i]).getSwAllocations(coordinator);
                    for (int j = 0; j < managedObjectArray4.length; ++j) {
                        if (SlotConfigurationValidator.areFirstPiuTypeSetsDisjoint((SwAllocationMo)managedObjectArray4[j], repertoireMo, coordinator)) continue;
                        throw new OperationNotAllowedException("Adding Repertoire " + repertoireMo.getLocalDistinguishedName() + " to SwAllocation " + swAllocationMo.getLocalDistinguishedName() + " failed. PiuType(s) in the Repertoire are not unique for MO " + managedObjectArray[i].getLocalDistinguishedName() + ", but are included in Repertoires under SwAllocation " + managedObjectArray4[j].getLocalDistinguishedName(), swAllocationMo.getType());
                    }
                }
            }
        }
    }

    private static boolean areFirstPiuTypeSetsDisjoint(SwAllocationMo swAllocationMo, SwAllocationMo swAllocationMo2, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = swAllocationMo.getRepertoireList(coordinator);
        ManagedObject[] managedObjectArray2 = swAllocationMo2.getRepertoireList(coordinator);
        if (managedObjectArray.length > 0 && managedObjectArray2.length > 0) {
            return SlotConfigurationValidator.arePiuTypeSetsDisjoint((RepertoireMo)managedObjectArray[0], (RepertoireMo)managedObjectArray2[0], coordinator);
        }
        return true;
    }

    private static boolean arePiuTypeSetsDisjoint(RepertoireMo repertoireMo, RepertoireMo repertoireMo2, Coordinator coordinator) throws MoAccessException {
        boolean bl = true;
        ManagedObject[] managedObjectArray = repertoireMo.getPiuTypeList(coordinator);
        ManagedObject[] managedObjectArray2 = repertoireMo2.getPiuTypeList(coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            for (int j = 0; j < managedObjectArray2.length; ++j) {
                if (!managedObjectArray[i].equals(managedObjectArray2[j])) continue;
                bl = false;
            }
        }
        return bl;
    }

    private static boolean areFirstPiuTypeSetsDisjoint(SwAllocationMo swAllocationMo, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = swAllocationMo.getRepertoireList(coordinator);
        if (managedObjectArray.length > 0) {
            return SlotConfigurationValidator.arePiuTypeSetsDisjoint((RepertoireMo)managedObjectArray[0], (RepertoireMo)managedObject, coordinator);
        }
        return true;
    }

    private static boolean arePiuTypeSetsEqual(SwAllocationMo swAllocationMo, Coordinator coordinator) throws MoAccessException {
        boolean bl = true;
        ManagedObject[] managedObjectArray = swAllocationMo.getRepertoireList(coordinator);
        if (managedObjectArray.length > 1) {
            RepertoireMo repertoireMo = (RepertoireMo)managedObjectArray[0];
            for (int i = 1; i < managedObjectArray.length && (bl = SlotConfigurationValidator.arePiuTypeSetsEqual((RepertoireMo)managedObjectArray[i], repertoireMo, coordinator)); ++i) {
            }
        }
        return bl;
    }

    private static boolean arePiuTypeSetsEqual(RepertoireMo repertoireMo, RepertoireMo repertoireMo2, Coordinator coordinator) throws MoAccessException {
        List<ManagedObject> list;
        List<ManagedObject> list2;
        ManagedObject[] managedObjectArray;
        boolean bl = false;
        ManagedObject[] managedObjectArray2 = repertoireMo.getPiuTypeList(coordinator);
        if (managedObjectArray2.length == (managedObjectArray = repertoireMo2.getPiuTypeList(coordinator)).length && (list2 = Arrays.asList(managedObjectArray2)).containsAll(list = Arrays.asList(managedObjectArray)) && list.containsAll(list2)) {
            bl = true;
        }
        return bl;
    }
}

