/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.digests;

import com.maverick.crypto.digests.Digest;
import com.maverick.crypto.digests.HMac;

public class GeneralHMac
implements HMac {
    private Digest f;
    private int c;
    private int e;
    private byte[] b = new byte[64];
    private byte[] d = new byte[64];

    public GeneralHMac(Digest digest) {
        this.f = digest;
        this.e = this.c = digest.getDigestSize();
    }

    public GeneralHMac(Digest digest, int n) {
        this.f = digest;
        this.c = digest.getDigestSize();
        this.e = n;
    }

    public String getAlgorithmName() {
        return this.f.getAlgorithmName() + "/HMAC";
    }

    public int getOutputSize() {
        return this.e;
    }

    public Digest getUnderlyingDigest() {
        return this.f;
    }

    public void init(byte[] byArray) {
        int n;
        this.f.reset();
        if (byArray.length > 64) {
            this.f.update(byArray, 0, byArray.length);
            this.f.doFinal(this.b, 0);
            for (n = this.c; n < this.b.length; ++n) {
                this.b[n] = 0;
            }
        } else {
            System.arraycopy(byArray, 0, this.b, 0, byArray.length);
            for (n = byArray.length; n < this.b.length; ++n) {
                this.b[n] = 0;
            }
        }
        this.d = new byte[this.b.length];
        System.arraycopy(this.b, 0, this.d, 0, this.b.length);
        n = 0;
        while (n < this.b.length) {
            int n2 = n++;
            this.b[n2] = (byte)(this.b[n2] ^ 0x36);
        }
        n = 0;
        while (n < this.d.length) {
            int n3 = n++;
            this.d[n3] = (byte)(this.d[n3] ^ 0x5C);
        }
        this.f.update(this.b, 0, this.b.length);
    }

    public int getMacSize() {
        return this.c;
    }

    public void update(byte by) {
        this.f.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.f.update(byArray, n, n2);
    }

    public int doFinal(byte[] byArray, int n) {
        byte[] byArray2 = new byte[this.c];
        this.f.doFinal(byArray2, 0);
        this.f.update(this.d, 0, this.d.length);
        this.f.update(byArray2, 0, byArray2.length);
        int n2 = this.f.doFinal(byArray, n);
        this.reset();
        return n2;
    }

    public void reset() {
        this.f.reset();
        this.f.update(this.b, 0, this.b.length);
    }
}

