/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.sftp;

import com.maverick.sftp.SftpFileAttributes;
import com.maverick.sftp.SftpStatusException;
import com.maverick.sftp.SftpSubsystemChannel;
import com.maverick.ssh.SshException;

public class SftpFile {
    String c;
    byte[] g;
    SftpFileAttributes d;
    SftpSubsystemChannel e;
    String b;
    String f;

    public SftpFile(String string, SftpFileAttributes sftpFileAttributes) {
        this.b = string;
        this.d = sftpFileAttributes;
        if (this.b.equals("/")) {
            this.c = "/";
        } else {
            int n;
            this.b = this.b.trim();
            if (this.b.endsWith("/")) {
                this.b = this.b.substring(0, this.b.length() - 1);
            }
            this.c = (n = this.b.lastIndexOf(47)) > -1 ? this.b.substring(n + 1) : this.b;
        }
    }

    public SftpFile getParent() throws SshException, SftpStatusException {
        if (this.b.lastIndexOf(47) == -1) {
            String string = this.e.getDefaultDirectory();
            return this.e.getFile(string);
        }
        String string = this.e.getAbsolutePath(this.b);
        if (string.equals("/")) {
            return null;
        }
        if (this.c.equals(".") || this.c.equals("..")) {
            return this.e.getFile(string).getParent();
        }
        int n = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        if (string2.equals("")) {
            string2 = "/";
        }
        return this.e.getFile(string2);
    }

    public String toString() {
        return this.b;
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    public String getLongname() {
        return this.f;
    }

    public boolean equals(Object object) {
        if (object instanceof SftpFile) {
            boolean bl = ((SftpFile)object).getAbsolutePath().equals(this.b);
            if (this.g == null && ((SftpFile)object).g == null) {
                return bl;
            }
            if (this.g != null && ((SftpFile)object).g != null) {
                for (int k = 0; k < this.g.length; ++k) {
                    if (((SftpFile)object).g[k] == this.g[k]) continue;
                    return false;
                }
            }
            return bl;
        }
        return false;
    }

    public void delete() throws SftpStatusException, SshException {
        if (this.e == null) {
            throw new SshException("Instance not connected to SFTP subsystem", 4);
        }
        if (this.isDirectory()) {
            this.e.removeDirectory(this.getAbsolutePath());
        } else {
            this.e.removeFile(this.getAbsolutePath());
        }
    }

    public boolean canWrite() throws SftpStatusException, SshException {
        return (this.getAttributes().getPermissions().longValue() & 0x80L) == 128L;
    }

    public boolean canRead() throws SftpStatusException, SshException {
        return (this.getAttributes().getPermissions().longValue() & 0x100L) == 256L;
    }

    public boolean isOpen() {
        if (this.e == null) {
            return false;
        }
        return this.e.c(this.g);
    }

    void b(byte[] byArray) {
        this.g = byArray;
    }

    public byte[] getHandle() {
        return this.g;
    }

    void b(SftpSubsystemChannel sftpSubsystemChannel) {
        this.e = sftpSubsystemChannel;
    }

    public SftpSubsystemChannel getSFTPChannel() {
        return this.e;
    }

    public String getFilename() {
        return this.c;
    }

    public SftpFileAttributes getAttributes() throws SftpStatusException, SshException {
        if (this.d == null) {
            this.d = this.e.getAttributes(this.getAbsolutePath());
        }
        return this.d;
    }

    public String getAbsolutePath() {
        return this.b;
    }

    public void close() throws SftpStatusException, SshException {
        this.e.closeFile(this);
    }

    public boolean isDirectory() throws SftpStatusException, SshException {
        return this.getAttributes().isDirectory();
    }

    public boolean isFile() throws SftpStatusException, SshException {
        return this.getAttributes().isFile();
    }

    public boolean isLink() throws SftpStatusException, SshException {
        return this.getAttributes().isLink();
    }

    public boolean isFifo() throws SftpStatusException, SshException {
        return (this.getAttributes().getPermissions().longValue() & 0x1000L) == 4096L;
    }

    public boolean isBlock() throws SftpStatusException, SshException {
        return (this.getAttributes().getPermissions().longValue() & 0x6000L) == 24576L;
    }

    public boolean isCharacter() throws SftpStatusException, SshException {
        return (this.getAttributes().getPermissions().longValue() & 0x2000L) == 8192L;
    }

    public boolean isSocket() throws SftpStatusException, SshException {
        return (this.getAttributes().getPermissions().longValue() & 0xC000L) == 49152L;
    }
}

