/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.sftp;

import com.maverick.sftp.SftpFile;
import com.maverick.sftp.SftpMessage;
import com.maverick.sftp.SftpStatusException;
import com.maverick.sftp.SftpSubsystemChannel;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import com.maverick.util.UnsignedInteger32;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class SftpFileInputStream
extends InputStream {
    SftpFile g;
    SftpSubsystemChannel f;
    long c;
    Vector b = new Vector();
    SftpMessage h;
    int e;
    long d;

    public SftpFileInputStream(SftpFile sftpFile) throws SftpStatusException, SshException {
        this(sftpFile, 0L);
    }

    public SftpFileInputStream(SftpFile sftpFile, long l) throws SftpStatusException, SshException {
        if (sftpFile.getHandle() == null) {
            throw new SftpStatusException(100, "The file does not have a valid handle!");
        }
        if (sftpFile.getSFTPChannel() == null) {
            throw new SshException("The file is not attached to an SFTP subsystem!", 4);
        }
        this.g = sftpFile;
        this.c = l;
        this.f = sftpFile.getSFTPChannel();
        this.d = sftpFile.getAttributes().getSize().longValue() - l;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            int n3 = 0;
            int n4 = n2;
            while (n3 < n4 && n3 != -1) {
                this.b();
                if (this.h == null || this.e == 0) {
                    UnsignedInteger32 unsignedInteger32 = (UnsignedInteger32)this.b.elementAt(0);
                    this.h = this.f.c(unsignedInteger32);
                    this.b.removeElementAt(0);
                    if (this.h.getType() == 103) {
                        this.e = (int)this.h.readInt();
                    } else {
                        if (this.h.getType() == 101) {
                            int n5 = (int)this.h.readInt();
                            if (n5 == 1) {
                                if (n3 != 0) break;
                                n3 = -1;
                                break;
                            }
                            if (this.f.getVersion() >= 3) {
                                String string = this.h.readString().trim();
                                throw new IOException(string);
                            }
                            throw new IOException("");
                        }
                        this.close();
                        throw new IOException("The server responded with an unexpected SFTP protocol message! type=" + this.h.getType());
                    }
                }
                if (this.h == null) {
                    throw new IOException("Failed to obtain file data or status from the SFTP server!");
                }
                int n6 = Math.min(this.e, n2);
                System.arraycopy(this.h.array(), this.h.getPosition(), byArray, n, n6);
                this.e -= n6;
                this.h.skip(n6);
                n3 += n6;
                n2 -= n6;
                n += n6;
            }
            return n3;
        }
        catch (SshException sshException) {
            throw new SshIOException(sshException);
        }
        catch (SftpStatusException sftpStatusException) {
            throw new IOException(sftpStatusException.getMessage());
        }
    }

    private void b() throws SftpStatusException, SshException {
        while (this.b.size() < 100) {
            this.b.addElement(this.f.postReadRequest(this.g.getHandle(), this.c, 32768));
            this.c += 32768L;
        }
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray) == 1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    public void close() throws IOException {
        try {
            this.g.close();
            while (this.b.size() > 0) {
                UnsignedInteger32 unsignedInteger32 = (UnsignedInteger32)this.b.elementAt(0);
                this.b.removeElementAt(0);
                this.f.c(unsignedInteger32);
            }
        }
        catch (SshException sshException) {
            throw new SshIOException(sshException);
        }
        catch (SftpStatusException sftpStatusException) {
            throw new IOException(sftpStatusException.getMessage());
        }
    }

    protected void finalize() throws IOException {
        if (this.g.getHandle() != null) {
            this.close();
        }
    }
}

