/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.message;

import com.maverick.events.EventLog;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import com.maverick.ssh.message.Message;
import com.maverick.ssh.message.MessageHolder;
import com.maverick.ssh.message.MessageObserver;
import com.maverick.ssh.message.SshAbstractChannel;
import com.maverick.ssh.message.SshChannelMessage;
import com.maverick.ssh.message.SshMessage;
import com.maverick.ssh.message.SshMessageReader;
import com.maverick.ssh.message.SshMessageStore;
import com.maverick.ssh.message.ThreadSynchronizer;
import java.util.Vector;

public abstract class SshMessageRouter {
    private SshAbstractChannel[] kc;
    SshMessageReader lc;
    SshMessageStore fc;
    ThreadSynchronizer nc;
    private int mc = 0;
    boolean ic;
    _b gc;
    boolean oc = false;
    Vector jc = new Vector();
    Vector hc = new Vector();

    public SshMessageRouter(SshMessageReader sshMessageReader, int n, boolean bl) {
        this.lc = sshMessageReader;
        this.ic = bl;
        this.kc = new SshAbstractChannel[n];
        this.fc = new SshMessageStore(this, null, new MessageObserver(){

            public boolean wantsNotification(Message message) {
                return false;
            }
        });
        this.nc = new ThreadSynchronizer(bl);
        if (bl) {
            this.gc = new _b();
            this.nc.b = this.gc;
            this.gc.setDaemon(true);
        }
    }

    public void start() {
        EventLog.LogEvent(this, "starting message pump");
        if (this.gc != null && !this.gc.b()) {
            String string = "";
            String string2 = Thread.currentThread().getName();
            if (string2.indexOf(45) > -1) {
                string = string2.substring(0, 1 + string2.indexOf(45));
            }
            this.gc.setName(string + "MessagePump_" + this.gc.getName());
            this.gc.start();
            EventLog.LogEvent(this, "message pump started thread name:" + this.gc.getName());
        }
    }

    public void addShutdownHook(Runnable runnable) {
        if (runnable != null) {
            this.hc.addElement(runnable);
        }
    }

    public boolean isBuffered() {
        return this.ic;
    }

    public void stop() {
        this.signalClosingState();
        if (this.gc != null) {
            this.gc.c();
        }
        for (int k = 0; k < this.hc.size(); ++k) {
            try {
                ((Runnable)this.hc.elementAt(k)).run();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalClosingState() {
        if (this.ic && this.gc != null) {
            _b _b2 = this.gc;
            synchronized (_b2) {
                this.oc = true;
            }
        }
    }

    protected SshMessageStore getGlobalMessages() {
        return this.fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int allocateChannel(SshAbstractChannel sshAbstractChannel) {
        SshAbstractChannel[] sshAbstractChannelArray = this.kc;
        synchronized (this.kc) {
            for (int k = 0; k < this.kc.length; ++k) {
                if (this.kc[k] != null) continue;
                this.kc[k] = sshAbstractChannel;
                this.jc.addElement(sshAbstractChannel);
                ++this.mc;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return k;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeChannel(SshAbstractChannel sshAbstractChannel) {
        SshAbstractChannel[] sshAbstractChannelArray = this.kc;
        synchronized (this.kc) {
            if (this.kc[sshAbstractChannel.getChannelId()] != null && sshAbstractChannel.equals(this.kc[sshAbstractChannel.getChannelId()])) {
                this.kc[sshAbstractChannel.getChannelId()] = null;
                this.jc.removeElement(sshAbstractChannel);
                --this.mc;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected SshAbstractChannel[] getActiveChannels() {
        return this.jc.toArray(new SshAbstractChannel[0]);
    }

    protected int maximumChannels() {
        return this.kc.length;
    }

    public int getChannelCount() {
        return this.mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SshMessage nextMessage(SshAbstractChannel sshAbstractChannel, MessageObserver messageObserver) throws SshException, InterruptedException {
        SshMessageStore sshMessageStore = sshAbstractChannel == null ? this.fc : sshAbstractChannel.getMessageStore();
        EventLog.LogEvent(this, "using " + (sshAbstractChannel == null ? "global store" : "channel store"));
        MessageHolder messageHolder = new MessageHolder();
        while (messageHolder.msg == null) {
            if (this.ic && this.gc != null) {
                EventLog.LogEvent(this, "waiting for messagePump lock");
                _b _b2 = this.gc;
                synchronized (_b2) {
                    if (!this.oc && this.gc.c != null) {
                        Throwable throwable = this.gc.c;
                        this.gc.c = null;
                        if (throwable instanceof SshException) {
                            EventLog.LogEvent(this, "messagePump has SshException this will be caught by customer code");
                            throw (SshException)throwable;
                        }
                        if (throwable instanceof SshIOException) {
                            EventLog.LogEvent(this, "messagePump has SshIOException this will be caught by customer code");
                            throw ((SshIOException)throwable).getRealException();
                        }
                        EventLog.LogEvent(this, "messagePump has some other exception this will be caught by customer code");
                        throw new SshException(throwable);
                    }
                }
            }
            if (!this.nc.requestBlock(sshMessageStore, messageObserver, messageHolder)) continue;
            try {
                EventLog.LogEvent(this, "block for message");
                this.d();
            }
            finally {
                this.nc.releaseBlock();
            }
        }
        return (SshMessage)messageHolder.msg;
    }

    public boolean isBlockingThread(Thread thread) {
        return this.nc.isBlockOwner(thread);
    }

    private void d() throws SshException {
        boolean bl;
        SshMessage sshMessage = this.createMessage(this.lc.nextMessage());
        EventLog.LogEvent(this, "read next message");
        SshAbstractChannel sshAbstractChannel = null;
        if (sshMessage instanceof SshChannelMessage) {
            sshAbstractChannel = this.kc[((SshChannelMessage)sshMessage).b()];
        }
        boolean bl2 = bl = sshAbstractChannel == null ? this.processGlobalMessage(sshMessage) : sshAbstractChannel.processChannelMessage((SshChannelMessage)sshMessage);
        if (!bl) {
            SshMessageStore sshMessageStore = sshAbstractChannel == null ? this.fc : sshAbstractChannel.getMessageStore();
            sshMessageStore.c(sshMessage);
        }
    }

    protected abstract void onThreadExit();

    protected abstract SshMessage createMessage(byte[] var1) throws SshException;

    protected abstract boolean processGlobalMessage(SshMessage var1) throws SshException;

    class _b
    extends Thread {
        Throwable c;
        boolean b = false;

        _b() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.b = true;
                while (this.b) {
                    try {
                        SshMessageRouter.this.d();
                        SshMessageRouter.this.nc.releaseWaiting();
                    }
                    catch (Throwable throwable) {
                        _b _b2 = this;
                        synchronized (_b2) {
                            if (!SshMessageRouter.this.oc) {
                                EventLog.LogEvent(this, "Message pump caught exception: " + throwable.getMessage());
                                this.c = throwable;
                            }
                            this.c();
                        }
                    }
                }
                SshMessageRouter.this.nc.releaseBlock();
            }
            finally {
                SshMessageRouter.this.onThreadExit();
            }
        }

        public void c() {
            this.b = false;
            if (!Thread.currentThread().equals(this)) {
                this.interrupt();
            }
        }

        public boolean b() {
            return this.b;
        }
    }
}

