/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.util;

import java.math.BigInteger;

public class UnsignedInteger64 {
    public static final BigInteger MAX_VALUE = new BigInteger("18446744073709551615");
    public static final BigInteger MIN_VALUE = new BigInteger("0");
    private BigInteger b;

    public UnsignedInteger64(String string) throws NumberFormatException {
        this.b = new BigInteger(string);
        if (this.b.compareTo(MIN_VALUE) < 0 || this.b.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
    }

    public UnsignedInteger64(byte[] byArray) throws NumberFormatException {
        this.b = new BigInteger(byArray);
        if (this.b.compareTo(MIN_VALUE) < 0 || this.b.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
    }

    public UnsignedInteger64(long l) {
        this.b = BigInteger.valueOf(l);
    }

    public UnsignedInteger64(BigInteger bigInteger) {
        this.b = new BigInteger(bigInteger.toString());
        if (this.b.compareTo(MIN_VALUE) < 0 || this.b.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            UnsignedInteger64 unsignedInteger64 = (UnsignedInteger64)object;
            return unsignedInteger64.b.equals(this.b);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public BigInteger bigIntValue() {
        return this.b;
    }

    public long longValue() {
        return this.b.longValue();
    }

    public String toString() {
        return this.b.toString(10);
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    public static UnsignedInteger64 add(UnsignedInteger64 unsignedInteger64, UnsignedInteger64 unsignedInteger642) {
        return new UnsignedInteger64(unsignedInteger64.b.add(unsignedInteger642.b));
    }

    public static UnsignedInteger64 add(UnsignedInteger64 unsignedInteger64, int n) {
        return new UnsignedInteger64(unsignedInteger64.b.add(BigInteger.valueOf(n)));
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[8];
        byte[] byArray2 = this.bigIntValue().toByteArray();
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        return byArray;
    }
}

