/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.codec;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import se.ericsson.security.login.codec.CodecException;
import se.ericsson.security.login.codec.CodecFactory;
import se.ericsson.security.login.codec.CodecFactorySpi;
import se.ericsson.security.login.codec.CryptoException;

class PKCS5Provider
extends CodecFactorySpi {
    private static final String PBE_HEADER = "-----BEGIN PBE DATA-----\n";
    private static final String PBE_FOOTER = "\n-----END PBE DATA-----";
    private static final byte[] defaultSalt = new byte[]{-54, -2, -70, -66, -70, -83, 18, 52};

    PKCS5Provider() {
    }

    public byte[] engineEncode(Object object) throws CodecException {
        if (!(object instanceof byte[])) {
            throw new CodecException("Unkown format: " + object.getClass().getName());
        }
        try {
            byte[] byArray = (byte[])object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(PBE_HEADER);
            CodecFactory codecFactory = CodecFactory.getInstance("BASE64");
            stringBuffer.append(codecFactory.encodeAsString(byArray));
            stringBuffer.append(PBE_FOOTER);
            return stringBuffer.toString().getBytes(this.getCharacterEncoding());
        }
        catch (IOException iOException) {
            throw new CodecException("Could not encode PBE data", iOException);
        }
    }

    public byte[] engineEncodeAndEncrypt(Object object, char[] cArray) throws CodecException {
        if (!(object instanceof byte[])) {
            throw new CodecException("Unkown format: " + object.getClass().getName());
        }
        try {
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(defaultSalt, 3);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES", "SunJCE");
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            Cipher cipher = Cipher.getInstance("PBEWithMD5AndDES", "SunJCE");
            cipher.init(1, (Key)secretKey, pBEParameterSpec);
            byte[] byArray = cipher.doFinal((byte[])object);
            return this.engineEncode(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException("Failed to encrypt data.", generalSecurityException);
        }
    }

    public Object engineDecode(byte[] byArray) throws CodecException {
        try {
            String string = new String(byArray, this.getCharacterEncoding());
            int n = string.indexOf(PBE_HEADER);
            if (n < 0) {
                throw new CodecException("Could not find PBE header");
            }
            int n2 = string.indexOf(PBE_FOOTER);
            if (n2 < 0) {
                throw new CodecException("Could not find PBE footer");
            }
            int n3 = n + PBE_HEADER.length();
            CodecFactory codecFactory = CodecFactory.getInstance("BASE64");
            return codecFactory.decode(string.substring(n3, n2));
        }
        catch (IOException iOException) {
            throw new CodecException("Could not decode PBE data", iOException);
        }
    }

    public Object engineDecodeAndDecrypt(byte[] byArray, char[] cArray) throws CodecException {
        byte[] byArray2 = (byte[])this.engineDecode(byArray);
        try {
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(defaultSalt, 3);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            Cipher cipher = Cipher.getInstance("PBEWithMD5AndDES");
            cipher.init(2, (Key)secretKey, pBEParameterSpec);
            return cipher.doFinal(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException("Failed to decrypt data.", generalSecurityException);
        }
    }
}

