/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.login;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.swing.JOptionPane;
import se.ericsson.security.login.Log;
import se.ericsson.security.login.LoginContext;
import se.ericsson.security.login.LoginServicesFactory;
import se.ericsson.security.login.SSULocalizer;
import se.ericsson.security.login.creds.Credentials;
import se.ericsson.security.login.login.CancelledLoginException;
import se.ericsson.security.login.login.FileProxy;
import se.ericsson.security.login.login.LoginCauseException;
import se.ericsson.security.login.login.LoginProxy;
import se.ericsson.security.login.login.SLSProxy;
import se.ericsson.security.login.login.SendReceiveOnHttps;
import se.ericsson.security.login.login.SlsPrincipal;

public class LoginModuleImpl
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private static Log logger = Log.getInstance();
    private SlsPrincipal slsPrincipal;
    private LoginProxy loginProxy;
    private boolean loginSucceeded = false;
    private boolean commitSucceeded = false;
    private NameCallback nameCallback = null;
    private PasswordCallback passwordCallback = null;
    private ConfirmationCallback confirmationCallback = null;
    private ConfirmationCallback optionsCallback = null;
    private Callback[] callbacks;
    private String username;
    private URL[] urls;
    private File samFile;
    private File nmFile;
    private static final char[] ssuPwd = "secmgmt".toCharArray();
    private int loginMode = 1;
    private long modificationTime = 0L;
    private boolean onlySAMLoginPossible = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.samFile = (File)map2.get("SAMFile");
        this.nmFile = (File)map2.get("NMFile");
        this.urls = (URL[])map2.get("SLSURLs");
        SendReceiveOnHttps.setTimeOut((Number)map2.get("SLSTimeout"));
        if (this.urls == null) {
            this.onlySAMLoginPossible = true;
        }
    }

    private void setLoginRecordInLC(int n, long l) {
        LoginContext loginContext = (LoginContext)LoginServicesFactory.getLoginServices();
        loginContext.setLoginRecord(n, l);
    }

    public boolean login() throws LoginException {
        block41: {
            boolean bl = false;
            boolean bl2 = System.getProperty("se.ericsson.security.ssu.ssucredentialfile") != null;
            boolean bl3 = Boolean.getBoolean("se.ericsson.security.ssu.autologin");
            this.loginSucceeded = false;
            if (LoginContext.isFirstTimeLogin()) {
                if (this.isReadable(this.nmFile)) {
                    if (bl3 || this.isSLSAvailable()) {
                        bl = true;
                    } else if (!bl3 && this.isReadable(this.samFile)) {
                        JOptionPane.showMessageDialog(null, SSULocalizer.getString("sls_not_responding") + "." + SSULocalizer.getString("login_using_SAM"), null, -1);
                        this.onlySAMLoginPossible = true;
                    }
                }
            } else if (LoginContext.getLoginMode() == 0) {
                JOptionPane.showMessageDialog(null, SSULocalizer.getString("newer_sampbe_detected") + "." + SSULocalizer.getString("provide_login_data"), null, -1);
                this.onlySAMLoginPossible = true;
            } else if (this.isReadable(this.nmFile)) {
                bl = true;
            }
            if (bl) {
                this.loginUsingStoredCredentials();
            }
            if (this.loginSucceeded) {
                this.setLoginRecordInLC(this.loginMode, this.modificationTime);
                return this.loginSucceeded;
            }
            if (this.callbackHandler == null) {
                throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
            }
            if (this.onlySAMLoginPossible) {
                if (!this.isReadable(this.samFile)) {
                    throw new LoginException("Not possible to log in. Single Logon Servers are not responding and no Stand Alone Credentials exists.");
                }
                this.passwordCallback = new PasswordCallback(SSULocalizer.getString("Passwd") + ": ", false);
                this.confirmationCallback = new ConfirmationCallback(0, 2, 3);
                this.callbacks = new Callback[]{this.passwordCallback, this.confirmationCallback};
            } else if (this.callbacks == null && !bl2) {
                if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                    System.out.println(new Date().toString() + " creating callbacks for given username and password");
                }
                this.nameCallback = new NameCallback(SSULocalizer.getString("username") + ": ");
                this.passwordCallback = new PasswordCallback(SSULocalizer.getString("Passwd") + ": ", false);
                this.confirmationCallback = new ConfirmationCallback(0, 2, 3);
                this.optionsCallback = null;
                if (!Boolean.getBoolean("se.ericsson.security.onapplicationserver")) {
                    boolean bl4 = false;
                    try {
                        bl4 = this.samFile != null && this.samFile.isFile() && this.samFile.canRead();
                    }
                    catch (SecurityException securityException) {
                        logger.error("Don't have permission to read " + this.samFile, securityException);
                    }
                    String[] stringArray = bl4 ? new String[]{SSULocalizer.getString("network_mode"), SSULocalizer.getString("stand_alone_mode")} : new String[]{SSULocalizer.getString("network_mode")};
                    this.optionsCallback = new ConfirmationCallback(SSULocalizer.getString("choose_login_mode"), 0, stringArray, 0);
                    this.callbacks = new Callback[]{this.nameCallback, this.passwordCallback, this.confirmationCallback, this.optionsCallback};
                } else {
                    this.callbacks = new Callback[]{this.nameCallback, this.passwordCallback, this.confirmationCallback};
                }
            }
            if (!bl2) break block41;
            if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " Returning false because login using file " + System.getProperty("se.ericsson.security.ssu.ssucredentialfile") + " failed");
            }
            boolean bl5 = false;
            Object var8_12 = null;
            if (this.passwordCallback != null) {
                this.passwordCallback.clearPassword();
            }
            return bl5;
        }
        try {
            block42: {
                try {
                    char[] cArray;
                    this.callbackHandler.handle(this.callbacks);
                    int n = this.confirmationCallback.getSelectedIndex();
                    if (n != 3) {
                        this.loginSucceeded = false;
                        throw new CancelledLoginException("Login Cancelled");
                    }
                    if (this.nameCallback != null) {
                        this.username = this.nameCallback.getName();
                        if (this.username == null) {
                            this.username = "";
                        }
                        if (!this.username.equals("")) {
                            System.setProperty("ssu.user.name", this.username);
                        }
                    } else {
                        this.username = "";
                    }
                    if ((cArray = this.passwordCallback.getPassword()) == null) {
                        cArray = new char[]{};
                    }
                    if (!(this.onlySAMLoginPossible || this.optionsCallback != null && this.optionsCallback.getSelectedIndex() != 0)) {
                        this.loginProxy = new SLSProxy(this.urls, this.nmFile, ssuPwd);
                        this.loginMode = 1;
                    } else if (this.samFile != null && this.samFile.isFile()) {
                        this.loginMode = 0;
                        this.modificationTime = this.samFile.lastModified();
                        this.loginProxy = new FileProxy(this.samFile, "SAM");
                        this.setLoginRecordInLC(this.loginMode, this.modificationTime);
                    } else {
                        logger.error("Prepare for Standalone Mode is not supported. Use SLS Web interface to obtain sam.pbe.");
                    }
                    if (this.loginProxy == null) break block42;
                    this.loginSucceeded = this.loginProxy.authenticateUser(this.username, cArray);
                }
                catch (IOException iOException) {
                    logger.error("Failed to login", iOException);
                    throw new LoginCauseException("Failed to login", iOException);
                }
                catch (UnsupportedCallbackException unsupportedCallbackException) {
                    logger.error("Failed to login", unsupportedCallbackException);
                    throw new LoginCauseException("CallbackHandler did not support the given set of callbacks", unsupportedCallbackException);
                }
            }
            Object var8_13 = null;
            if (this.passwordCallback != null) {
                this.passwordCallback.clearPassword();
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (this.passwordCallback != null) {
                this.passwordCallback.clearPassword();
            }
            throw throwable;
        }
        return this.loginSucceeded;
    }

    private boolean isSLSAvailable() {
        if (this.urls != null) {
            return SendReceiveOnHttps.poll(this.urls);
        }
        return false;
    }

    private void loginUsingStoredCredentials() {
        try {
            this.loginProxy = new FileProxy(this.nmFile, "SSU");
            this.loginSucceeded = this.loginProxy.authenticateUser(null, ssuPwd);
            this.username = System.getProperty("user.name");
            this.loginMode = 1;
            this.modificationTime = this.nmFile.lastModified();
        }
        catch (LoginException loginException) {
            if (Boolean.getBoolean("se.ericsson.security.ssu.autologindebug")) {
                System.out.println(new Date().toString() + " Failed to logon using stored ssu credentials from file " + this.nmFile);
            }
            logger.error("Failed to logon using stored ssu credentials from file " + this.nmFile, loginException);
            this.loginProxy = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit() throws LoginException {
        if (!this.loginSucceeded) {
            return false;
        }
        this.slsPrincipal = new SlsPrincipal(this.username);
        try {
            if (this.subject.getPrincipals().contains(this.slsPrincipal)) {
                logger.warning(this.slsPrincipal + " already added to Subject");
            } else {
                Credentials credentials = this.loginProxy.getCredentials();
                this.slsPrincipal.setTrustedCertificates(credentials.getTrustedCertificates());
                this.slsPrincipal.setProperties(credentials.getProperties());
                this.subject.getPrincipals().add(this.slsPrincipal);
                this.subject.getPrivateCredentials().add(credentials);
                this.subject.getPublicCredentials().add(credentials);
                logger.debug(this.slsPrincipal + " added to Subject");
                if (this.loginProxy instanceof SLSProxy) {
                    this.modificationTime = this.nmFile.lastModified();
                    this.setLoginRecordInLC(this.loginMode, this.modificationTime);
                }
                this.commitSucceeded = true;
            }
            Object var3_2 = null;
            if (this.loginProxy != null) {
                this.loginProxy.shutDown();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.loginProxy != null) {
                this.loginProxy.shutDown();
            }
            throw throwable;
        }
        return this.commitSucceeded;
    }

    public boolean abort() throws LoginException {
        if (!this.loginSucceeded) {
            return false;
        }
        if (!this.commitSucceeded) {
            this.loginSucceeded = false;
            if (this.loginProxy != null) {
                this.loginProxy.shutDown();
            }
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.commitSucceeded) {
            this.subject.getPrincipals().remove(this.slsPrincipal);
        }
        this.loginSucceeded = false;
        this.commitSucceeded = false;
        if (this.loginProxy != null) {
            this.loginProxy.shutDown();
        }
        return true;
    }

    private boolean isReadable(File file) {
        return file != null && file.isFile() && file.canRead();
    }
}

