/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.j9.ssl.Util;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InputStream;

public class HandshakeMessage {
    public static final byte HELLO_REQUEST = 0;
    public static final byte CLIENT_HELLO = 1;
    public static final byte SERVER_HELLO = 2;
    public static final byte CERTIFICATE = 11;
    public static final byte SERVER_KEY_EXCHANGE = 12;
    public static final byte CERTIFICATE_REQUEST = 13;
    public static final byte SERVER_HELLO_DONE = 14;
    public static final byte CERTIFICATE_VERIFY = 15;
    public static final byte CLIENT_KEY_EXCHANGE = 16;
    public static final byte FINISHED = 20;
    public static final byte CHANGE_CIPHER_SPEC = 99;
    public static final byte SSLv2_CLIENT_HELLO = -1;
    private byte type;
    private byte[] rawData;
    private InputStream input;
    private int maxDataAvailable;
    private byte[] twoByteLength = new byte[2];
    private byte[] threeByteLength = new byte[3];
    private int bytesLeft = 0;

    public HandshakeMessage(InputStream input, int capacity) throws IOException {
        this.input = input;
        this.maxDataAvailable = capacity - 4;
        this.initialize();
    }

    private void initialize() throws IOException {
        this.input.mark(1);
        this.type = (byte)this.input.read();
        int result = this.input.read(this.threeByteLength);
        if (result != this.threeByteLength.length) {
            throw new IOException(Msg.getString("K01db"));
        }
        int rawDataLen = (int)Util.getLong(this.threeByteLength, 0, 3);
        if (this.maxDataAvailable < rawDataLen) {
            rawDataLen = this.maxDataAvailable;
        }
        this.rawData = new byte[4 + rawDataLen];
        this.rawData[0] = this.type;
        System.arraycopy((Object)this.threeByteLength, 0, (Object)this.rawData, 1, 3);
        this.input.read(this.rawData, 4, rawDataLen);
        this.input.reset();
        this.input.skip(4L);
        this.bytesLeft = rawDataLen;
    }

    public HandshakeMessage(byte type, byte[] bytes) {
        this.type = type;
        this.rawData = new byte[4 + bytes.length];
        this.rawData[0] = type;
        System.arraycopy((Object)Util.getBytes(bytes.length, 3), 0, (Object)this.rawData, 1, 3);
        System.arraycopy((Object)bytes, 0, (Object)this.rawData, 4, bytes.length);
    }

    public byte[] getBytes() {
        return this.rawData;
    }

    public int read(byte[] buffer) throws IOException {
        if (this.input != null && this.bytesLeft >= buffer.length) {
            this.bytesLeft -= buffer.length;
            return this.input.read(buffer);
        }
        return -1;
    }

    public int read() throws IOException {
        if (this.input != null && this.bytesLeft > 0) {
            --this.bytesLeft;
            return this.input.read();
        }
        return -1;
    }

    public int readLength(int lengthBytes) {
        switch (lengthBytes) {
            case 2: {
                return this.readLength(this.twoByteLength);
            }
            case 3: {
                return this.readLength(this.threeByteLength);
            }
        }
        return -1;
    }

    public byte[] readLongField(int bytesInLength, boolean throwExceptionIfReadFailed) throws IOException {
        int length = this.readLength(bytesInLength);
        return this.readField(length, throwExceptionIfReadFailed);
    }

    public byte[] readShortField(boolean throwExceptionIfReadFailed) throws IOException {
        int length = this.read();
        return this.readField(length, throwExceptionIfReadFailed);
    }

    public byte[] readField(int length, boolean throwExceptionIfReadFailed) throws IOException {
        if (length != -1) {
            try {
                byte[] buffer = new byte[length];
                int result = this.read(buffer);
                if (result != -1) {
                    return buffer;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (throwExceptionIfReadFailed) {
            throw new IOException(Msg.getString("K01db"));
        }
        return null;
    }

    private int readLength(byte[] lengthBuffer) {
        block3: {
            try {
                int result = this.read(lengthBuffer);
                if (result == lengthBuffer.length) break block3;
                return -1;
            }
            catch (IOException e) {
                return -1;
            }
        }
        return (int)Util.getLong(lengthBuffer, 0, lengthBuffer.length);
    }

    public boolean isHelloRequest() {
        return this.type == 0;
    }

    public boolean isFinished() {
        return this.type == 20;
    }

    public boolean isCertificateVerify() {
        return this.type == 15;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        try {
            return this.input.available();
        }
        catch (IOException e) {
            return 0;
        }
    }

    public String toString() {
        switch (this.type) {
            case 11: {
                return "CERTIFICATE";
            }
            case 13: {
                return "CERTIFICATE_REQUEST";
            }
            case 15: {
                return "CERTIFICATE_VERIFY";
            }
            case 99: {
                return "CHANGE_CIPHER_SPEC";
            }
            case 1: {
                return "CLIENT_HELLO";
            }
            case 16: {
                return "CLIENT_KEY_EXCHANGE";
            }
            case 20: {
                return "FINISHED";
            }
            case 0: {
                return "HELLO_REQUEST";
            }
            case 2: {
                return "SERVER_HELLO";
            }
            case 14: {
                return "SERVER_HELLO_DONE";
            }
            case 12: {
                return "SERVER_KEY_EXCHANGE";
            }
        }
        return "UNKNOWN MESSAGE TYPE: " + this.type;
    }

    public int readSSLv2Length() {
        int lsb;
        int msb;
        block5: {
            block4: {
                try {
                    msb = this.read();
                    if (msb != -1) break block4;
                    return -1;
                }
                catch (IOException e) {
                    return -1;
                }
            }
            lsb = this.read();
            if (lsb != -1) break block5;
            return -1;
        }
        return msb << 8 | lsb;
    }

    public boolean isSSLv2ClientHello() {
        return this.type == -1;
    }

    public void skipRemaining() throws IOException {
        while (this.bytesLeft > 0) {
            this.bytesLeft = (int)((long)this.bytesLeft - this.input.skip(this.bytesLeft));
        }
    }
}

