/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.j9.ssl.J9HandshakeException;
import com.ibm.j9.ssl.J9SSLContext;
import com.ibm.j9.ssl.J9SSLSessionContext;
import com.ibm.j9.ssl.SessionState;
import com.ibm.oti.security.provider.CertificateVerifier;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Date;

public class J9DefaultSSLContext
implements J9SSLContext {
    private J9SSLSessionContext sessionTable = new J9SSLSessionContext();
    private boolean sessionCreationEnabled = true;

    public SessionState createSession(String hostName) throws J9HandshakeException {
        if (this.getSessionCreationEnabled()) {
            return this.sessionTable.createSession(hostName);
        }
        throw new J9HandshakeException(Msg.getString("K03b1"));
    }

    public SessionState createSession(byte[] sessionID) throws J9HandshakeException {
        if (this.getSessionCreationEnabled()) {
            return this.sessionTable.createSession(sessionID);
        }
        throw new J9HandshakeException(Msg.getString("K03b1"));
    }

    public void getRandomBytes(byte[] buffer) {
        CL3.rng(null, buffer, 0, buffer.length);
    }

    public void checkServerTrusted(com.ibm.oti.security.provider.X509Certificate[] certChain) throws CertificateException, IOException {
        try {
            CertificateVerifier.verifyCertificateChain(certChain, new Date(), 2);
        }
        catch (IOException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    public void checkClientTrusted(com.ibm.oti.security.provider.X509Certificate[] certChain) throws CertificateException, IOException {
        this.checkServerTrusted(certChain);
    }

    public void addSession(SessionState session) {
        this.sessionTable.addSession(session);
    }

    public SessionState getSession(String hostName) {
        return this.sessionTable.getSession(hostName);
    }

    public SessionState getSession(byte[] sessionID) {
        return this.sessionTable.getSession(sessionID);
    }

    public void removeSession(SessionState session) {
        this.sessionTable.removeSession(session);
    }

    public J9SSLSessionContext getSessionContext() {
        return this.sessionTable;
    }

    public boolean getSessionCreationEnabled() {
        return this.sessionCreationEnabled;
    }

    public void setEnableSessionCreation(boolean sessionCreationAllowed) {
        this.sessionCreationEnabled = sessionCreationAllowed;
    }

    public RSAPrivateCrtKey getPrivateKey(String alias) {
        return null;
    }

    public String chooseClientAlias(String[] keyAlgorithmNames, Principal[] trustedIssuers) {
        throw new UnsupportedOperationException(Msg.getString("K03ab"));
    }

    public String chooseServerAlias(String keyAlgorithmName, Principal[] trustedIssuers) {
        throw new UnsupportedOperationException(Msg.getString("K03ab"));
    }

    public X509Certificate[] getCertificateChain(String alias) {
        throw new UnsupportedOperationException(Msg.getString("K03ab"));
    }

    public X509Certificate[] getAcceptedIssuers() {
        throw new UnsupportedOperationException(Msg.getString("K03ab"));
    }
}

