/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.comm;

import com.ibm.oti.connection.comm.Connection;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InputStream;

final class CommInputStream
extends InputStream {
    private Connection connection;
    private boolean open;
    private byte[] aByte = new byte[1];

    CommInputStream(Connection connection) {
        this.connection = connection;
        this.open = true;
    }

    public int available() throws IOException {
        if (this.open) {
            return this.connection.available();
        }
        throw new IOException(Msg.getString("K0059"));
    }

    public void close() throws IOException {
        if (this.open) {
            this.connection.closeStream(true);
        }
        this.open = false;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.open) {
            if (b != null) {
                if (offset >= 0 && length >= 0 && offset <= b.length && b.length - offset >= length) {
                    return this.connection.read(b, offset, length);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new NullPointerException();
        }
        throw new IOException(Msg.getString("K0059"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        if (this.open) {
            CommInputStream commInputStream = this;
            synchronized (commInputStream) {
                if (this.connection.read(this.aByte, 0, 1) > 0) {
                    return this.aByte[0] & 0xFF;
                }
            }
            return -1;
        }
        throw new IOException(Msg.getString("K0059"));
    }
}

