/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.lang.reflect;

class ProxyCharArrayCache {
    char[][] keyTable;
    int[] valueTable;
    int elementSize;
    int threshold;

    static boolean equals(char[] first, char[] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }

    ProxyCharArrayCache(int initialCapacity) {
        if (initialCapacity < 13) {
            initialCapacity = 13;
        }
        this.elementSize = 0;
        this.threshold = (int)((float)initialCapacity * 0.66f);
        this.keyTable = new char[initialCapacity][];
        this.valueTable = new int[initialCapacity];
    }

    int get(char[] key) {
        int index = this.hashCodeChar(key);
        while (this.keyTable[index] != null) {
            if (ProxyCharArrayCache.equals(this.keyTable[index], key)) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return -1;
    }

    private int hashCodeChar(char[] val) {
        int length = val.length;
        int hash = 0;
        int n = 2;
        int i = 0;
        while (i < length) {
            hash += val[i];
            i += n;
        }
        return (hash & Integer.MAX_VALUE) % this.keyTable.length;
    }

    int put(char[] key, int value) {
        int index = this.hashCodeChar(key);
        while (this.keyTable[index] != null) {
            if (ProxyCharArrayCache.equals(this.keyTable[index], key)) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    private void rehash() {
        ProxyCharArrayCache newHashtable = new ProxyCharArrayCache(this.keyTable.length * 2);
        int i = this.keyTable.length;
        while (--i >= 0) {
            if (this.keyTable[i] == null) continue;
            newHashtable.put(this.keyTable[i], this.valueTable[i]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    int size() {
        return this.elementSize;
    }

    public String toString() {
        int max = this.size();
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        int i = 0;
        while (i < max) {
            if (this.keyTable[i] != null) {
                buf.append(this.keyTable[i]).append("->").append(this.valueTable[i]);
            }
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }
}

