/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.lang.reflect;

import com.ibm.oti.lang.reflect.ProxyCharArrayCache;
import com.ibm.oti.lang.reflect.ProxyClassFile;
import com.ibm.oti.lang.reflect.ProxyConstants;
import com.ibm.oti.lang.reflect.ProxyNameAndTypeCache;
import com.ibm.oti.lang.reflect.ProxyObjectCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class ProxyConstantPool
implements ProxyConstants {
    public static final int UTF8_INITIAL_SIZE = 50;
    public static final int STRING_INITIAL_SIZE = 21;
    public static final int FIELD_INITIAL_SIZE = 7;
    public static final int METHOD_INITIAL_SIZE = 21;
    public static final int INTERFACE_INITIAL_SIZE = 21;
    public static final int CLASS_INITIAL_SIZE = 21;
    public static final int NAMEANDTYPE_INITIAL_SIZE = 21;
    public static final int CONSTANTPOOL_INITIAL_SIZE = 500;
    public static final int CONSTANTPOOL_GROW_SIZE = 1000;
    public ProxyCharArrayCache UTF8Cache = new ProxyCharArrayCache(50);
    ProxyCharArrayCache stringCache = new ProxyCharArrayCache(21);
    ProxyCharArrayCache classNameCache = new ProxyCharArrayCache(21);
    ProxyObjectCache fieldCache = new ProxyObjectCache(7);
    ProxyObjectCache methodCache = new ProxyObjectCache(21);
    ProxyObjectCache interfaceMethodCache = new ProxyObjectCache(21);
    ProxyNameAndTypeCache nameAndTypeCache = new ProxyNameAndTypeCache(21);
    public byte[] poolContent;
    public int currentIndex;
    public int currentOffset;

    ProxyConstantPool(ProxyClassFile classFile) {
        this.poolContent = classFile.header;
        this.currentOffset = classFile.headerOffset;
        this.currentIndex = 1;
    }

    int literalIndex(char[] utf8Constant) {
        int index = this.UTF8Cache.get(utf8Constant);
        if (index < 0) {
            int length;
            this.writeU1(1);
            int savedCurrentOffset = this.currentOffset;
            if (this.currentOffset + 2 >= this.poolContent.length) {
                length = this.poolContent.length;
                this.poolContent = new byte[length + 1000];
                System.arraycopy((Object)this.poolContent, 0, (Object)this.poolContent, 0, length);
            }
            this.currentOffset += 2;
            length = 0;
            int i = 0;
            while (i < utf8Constant.length) {
                char current = utf8Constant[i];
                if (current >= '\u0001' && current <= '\u007f') {
                    this.writeU1(current);
                    ++length;
                } else if (current > '\u07ff') {
                    length += 3;
                    this.writeU1(0xE0 | current >> 12 & 0xF);
                    this.writeU1(0x80 | current >> 6 & 0x3F);
                    this.writeU1(0x80 | current & 0x3F);
                } else {
                    length += 2;
                    this.writeU1(0xC0 | current >> 6 & 0x1F);
                    this.writeU1(0x80 | current & 0x3F);
                }
                ++i;
            }
            if (length >= 65535) {
                this.currentOffset = savedCurrentOffset - 1;
                return -1;
            }
            index = this.UTF8Cache.put(utf8Constant, this.currentIndex++);
            this.poolContent[savedCurrentOffset] = (byte)(length >> 8);
            this.poolContent[savedCurrentOffset + 1] = (byte)length;
        }
        return index;
    }

    int literalIndex(Field aField) {
        int index = this.fieldCache.get(aField);
        if (index < 0) {
            int classIndex = this.typeIndex(aField.getDeclaringClass().getName());
            int nameAndTypeIndex = this.literalIndexForNameAndType(this.literalIndex(aField.getName().toCharArray()), this.literalIndex(ProxyClassFile.getConstantPoolName(aField.getType())));
            index = this.fieldCache.put(aField, this.currentIndex++);
            this.writeU1(9);
            this.writeU2(classIndex);
            this.writeU2(nameAndTypeIndex);
        }
        return index;
    }

    int literalIndex(Constructor aMethod) {
        int index = this.methodCache.get(aMethod);
        if (index < 0) {
            int classIndex = this.typeIndex(aMethod.getDeclaringClass().getName());
            int nameAndTypeIndex = this.literalIndexForNameAndType(this.literalIndex(Init), this.literalIndex(ProxyClassFile.getConstantPoolName(aMethod)));
            index = this.methodCache.put(aMethod, this.currentIndex++);
            this.writeU1(10);
            this.writeU2(classIndex);
            this.writeU2(nameAndTypeIndex);
        }
        return index;
    }

    int literalIndex(Method aMethod) {
        int index;
        if (aMethod.getDeclaringClass().isInterface()) {
            index = this.interfaceMethodCache.get(aMethod);
            if (index < 0) {
                int classIndex = this.typeIndex(aMethod.getDeclaringClass().getName());
                int nameAndTypeIndex = this.literalIndexForNameAndType(this.literalIndex(aMethod.getName().toCharArray()), this.literalIndex(ProxyClassFile.getConstantPoolName(aMethod)));
                index = this.interfaceMethodCache.put(aMethod, this.currentIndex++);
                this.writeU1(11);
                this.writeU2(classIndex);
                this.writeU2(nameAndTypeIndex);
            }
        } else {
            index = this.methodCache.get(aMethod);
            if (index < 0) {
                int classIndex = this.typeIndex(aMethod.getDeclaringClass().getName());
                int nameAndTypeIndex = this.literalIndexForNameAndType(this.literalIndex(aMethod.getName().toCharArray()), this.literalIndex(ProxyClassFile.getConstantPoolName(aMethod)));
                index = this.methodCache.put(aMethod, this.currentIndex++);
                this.writeU1(10);
                this.writeU2(classIndex);
                this.writeU2(nameAndTypeIndex);
            }
        }
        return index;
    }

    int literalIndex(String stringConstant) {
        char[] stringCharArray = stringConstant.toCharArray();
        int index = this.stringCache.get(stringCharArray);
        if (index < 0) {
            int stringIndex = this.literalIndex(stringCharArray);
            index = this.stringCache.put(stringCharArray, this.currentIndex++);
            this.writeU1(8);
            this.writeU2(stringIndex);
        }
        return index;
    }

    int literalIndexForLdc(char[] stringCharArray) {
        int index = this.stringCache.get(stringCharArray);
        if (index < 0) {
            int stringIndex = this.UTF8Cache.get(stringCharArray);
            if (stringIndex < 0) {
                int length;
                this.writeU1(1);
                int savedCurrentOffset = this.currentOffset;
                if (this.currentOffset + 2 >= this.poolContent.length) {
                    length = this.poolContent.length;
                    this.poolContent = new byte[length + 1000];
                    System.arraycopy((Object)this.poolContent, 0, (Object)this.poolContent, 0, length);
                }
                this.currentOffset += 2;
                length = 0;
                int i = 0;
                while (i < stringCharArray.length) {
                    char current = stringCharArray[i];
                    if (current >= '\u0001' && current <= '\u007f') {
                        this.writeU1(current);
                        ++length;
                    } else if (current > '\u07ff') {
                        length += 3;
                        this.writeU1(0xE0 | current >> 12 & 0xF);
                        this.writeU1(0x80 | current >> 6 & 0x3F);
                        this.writeU1(0x80 | current & 0x3F);
                    } else {
                        length += 2;
                        this.writeU1(0xC0 | current >> 6 & 0x1F);
                        this.writeU1(0x80 | current & 0x3F);
                    }
                    ++i;
                }
                if (length >= 65535) {
                    this.currentOffset = savedCurrentOffset - 1;
                    return -1;
                }
                stringIndex = this.UTF8Cache.put(stringCharArray, this.currentIndex++);
                if (length > 65535) {
                    return 0;
                }
                this.poolContent[savedCurrentOffset] = (byte)(length >> 8);
                this.poolContent[savedCurrentOffset + 1] = (byte)length;
            }
            index = this.stringCache.put(stringCharArray, this.currentIndex++);
            this.writeU1(8);
            this.writeU2(stringIndex);
        }
        return index;
    }

    private int literalIndexForNameAndType(int nameIndex, int typeIndex) {
        int[] key = new int[]{nameIndex, typeIndex};
        int index = this.nameAndTypeCache.get(key);
        if (index == -1) {
            index = this.nameAndTypeCache.put(key, this.currentIndex++);
            this.writeU1(12);
            this.writeU2(nameIndex);
            this.writeU2(typeIndex);
        }
        return index;
    }

    int typeIndex(String typeName) {
        char[] charArray;
        int index;
        if (typeName.indexOf(46) != -1) {
            typeName = typeName.replace('.', '/');
        }
        if ((index = this.classNameCache.get(charArray = typeName.toCharArray())) < 0) {
            int nameIndex = this.literalIndex(charArray);
            index = this.classNameCache.put(charArray, this.currentIndex++);
            this.writeU1(7);
            this.writeU2(nameIndex);
        }
        return index;
    }

    private final void writeU1(int value) {
        try {
            this.poolContent[this.currentOffset++] = (byte)value;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int length = this.poolContent.length;
            this.poolContent = new byte[length + 1000];
            System.arraycopy((Object)this.poolContent, 0, (Object)this.poolContent, 0, length);
            this.poolContent[this.currentOffset - 1] = (byte)value;
        }
    }

    private final void writeU2(int value) {
        int length;
        try {
            this.poolContent[this.currentOffset++] = (byte)(value >> 8);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            length = this.poolContent.length;
            this.poolContent = new byte[length + 1000];
            System.arraycopy((Object)this.poolContent, 0, (Object)this.poolContent, 0, length);
            this.poolContent[this.currentOffset - 1] = (byte)(value >> 8);
        }
        try {
            this.poolContent[this.currentOffset++] = (byte)value;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            length = this.poolContent.length;
            this.poolContent = new byte[length + 1000];
            System.arraycopy((Object)this.poolContent, 0, (Object)this.poolContent, 0, length);
            this.poolContent[this.currentOffset - 1] = (byte)value;
        }
    }
}

