/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.lang.reflect;

class ProxyNameAndTypeCache {
    int[][] keyTable;
    int[] valueTable;
    int elementSize;
    int threshold;

    ProxyNameAndTypeCache(int initialCapacity) {
        if (initialCapacity < 13) {
            initialCapacity = 13;
        }
        this.elementSize = 0;
        this.threshold = (int)((float)initialCapacity * 0.66f);
        this.keyTable = new int[initialCapacity][];
        this.valueTable = new int[initialCapacity];
    }

    int get(int[] key) {
        int index = this.hashCode(key);
        while (this.keyTable[index] != null) {
            if (this.keyTable[index][0] == key[0] && this.keyTable[index][1] == key[1]) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return -1;
    }

    int hashCode(int[] key) {
        return (key[0] + key[1]) % this.keyTable.length;
    }

    int put(int[] key, int value) {
        int index = this.hashCode(key);
        while (this.keyTable[index] != null) {
            if (this.keyTable[index][0] == key[0] && this.keyTable[index][1] == key[1]) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    private void rehash() {
        ProxyNameAndTypeCache newHashtable = new ProxyNameAndTypeCache(this.keyTable.length * 2);
        int i = this.keyTable.length;
        while (--i >= 0) {
            if (this.keyTable[i] == null) continue;
            newHashtable.put(this.keyTable[i], this.valueTable[i]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    int size() {
        return this.elementSize;
    }

    public String toString() {
        int max = this.size();
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        int i = 0;
        while (i < max) {
            if (this.keyTable[i] != null) {
                buf.append(this.keyTable[i]).append("->").append(this.valueTable[i]);
            }
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }
}

