/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.net.www.protocol.http;

import com.ibm.oti.net.www.protocol.http.ConnectionInfo;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.UnknownHostException;
import java.util.ArrayList;

public abstract class AuthCredential {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_SERVER = 1;
    public static final int TYPE_PROXY = 2;
    public static final String SCHEME_DIGEST = "Digest";
    public static final String SCHEME_BASIC = "Basic";
    public static final String DIRECTIVE_WWW = "Authorization";
    public static final String DIRECTIVE_PROXY = "Proxy-authorization";
    protected ConnectionInfo connectionInfo;
    protected int type;
    protected String challenge;
    protected String realm;
    protected String authorizationResponse;
    private PasswordAuthentication passwordAuthentication;
    private long lastUsed;
    protected int nonceCount = 1;

    public AuthCredential(int type, String challenge, ConnectionInfo connectionInfo) {
        this.type = type;
        this.challenge = challenge;
        this.connectionInfo = connectionInfo;
        this.parse(challenge);
    }

    protected abstract void parse(String var1);

    protected abstract String generateAuthorizationResponse();

    protected abstract String getScheme();

    protected abstract int getMinChallengeParts();

    protected abstract boolean isStale();

    public PasswordAuthentication getPasswordAuthentication() {
        if (this.passwordAuthentication == null) {
            try {
                this.passwordAuthentication = Authenticator.requestPasswordAuthentication(this.connectionInfo.getRequestingHostName(), InetAddress.getByName(this.connectionInfo.getRequestingHostName()), this.connectionInfo.getRequestingPort(), this.connectionInfo.getProtocol(), this.realm, this.getScheme());
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return this.passwordAuthentication;
    }

    public String getAuthorizationResponse() {
        if (this.authorizationResponse == null || this.isStale()) {
            if (this.passwordAuthentication == null) {
                this.passwordAuthentication = this.getPasswordAuthentication();
            }
            this.authorizationResponse = String.valueOf(this.getScheme()) + " " + this.generateAuthorizationResponse();
        }
        return this.authorizationResponse;
    }

    public String getKey() {
        return String.valueOf(this.type) + ":" + this.connectionInfo.getRequestingHostName() + ":" + this.realm;
    }

    public String getDirective() {
        switch (this.type) {
            case 1: {
                return DIRECTIVE_WWW;
            }
            case 2: {
                return DIRECTIVE_PROXY;
            }
        }
        throw new IllegalArgumentException("Invalid AuthCredential type");
    }

    protected String[] split(String challenge, char splitChar) {
        ArrayList params = new ArrayList();
        int start = 0;
        int end = challenge.indexOf(splitChar);
        do {
            if (end == -1) {
                end = challenge.length();
            }
            params.add(challenge.substring(start, end).trim());
            start = end + 1;
            end = challenge.indexOf(splitChar, start);
        } while (start <= challenge.length());
        return (String[])params.toArray(new String[0]);
    }

    protected String parseRealm(String[] csvValues) {
        if (csvValues.length < this.getMinChallengeParts()) {
            throw new IllegalArgumentException();
        }
        String[] schemeAndRealm = this.split(csvValues[0], ' ');
        if (!schemeAndRealm[0].equals(this.getScheme())) {
            throw new IllegalArgumentException();
        }
        int start = csvValues[0].indexOf(34) + 1;
        if (start == 0) {
            throw new IllegalArgumentException();
        }
        int end = csvValues[0].indexOf(34, start);
        if (end == -1) {
            throw new IllegalArgumentException();
        }
        return csvValues[0].substring(start, end);
    }

    protected long getLastUsedTime() {
        return this.lastUsed;
    }

    public void incrementNonceCount() {
        ++this.nonceCount;
    }

    public void updateLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    public String getUserName() {
        if (this.passwordAuthentication == null) {
            throw new IllegalArgumentException();
        }
        return this.passwordAuthentication.getUserName();
    }

    public char[] getPassword() {
        if (this.passwordAuthentication == null) {
            throw new IllegalArgumentException();
        }
        return this.passwordAuthentication.getPassword();
    }
}

