/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.PKCS1;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.ASN1Exception;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSAPublicKey
implements java.security.interfaces.RSAPublicKey {
    protected BigInteger modulus = null;
    protected BigInteger publicExponent = null;
    protected byte[] encoded = null;

    public RSAPublicKey(java.security.interfaces.RSAPublicKey key) {
        this(key.getModulus(), key.getPublicExponent());
    }

    public RSAPublicKey(RSAPublicKeySpec keySpec) {
        this(keySpec.getModulus(), keySpec.getPublicExponent());
    }

    public RSAPublicKey(BigInteger modulus, BigInteger publicExponent) {
        this.modulus = modulus;
        this.publicExponent = publicExponent;
    }

    public RSAPublicKey() {
    }

    public RSAPublicKey(X509EncodedKeySpec encoded) throws InvalidKeySpecException {
        this.encoded = encoded.getEncoded();
        try {
            this.decodeFromX509();
        }
        catch (ASN1Exception aSN1Exception) {
            throw new InvalidKeySpecException();
        }
    }

    public RSAPublicKey(byte[] encoded) throws IllegalArgumentException {
        this.encoded = encoded;
        try {
            this.decodeFromX509();
        }
        catch (ASN1Exception aSN1Exception) {
            throw new IllegalArgumentException();
        }
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            this.encoded = ASN1Encoder.encodeNode(this.toASN1Node());
        }
        return this.encoded;
    }

    public String getFormat() {
        return "X.509";
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public RSAPublicKeySpec toKeySpec() {
        return new RSAPublicKeySpec(this.modulus, this.publicExponent);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        RSAPublicKey.writeParamString(this.modulus, "modulus (n)", buffer);
        RSAPublicKey.writeParamString(this.publicExponent, "public exponent (e)", buffer);
        return buffer.toString();
    }

    public static void writeParamString(BigInteger param, String paramName, StringBuffer buffer) {
        buffer.append("\n\t");
        buffer.append(paramName);
        buffer.append(": ");
        String paramValueString = param.toString(16);
        int i = 0;
        while (i < paramValueString.length()) {
            if (i % 64 == 0) {
                buffer.append("\n\t\t");
            } else if (i % 8 == 0) {
                buffer.append(' ');
            }
            buffer.append(paramValueString.charAt(i));
            ++i;
        }
    }

    protected void decodeFromX509() throws ASN1Exception {
        ASN1Decoder decoder = new ASN1Decoder(new ByteArrayInputStream(this.encoded));
        try {
            ASN1Decoder.Node[] decodedStructure = (ASN1Decoder.Node[])decoder.readContents().data;
            ASN1Decoder.Node[] algIdentifier = (ASN1Decoder.Node[])decodedStructure[0].data;
            int[] oid = (int[])algIdentifier[0].data;
            int i = 0;
            while (i < PKCS1.OID_RSA.length) {
                if (i == oid.length || oid[i] != PKCS1.OID_RSA[i]) {
                    throw new ASN1Exception();
                }
                ++i;
            }
            ASN1Decoder.BitString y = (ASN1Decoder.BitString)decodedStructure[1].data;
            decoder = new ASN1Decoder(new ByteArrayInputStream(y.data));
            ASN1Decoder.Node[] params = (ASN1Decoder.Node[])decoder.readContents().data;
            if (params == null || params.length < 2) {
                throw new ASN1Exception();
            }
            this.modulus = (BigInteger)params[0].data;
            this.publicExponent = (BigInteger)params[1].data;
        }
        catch (ClassCastException classCastException) {
            throw new ASN1Exception();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ASN1Exception();
        }
    }

    public ASN1Decoder.Node toASN1Node() {
        ASN1Decoder.Node[] params;
        ASN1Decoder.Node[] algIdentifier;
        ASN1Decoder.Node[] encodedNodes;
        ASN1Decoder.Node sequence = new ASN1Decoder.Node();
        sequence.type = 16;
        sequence.data = encodedNodes = new ASN1Decoder.Node[2];
        encodedNodes[0] = new ASN1Decoder.Node();
        encodedNodes[0].type = 16;
        encodedNodes[0].data = algIdentifier = new ASN1Decoder.Node[2];
        algIdentifier[0] = new ASN1Decoder.Node();
        algIdentifier[0].type = 6;
        algIdentifier[0].data = PKCS1.OID_RSA;
        algIdentifier[1] = new ASN1Decoder.Node();
        algIdentifier[1].type = 5;
        ASN1Decoder.Node paramSequence = new ASN1Decoder.Node();
        paramSequence.type = 16;
        paramSequence.data = params = new ASN1Decoder.Node[2];
        params[0] = new ASN1Decoder.Node();
        params[0].type = 2;
        params[0].data = this.modulus;
        params[1] = new ASN1Decoder.Node();
        params[1].type = 2;
        params[1].data = this.publicExponent;
        encodedNodes[1] = new ASN1Decoder.Node();
        encodedNodes[1].type = 3;
        encodedNodes[1].data = new ASN1Decoder.BitString(0, ASN1Encoder.encodeNode(paramSequence));
        return sequence;
    }
}

