/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.ASN1OID;
import com.ibm.oti.text.Normalizer;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.ASN1Exception;
import com.ibm.oti.util.Msg;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;

public class X500Principal
implements Principal {
    public static final int OUTPUT_RFC1779 = 0;
    public static final int OUTPUT_RFC2253 = 1;
    public static final int OUTPUT_CANONICAL = 2;
    private static final int RFC_1779 = 0;
    private static final int RFC_2253 = 1;
    private static final int RFC_2459 = 2;
    private int[] supportedStandards;
    private boolean[] outputMarker;
    protected Vector attributeTypes;
    protected Vector attributeValues;
    private static final ASN1OID[] RFC_1779_OIDs = new ASN1OID[7];
    private static final ASN1OID[] RFC_2253_OIDs = new ASN1OID[2];
    private static final ASN1OID[] RFC_2459_OIDs = new ASN1OID[9];
    private static final String[] RFC_1779_OID_keys = new String[7];
    private static final String[] RFC_2253_OID_keys = new String[2];
    private static final String[] RFC_2459_OID_keys = new String[9];

    static {
        int i = 0;
        int[] oid = new int[]{2, 5, 4, 3};
        X500Principal.RFC_1779_OIDs[i] = new ASN1OID(oid);
        X500Principal.RFC_1779_OID_keys[i] = "CN";
        oid = new int[]{2, 5, 4, 11};
        X500Principal.RFC_1779_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_1779_OID_keys[i] = "OU";
        oid = new int[]{2, 5, 4, 10};
        X500Principal.RFC_1779_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_1779_OID_keys[i] = "O";
        oid = new int[]{2, 5, 4, 9};
        X500Principal.RFC_1779_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_1779_OID_keys[i] = "STREET";
        oid = new int[]{2, 5, 4, 7};
        X500Principal.RFC_1779_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_1779_OID_keys[i] = "L";
        oid = new int[]{2, 5, 4, 8};
        X500Principal.RFC_1779_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_1779_OID_keys[i] = "ST";
        oid = new int[]{2, 5, 4, 6};
        X500Principal.RFC_1779_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_1779_OID_keys[i] = "C";
        ++i;
        i = 0;
        int[] nArray = new int[7];
        nArray[1] = 9;
        nArray[2] = 2342;
        nArray[3] = 19200300;
        nArray[4] = 100;
        nArray[5] = 1;
        nArray[6] = 25;
        oid = nArray;
        X500Principal.RFC_2253_OIDs[i] = new ASN1OID(oid);
        X500Principal.RFC_2253_OID_keys[i] = "DC";
        ++i;
        int[] nArray2 = new int[7];
        nArray2[1] = 9;
        nArray2[2] = 2342;
        nArray2[3] = 19200300;
        nArray2[4] = 100;
        nArray2[5] = 1;
        nArray2[6] = 1;
        oid = nArray2;
        X500Principal.RFC_2253_OIDs[i] = new ASN1OID(oid);
        X500Principal.RFC_2253_OID_keys[i] = "UID";
        ++i;
        i = 0;
        oid = new int[]{2, 5, 4, 12};
        X500Principal.RFC_2459_OIDs[i] = new ASN1OID(oid);
        X500Principal.RFC_2459_OID_keys[i] = "TITLE";
        oid = new int[]{2, 5, 4, 42};
        X500Principal.RFC_2459_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_2459_OID_keys[i] = "GIVENNAME";
        oid = new int[]{2, 5, 4, 43};
        X500Principal.RFC_2459_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_2459_OID_keys[i] = "INITIALS";
        oid = new int[]{2, 5, 4, 41};
        X500Principal.RFC_2459_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_2459_OID_keys[i] = "SURNAME";
        oid = new int[]{2, 5, 4, 44};
        X500Principal.RFC_2459_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_2459_OID_keys[i] = "GENERATION";
        oid = new int[]{1, 2, 840, 113549, 1, 9, 1};
        X500Principal.RFC_2459_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_2459_OID_keys[i] = "EMAILADDRESS";
        oid = new int[]{2, 5, 4, 46};
        X500Principal.RFC_2459_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_2459_OID_keys[i] = "DNQ";
        oid = new int[]{2, 5, 4, 46};
        X500Principal.RFC_2459_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_2459_OID_keys[i] = "DNQUALIFIER";
        oid = new int[]{2, 5, 4, 5};
        X500Principal.RFC_2459_OIDs[++i] = new ASN1OID(oid);
        X500Principal.RFC_2459_OID_keys[i] = "SERIALNUMBER";
        ++i;
    }

    public X500Principal(String name) {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.supportedStandards = nArray;
        this.outputMarker = null;
        this.attributeTypes = new Vector();
        this.attributeValues = new Vector();
        this.initFrom(name);
        if (this.attributeTypes.size() == 0) {
            throw new IllegalArgumentException(Msg.getString("K039f"));
        }
    }

    public X500Principal(byte[] name) throws ASN1Exception {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.supportedStandards = nArray;
        this.outputMarker = null;
        this.attributeTypes = new Vector();
        this.attributeValues = new Vector();
        ByteArrayInputStream is = new ByteArrayInputStream(name);
        ASN1Decoder dec = new ASN1Decoder(is);
        ASN1Decoder.Node node = dec.readContents();
        this.initFrom(node);
    }

    public X500Principal(InputStream is) throws ASN1Exception {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.supportedStandards = nArray;
        this.outputMarker = null;
        this.attributeTypes = new Vector();
        this.attributeValues = new Vector();
        ASN1Decoder dec = new ASN1Decoder(is);
        ASN1Decoder.Node node = dec.readContents();
        this.initFrom(node);
    }

    public X500Principal(ASN1Decoder.Node issuerNode) {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.supportedStandards = nArray;
        this.outputMarker = null;
        this.attributeTypes = new Vector();
        this.attributeValues = new Vector();
        this.initFrom(issuerNode);
    }

    private void initFrom(ASN1Decoder.Node issuerNode) {
        ASN1Decoder.Node[] sequence = (ASN1Decoder.Node[])issuerNode.data;
        int i = 0;
        while (i < sequence.length) {
            ASN1Decoder.Node[] currentNode = (ASN1Decoder.Node[])sequence[i].data;
            ASN1Decoder.Node[] idAndvalue = (ASN1Decoder.Node[])currentNode[0].data;
            String value = null;
            value = idAndvalue[1].data instanceof ASN1Decoder.BMPString ? ((ASN1Decoder.BMPString)idAndvalue[1].data).bmpString : (String)idAndvalue[1].data;
            ASN1OID oid = new ASN1OID((int[])idAndvalue[0].data);
            this.attributeTypes.addElement(oid);
            this.attributeValues.addElement(value);
            ++i;
        }
    }

    private void initFrom(String name) {
        int start = 0;
        int end = 0;
        char separator = this.getSeparator();
        while (true) {
            if (start < name.length() && name.charAt(start) == ' ') {
                ++start;
            }
            if ((end = name.indexOf(61, start)) == -1) break;
            String key = name.substring(start, end);
            start = end + 1;
            boolean quoted = false;
            if (name.charAt(start) == '\"') {
                ++start;
                quoted = true;
            }
            if ((end = name.indexOf(quoted ? 34 : (int)separator, start)) == -1) {
                end = name.length();
            }
            String value = name.substring(start, end);
            start = end + (quoted ? 2 : 1);
            ASN1OID id = this.getOIDForKey(key, this.supportedStandards);
            if (id == null) {
                String keyString = key.toLowerCase();
                if (keyString.startsWith("oid")) {
                    id = new ASN1OID(keyString.substring(4));
                } else {
                    throw new IllegalArgumentException(Msg.getString("K03a0"));
                }
            }
            this.attributeTypes.addElement(id);
            this.attributeValues.addElement(value);
        }
    }

    private ASN1OID getOIDForKey(String key, int[] standards) {
        if (standards == null) {
            throw new IllegalArgumentException();
        }
        ASN1OID result = null;
        int i = 0;
        while (i < standards.length) {
            result = this.getOIDForKey(key, standards[i]);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private ASN1OID getOIDForKey(String key, int standard) {
        String[] keys = null;
        ASN1OID[] ids = null;
        switch (standard) {
            case 0: {
                keys = RFC_1779_OID_keys;
                ids = RFC_1779_OIDs;
                break;
            }
            case 1: {
                keys = RFC_2253_OID_keys;
                ids = RFC_2253_OIDs;
                break;
            }
            case 2: {
                keys = RFC_2459_OID_keys;
                ids = RFC_2459_OIDs;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int i = 0;
        while (i < keys.length) {
            if (keys[i].equals(key)) {
                return ids[i];
            }
            ++i;
        }
        return null;
    }

    private String getKeyForOID(ASN1OID oid, int[] standards) {
        if (standards == null) {
            throw new IllegalArgumentException();
        }
        String result = null;
        int i = 0;
        while (i < standards.length) {
            result = this.getKeyForOID(oid, standards[i]);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private String getKeyForOID(ASN1OID oid, int standard) {
        String[] keys = null;
        ASN1OID[] ids = null;
        switch (standard) {
            case 0: {
                keys = RFC_1779_OID_keys;
                ids = RFC_1779_OIDs;
                break;
            }
            case 1: {
                keys = RFC_2253_OID_keys;
                ids = RFC_2253_OIDs;
                break;
            }
            case 2: {
                keys = RFC_2459_OID_keys;
                ids = RFC_2459_OIDs;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals(oid)) {
                return keys[i];
            }
            ++i;
        }
        return null;
    }

    public String getName() {
        return this.getName(1);
    }

    public String getName(int format) {
        int[] standards;
        switch (format) {
            case 0: {
                standards = new int[1];
                break;
            }
            case 1: 
            case 2: {
                int[] nArray = new int[2];
                nArray[1] = 1;
                standards = nArray;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.outputMarker = new boolean[this.attributeTypes.size()];
        Arrays.fill(this.outputMarker, false);
        ASN1OID[] ids = RFC_1779_OIDs;
        Vector attributes = this.getAttributesForOutputFormat(standards, null, ids);
        if (format != 0) {
            ids = RFC_2253_OIDs;
            attributes = this.getAttributesForOutputFormat(standards, attributes, ids);
        }
        int i = 0;
        while (i < this.attributeTypes.size()) {
            if (!this.outputMarker[i]) {
                String attrID = "OID." + ((ASN1OID)this.attributeTypes.elementAt(i)).toString();
                String value = (String)this.attributeValues.elementAt(i);
                AttributeValuePair pair = new AttributeValuePair(attrID, value);
                attributes.add(pair);
                this.outputMarker[i] = true;
            }
            ++i;
        }
        if (format == 2) {
            return this.getAttributesAsCanonicalString(attributes);
        }
        return this.getAttributesAsNonCanonicalString(attributes);
    }

    private String getAttributesAsCanonicalString(Vector attributes) {
        TreeSet attributeSet = new TreeSet();
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            AttributeValuePair element = (AttributeValuePair)iter.next();
            attributeSet.add(element);
        }
        StringBuffer output = new StringBuffer();
        Iterator iter2 = attributeSet.iterator();
        while (iter2.hasNext()) {
            AttributeValuePair element = (AttributeValuePair)iter2.next();
            output.append(element.getOutputString(2));
            output.append(this.getSeparator());
        }
        output.deleteCharAt(output.length() - 1);
        String preResult = output.toString();
        preResult = preResult.toLowerCase(Locale.US);
        preResult = preResult.toUpperCase(Locale.US);
        String result = Normalizer.normalize(preResult, Normalizer.DECOMP_COMPAT, 0);
        return result;
    }

    private String getAttributesAsNonCanonicalString(Vector attributes) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            AttributeValuePair element = (AttributeValuePair)iter.next();
            buffer.append(element.getOutputString(1));
            buffer.append(this.getSeparator());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    private Vector getAttributesForOutputFormat(int[] standards, Vector startVector, ASN1OID[] ids) {
        Vector result = startVector != null ? startVector : new Vector();
        int x = 0;
        while (x < this.attributeTypes.size()) {
            ASN1OID id = (ASN1OID)this.attributeTypes.elementAt(x);
            int i = 0;
            while (i < ids.length) {
                if (id.equals(ids[i])) {
                    String attributeTypeString = this.getKeyForOID(id, standards);
                    String value = (String)this.attributeValues.elementAt(x);
                    AttributeValuePair p = new AttributeValuePair(attributeTypeString, value);
                    result.add(p);
                    this.outputMarker[x] = true;
                }
                ++i;
            }
            ++x;
        }
        return result;
    }

    public int hashCode() {
        return this.getName(2).hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public String getValueForKey(String key) {
        ASN1OID id = this.getOIDForKey(key, this.supportedStandards);
        int i = 0;
        while (i < this.attributeTypes.size()) {
            if (this.attributeTypes.elementAt(i).equals(id)) {
                return (String)this.attributeValues.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof X500Principal)) {
            return false;
        }
        return this.getName(2).equals(((X500Principal)o).getName(2));
    }

    public byte[] getEncoded() {
        ASN1Decoder.Node node = this.toASN1Node();
        byte[] encoded = ASN1Encoder.encodeNode(node);
        return encoded;
    }

    public ASN1Decoder.Node toASN1Node() {
        ASN1Decoder.Node[] rdnSequence = new ASN1Decoder.Node[this.attributeTypes.size()];
        int i = 0;
        while (i < this.attributeTypes.size()) {
            ASN1Decoder.Node[] attrTypeAndDistValueData = new ASN1Decoder.Node[2];
            ASN1Decoder.Node OIDNode = new ASN1Decoder.Node();
            OIDNode.type = 6;
            OIDNode.data = ((ASN1OID)this.attributeTypes.elementAt(i)).representation();
            attrTypeAndDistValueData[0] = OIDNode;
            ASN1Decoder.Node valueNode = new ASN1Decoder.Node();
            valueNode.type = 12;
            valueNode.data = this.attributeValues.elementAt(i);
            attrTypeAndDistValueData[1] = valueNode;
            ASN1Decoder.Node attrTypeAndDistValue = new ASN1Decoder.Node();
            attrTypeAndDistValue.type = 16;
            attrTypeAndDistValue.data = attrTypeAndDistValueData;
            ASN1Decoder.Node relDistName = new ASN1Decoder.Node();
            relDistName.type = 17;
            relDistName.data = new ASN1Decoder.Node[]{attrTypeAndDistValue};
            rdnSequence[i] = relDistName;
            ++i;
        }
        ASN1Decoder.Node name = new ASN1Decoder.Node();
        name.type = 16;
        name.data = rdnSequence;
        return name;
    }

    X500Principal() {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.supportedStandards = nArray;
        this.outputMarker = null;
        this.attributeTypes = new Vector();
        this.attributeValues = new Vector();
    }

    public char getSeparator() {
        return ',';
    }

    private static class AttributeValuePair
    implements Comparable {
        private String type;
        private String value;

        public AttributeValuePair(String type, String value) {
            this.type = type;
            this.value = value;
        }

        public int compareTo(Object another) {
            AttributeValuePair target = (AttributeValuePair)another;
            if (this.isOID(this.type)) {
                if (this.isOID(target.type)) {
                    return this.type.compareTo(target.type);
                }
                return 1;
            }
            if (this.isOID(target.type)) {
                return -1;
            }
            return this.type.compareTo(target.type);
        }

        private boolean isOID(String s) {
            return s.toLowerCase().startsWith("oid");
        }

        public String getOutputString(int format) {
            StringBuffer buffer = new StringBuffer(this.type.length() + this.value.length() + 3);
            buffer.append(this.type);
            buffer.append('=');
            String outValue = this.value;
            outValue = format == 2 ? this.stripInternalWhitespace(this.value.trim()) : this.value;
            if (this.value.charAt(0) == ' ' || this.value.charAt(0) == '#' || this.value.charAt(this.value.length() - 1) == ' ' || this.value.indexOf(44) != -1 || this.value.indexOf(61) != -1 || this.value.indexOf(43) != -1 || this.value.indexOf(60) != -1 || this.value.indexOf(62) != -1 || this.value.indexOf(35) != -1 || this.value.indexOf(59) != -1) {
                buffer.append('\"');
                buffer.append(outValue);
                buffer.append('\"');
            } else {
                buffer.append(outValue);
            }
            return buffer.toString();
        }

        private String stripInternalWhitespace(String s) {
            char[] stringChars = s.toCharArray();
            char[] dest = new char[s.length()];
            int destPosition = 0;
            int i = 0;
            while (i < s.length()) {
                if (Character.isWhitespace(stringChars[i])) {
                    dest[destPosition++] = 32;
                    ++i;
                    while (Character.isWhitespace(stringChars[i])) {
                        ++i;
                    }
                    dest[destPosition++] = stringChars[i];
                } else {
                    dest[destPosition++] = stringChars[i];
                }
                ++i;
            }
            return new String(dest);
        }

        public String toString() {
            return this.getOutputString(1);
        }
    }
}

