/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.ASN1OID;

final class X509Extension {
    private ASN1OID id;
    private byte[] value;
    private boolean isCritical;

    public X509Extension(ASN1OID id, byte[] value, boolean isCritical) {
        this.id = id;
        this.value = value;
        this.isCritical = isCritical;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof X509Extension)) {
            return false;
        }
        X509Extension other = (X509Extension)obj;
        return this.id.equals(other.id);
    }

    public String toString() {
        return String.valueOf(this.id.toString()) + "->" + this.value;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    public byte[] value() {
        return this.value;
    }

    public String name() {
        int[] representation = this.id.representation();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < representation.length - 1) {
            result.append(representation[i]);
            result.append('.');
            ++i;
        }
        result.append(representation[representation.length - 1]);
        return result.toString();
    }
}

