/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.AppClassLoader;
import com.ibm.oti.vm.VM;
import java.io.File;
import java.util.Hashtable;

public final class ExtensionClassLoader
extends AppClassLoader {
    private static ExtensionClassLoader singleton;
    private static Hashtable protectionDomainCache;

    static {
        protectionDomainCache = new Hashtable(10);
    }

    private ExtensionClassLoader() {
        super(false);
        String[] extDirPath;
        String[][] list;
        int total = 0;
        String extDirs = System.getProperty("java.ext.dirs");
        if (extDirs == null) {
            list = new String[1][];
            extDirPath = new String[1];
            String bootPath = System.getProperty("java.home", "");
            File extDir = new File(bootPath, "lib/ext");
            list[0] = extDir.list();
            if (list[0] != null) {
                total = list[0].length;
                extDirPath[0] = String.valueOf(extDir.getPath()) + File.separatorChar;
            }
        } else {
            int next;
            int index = 0;
            int count = 0;
            int end = extDirs.length();
            while (index < end) {
                next = extDirs.indexOf(File.pathSeparatorChar, index);
                if (next == -1) {
                    next = end;
                }
                if (next - index > 0) {
                    ++count;
                }
                index = next + 1;
            }
            list = new String[count][];
            extDirPath = new String[count];
            count = 0;
            index = 0;
            while (index < end) {
                next = extDirs.indexOf(File.pathSeparatorChar, index);
                if (next == -1) {
                    next = end;
                }
                if (next - index > 0) {
                    String path = extDirs.substring(index, next);
                    File extDir = new File(path);
                    list[count] = extDir.list();
                    if (list[count] != null) {
                        total += list[count].length;
                        extDirPath[count++] = String.valueOf(extDir.getPath()) + File.separatorChar;
                    }
                }
                index = next + 1;
            }
        }
        if (list != null) {
            this.types = new int[total];
            this.parsedPath = new String[total];
            this.cache = this.parsedPath;
            StringBuffer extPath = new StringBuffer();
            int j = 0;
            while (j < list.length) {
                if (list[j] != null) {
                    int i = 0;
                    while (i < list[j].length) {
                        extPath.append(extDirPath[j]);
                        extPath.append(list[j][i]);
                        this.parsedPath[i] = String.valueOf(extDirPath[j]) + list[j][i];
                        if (i != list.length - 1) {
                            extPath.append(';');
                        }
                        ++i;
                    }
                }
                ++j;
            }
            VM.setClassPathImpl((ClassLoader)this, extPath.toString());
        }
    }

    public static synchronized ClassLoader singleton() {
        if (singleton != null) {
            throw new InstantiationError(Msg.getString("K0085"));
        }
        singleton = new ExtensionClassLoader();
        return singleton;
    }

    Hashtable getProtectionDomainCache() {
        return protectionDomainCache;
    }

    boolean addExitPermission() {
        return false;
    }
}

