/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.Writer;

public class CharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;

    public CharArrayWriter() {
        this.buf = new char[32];
        this.lock = this.buf;
    }

    public CharArrayWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException(Msg.getString("K005e"));
        }
        this.buf = new char[initialSize];
        this.lock = this.buf;
    }

    public void close() {
    }

    private void expand(int i) {
        if (this.count + i <= this.buf.length) {
            return;
        }
        char[] newbuf = new char[this.buf.length + 2 * i];
        System.arraycopy((Object)this.buf, 0, (Object)newbuf, 0, this.count);
        this.buf = newbuf;
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.count = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] toCharArray() {
        Object object = this.lock;
        synchronized (object) {
            char[] result = new char[this.count];
            System.arraycopy((Object)this.buf, 0, (Object)result, 0, this.count);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return new String(this.buf, 0, this.count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int offset, int count) {
        if (offset >= 0 && offset <= buf.length && count >= 0 && count <= buf.length - offset) {
            Object object = this.lock;
            synchronized (object) {
                this.expand(count);
                System.arraycopy((Object)buf, offset, (Object)this.buf, this.count, count);
                this.count += count;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneChar) {
        Object object = this.lock;
        synchronized (object) {
            this.expand(1);
            this.buf[this.count++] = (char)oneChar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int offset, int count) {
        if (offset >= 0 && offset <= str.length() && count >= 0 && count <= str.length() - offset) {
            Object object = this.lock;
            synchronized (object) {
                this.expand(count);
                str.getChars(offset, offset + count, this.buf, this.count);
                this.count += count;
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer out) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            out.write(this.buf, 0, this.count);
        }
    }
}

