/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.ObjectStreamField;

class EmulatedFields {
    private ObjectSlot[] slotsToSerialize;
    private ObjectStreamField[] declaredFields;

    public EmulatedFields(ObjectStreamField[] fields, ObjectStreamField[] declared) {
        this.buildSlots(fields);
        this.declaredFields = declared;
    }

    private void buildSlots(ObjectStreamField[] fields) {
        this.slotsToSerialize = new ObjectSlot[fields.length];
        int i = 0;
        while (i < fields.length) {
            ObjectSlot s;
            this.slotsToSerialize[i] = s = new ObjectSlot();
            s.field = fields[i];
            ++i;
        }
    }

    public boolean defaulted(String name) throws IOException, IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, null);
        if (slot != null) {
            return slot.defaulted;
        }
        throw new IllegalArgumentException();
    }

    private ObjectSlot findSlot(String fieldName, Class fieldType) {
        boolean isPrimitive = fieldType != null && fieldType.isPrimitive();
        int i = 0;
        while (i < this.slotsToSerialize.length) {
            ObjectSlot slot = this.slotsToSerialize[i];
            if (slot.field.getName().equals(fieldName)) {
                if (isPrimitive) {
                    if (slot.field.getType() == fieldType) {
                        return slot;
                    }
                } else {
                    if (fieldType == null) {
                        return slot;
                    }
                    if (slot.field.getType().isAssignableFrom(fieldType)) {
                        return slot;
                    }
                }
            }
            ++i;
        }
        if (this.declaredFields != null) {
            i = 0;
            while (i < this.declaredFields.length) {
                ObjectStreamField field = this.declaredFields[i];
                if (field.getName().equals(fieldName) && (isPrimitive ? field.getType() == fieldType : fieldType == null || field.getType().isAssignableFrom(fieldType))) {
                    ObjectSlot slot = new ObjectSlot();
                    slot.field = field;
                    slot.defaulted = true;
                    return slot;
                }
                ++i;
            }
        }
        return null;
    }

    public byte get(String name, byte defaultValue) throws IOException, IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Byte.TYPE);
        if (slot != null) {
            return slot.defaulted ? defaultValue : (Byte)slot.fieldValue;
        }
        throw new IllegalArgumentException();
    }

    public char get(String name, char defaultValue) throws IOException, IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Character.TYPE);
        if (slot != null) {
            return slot.defaulted ? defaultValue : ((Character)slot.fieldValue).charValue();
        }
        throw new IllegalArgumentException();
    }

    public double get(String name, double defaultValue) throws IOException, IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Double.TYPE);
        if (slot != null) {
            return slot.defaulted ? defaultValue : (Double)slot.fieldValue;
        }
        throw new IllegalArgumentException();
    }

    public float get(String name, float defaultValue) throws IOException, IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Float.TYPE);
        if (slot != null) {
            return slot.defaulted ? defaultValue : ((Float)slot.fieldValue).floatValue();
        }
        throw new IllegalArgumentException();
    }

    public int get(String name, int defaultValue) throws IOException, IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Integer.TYPE);
        if (slot != null) {
            return slot.defaulted ? defaultValue : (Integer)slot.fieldValue;
        }
        throw new IllegalArgumentException();
    }

    public long get(String name, long defaultValue) throws IOException, IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Long.TYPE);
        if (slot != null) {
            return slot.defaulted ? defaultValue : (Long)slot.fieldValue;
        }
        throw new IllegalArgumentException();
    }

    public Object get(String name, Object defaultValue) throws IOException, IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, null);
        if (slot != null && !slot.field.getType().isPrimitive()) {
            return slot.defaulted ? defaultValue : slot.fieldValue;
        }
        throw new IllegalArgumentException();
    }

    public short get(String name, short defaultValue) throws IOException, IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Short.TYPE);
        if (slot != null) {
            return slot.defaulted ? defaultValue : (Short)slot.fieldValue;
        }
        throw new IllegalArgumentException();
    }

    public boolean get(String name, boolean defaultValue) throws IOException, IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Boolean.TYPE);
        if (slot != null) {
            return slot.defaulted ? defaultValue : (Boolean)slot.fieldValue;
        }
        throw new IllegalArgumentException();
    }

    public void put(String name, byte value) throws IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Byte.TYPE);
        if (slot == null) {
            throw new IllegalArgumentException();
        }
        slot.fieldValue = new Byte(value);
        slot.defaulted = false;
    }

    public void put(String name, char value) throws IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Character.TYPE);
        if (slot == null) {
            throw new IllegalArgumentException();
        }
        slot.fieldValue = new Character(value);
        slot.defaulted = false;
    }

    public void put(String name, double value) throws IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Double.TYPE);
        if (slot == null) {
            throw new IllegalArgumentException();
        }
        slot.fieldValue = new Double(value);
        slot.defaulted = false;
    }

    public void put(String name, float value) throws IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Float.TYPE);
        if (slot == null) {
            throw new IllegalArgumentException();
        }
        slot.fieldValue = new Float(value);
        slot.defaulted = false;
    }

    public void put(String name, int value) throws IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Integer.TYPE);
        if (slot == null) {
            throw new IllegalArgumentException();
        }
        slot.fieldValue = new Integer(value);
        slot.defaulted = false;
    }

    public void put(String name, long value) throws IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Long.TYPE);
        if (slot == null) {
            throw new IllegalArgumentException();
        }
        slot.fieldValue = new Long(value);
        slot.defaulted = false;
    }

    public void put(String name, Object value) throws IllegalArgumentException {
        ObjectSlot slot;
        Class valueClass = null;
        if (value != null) {
            valueClass = value.getClass();
        }
        if ((slot = this.findSlot(name, valueClass)) == null) {
            throw new IllegalArgumentException();
        }
        slot.fieldValue = value;
        slot.defaulted = false;
    }

    public void put(String name, short value) throws IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Short.TYPE);
        if (slot == null) {
            throw new IllegalArgumentException();
        }
        slot.fieldValue = new Short(value);
        slot.defaulted = false;
    }

    public void put(String name, boolean value) throws IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, Boolean.TYPE);
        if (slot == null) {
            throw new IllegalArgumentException();
        }
        slot.fieldValue = new Boolean(value);
        slot.defaulted = false;
    }

    public ObjectSlot[] slots() {
        return this.slotsToSerialize;
    }

    static class ObjectSlot {
        ObjectStreamField field;
        Object fieldValue;
        boolean defaulted = true;

        ObjectSlot() {
        }

        public ObjectStreamField getField() {
            return this.field;
        }

        public Object getFieldValue() {
            return this.fieldValue;
        }
    }
}

