/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.PipedReader;
import java.io.Writer;

public class PipedWriter
extends Writer {
    private PipedReader dest;
    private boolean closed = false;

    public PipedWriter() {
    }

    public PipedWriter(PipedReader dest) throws IOException {
        super(dest);
        this.connect(dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.dest != null) {
                this.dest.done();
                this.dest = null;
            }
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(PipedReader dest) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.dest == null) {
                if (this.closed) {
                    throw new IOException(Msg.getString("K0078"));
                }
            } else {
                throw new IOException(Msg.getString("K0079"));
            }
            dest.establishConnection(this);
            this.dest = dest;
        }
    }

    public void flush() throws IOException {
        if (this.dest != null) {
            this.dest.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buffer, int offset, int count) throws IOException {
        if (offset >= 0 && offset <= buffer.length && count >= 0 && count <= buffer.length - offset) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.closed) {
                    if (this.dest == null) {
                        throw new IOException(Msg.getString("K007b"));
                    }
                } else {
                    throw new IOException(Msg.getString("K0078"));
                }
                this.dest.receive(buffer, offset, count);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                if (this.dest == null) {
                    throw new IOException(Msg.getString("K007b"));
                }
            } else {
                throw new IOException(Msg.getString("K0078"));
            }
            this.dest.receive((char)c);
        }
    }
}

