/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    char[] buf;
    int pos;

    public PushbackReader(Reader in) {
        super(in);
        this.buf = new char[1];
        this.pos = 1;
    }

    public PushbackReader(Reader in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException(Msg.getString("K0058"));
        }
        this.buf = new char[size];
        this.pos = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.buf = null;
            this.in.close();
        }
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException(Msg.getString("K007f"));
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf != null) {
                if (this.pos < this.buf.length) {
                    return this.buf[this.pos++];
                }
                return this.in.read();
            }
            throw new IOException();
        }
    }

    public int read(char[] buffer, int offset, int count) throws IOException {
        if (offset >= 0 && offset <= buffer.length && count >= 0 && count <= buffer.length - offset) {
            Object object = this.lock;
            synchronized (object) {
                if (this.buf != null) {
                    int copiedChars = 0;
                    int copyLength = 0;
                    int newOffset = offset;
                    if (this.pos < this.buf.length) {
                        copyLength = this.buf.length - this.pos >= count ? count : this.buf.length - this.pos;
                        System.arraycopy((Object)this.buf, this.pos, (Object)buffer, newOffset, copyLength);
                        newOffset += copyLength;
                        copiedChars += copyLength;
                        this.pos += copyLength;
                    }
                    if (copyLength == count) {
                        return count;
                    }
                    int inCopied = this.in.read(buffer, newOffset, count - copiedChars);
                    if (inCopied > 0) {
                        return inCopied + copiedChars;
                    }
                    if (copiedChars == 0) {
                        return inCopied;
                    }
                    return copiedChars;
                }
                throw new IOException();
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf != null) {
                return this.buf.length - this.pos > 0 || this.in.ready();
            }
            throw new IOException(Msg.getString("K0080"));
        }
    }

    public void reset() throws IOException {
        throw new IOException(Msg.getString("K007f"));
    }

    public void unread(char[] buffer) throws IOException {
        this.unread(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(char[] buffer, int offset, int count) throws IOException {
        if (count > this.pos) {
            throw new IOException(Msg.getString("K007e"));
        }
        if (offset >= 0 && offset <= buffer.length && count >= 0 && count <= buffer.length - offset) {
            Object object = this.lock;
            synchronized (object) {
                int i = offset + count - 1;
                while (i >= offset) {
                    this.unread(buffer[i]);
                    --i;
                }
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf != null) {
                if (this.pos == 0) {
                    throw new IOException(Msg.getString("K007e"));
                }
            } else {
                throw new IOException();
            }
            this.buf[--this.pos] = (char)oneChar;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long skip(long count) throws IOException {
        if (count < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            long inSkipped;
            block8: {
                if (this.buf == null) throw new IOException();
                if (count != 0L) break block8;
                return 0L;
            }
            int availableFromBuffer = this.buf.length - this.pos;
            if (availableFromBuffer > 0) {
                long requiredFromIn = count - (long)availableFromBuffer;
                if (requiredFromIn <= 0L) {
                    this.pos = (int)((long)this.pos + count);
                    return count;
                }
                this.pos += availableFromBuffer;
                inSkipped = this.in.skip(requiredFromIn);
            } else {
                inSkipped = this.in.skip(count);
            }
            return inSkipped + (long)availableFromBuffer;
        }
    }
}

