/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Byte
extends Number
implements Comparable {
    private static final long serialVersionUID = -7183698231559129828L;
    final byte value;
    public static final byte MAX_VALUE = 127;
    public static final byte MIN_VALUE = -128;
    public static final Class TYPE = new byte[0].getClass().getComponentType();

    public Byte(byte value) {
        this.value = value;
    }

    public Byte(String string) throws NumberFormatException {
        this(Byte.parseByte(string));
    }

    public byte byteValue() {
        return this.value;
    }

    public int compareTo(Byte object) {
        return this.value > object.value ? 1 : (this.value < object.value ? -1 : 0);
    }

    public int compareTo(Object object) {
        return this.compareTo((Byte)object);
    }

    public static Byte decode(String string) throws NumberFormatException {
        int intValue = Integer.decode(string);
        byte result = (byte)intValue;
        if (result == intValue) {
            return new Byte(result);
        }
        throw new NumberFormatException();
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Byte && this.value == ((Byte)object).value;
    }

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public static byte parseByte(String string) throws NumberFormatException {
        int intValue = Integer.parseInt(string);
        byte result = (byte)intValue;
        if (result == intValue) {
            return result;
        }
        throw new NumberFormatException();
    }

    public static byte parseByte(String string, int radix) throws NumberFormatException {
        int intValue = Integer.parseInt(string, radix);
        byte result = (byte)intValue;
        if (result == intValue) {
            return result;
        }
        throw new NumberFormatException();
    }

    public short shortValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static String toString(byte value) {
        return Integer.toString(value);
    }

    public static Byte valueOf(String string) throws NumberFormatException {
        return new Byte(Byte.parseByte(string));
    }

    public static Byte valueOf(String string, int radix) throws NumberFormatException {
        return new Byte(Byte.parseByte(string, radix));
    }
}

