/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AllPermission;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.Vector;

public final class Class
implements Serializable {
    private static final long serialVersionUID = 3206093459760846163L;
    private static ProtectionDomain AllPermissionsPD;
    private static final int j9Version = 252183089;
    private static final long j9Config = 7381247430415679488L;
    private static final Class[] EmptyParameters;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    static {
        EmptyParameters = new Class[0];
    }

    private Class() {
    }

    private void checkMemberAccess(int type) {
        ClassLoader callerClassLoader;
        SecurityManager security = System.getSecurityManager();
        if (security != null && (callerClassLoader = ClassLoader.getStackClassLoader(2)) != ClassLoader.systemClassLoader) {
            security.checkMemberAccess(this, type);
            String packageName = this.getPackageName();
            ClassLoader loader = this.getClassLoaderImpl();
            if (packageName != "" && callerClassLoader != loader && !callerClassLoader.isAncestorOf(loader)) {
                security.checkPackageAccess(packageName);
            }
        }
    }

    public static Class forName(String className) throws ClassNotFoundException {
        ClassLoader defaultClassLoader = ClassLoader.callerClassLoader();
        return Class.forNameImpl(className, true, defaultClassLoader);
    }

    public static Class forName(String className, boolean initializeBoolean, ClassLoader classLoader) throws ClassNotFoundException {
        SecurityManager security;
        ClassLoader callerClassLoader;
        if (classLoader == null && (callerClassLoader = ClassLoader.callerClassLoader()) != null && (security = System.getSecurityManager()) != null) {
            security.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return Class.forNameImpl(className, initializeBoolean, classLoader);
    }

    private static native Class forNameImpl(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    public Class[] getClasses() {
        Object[] classes;
        this.checkMemberAccess(0);
        Vector publicClasses = new Vector();
        Class current = this;
        while (current != null) {
            classes = current.getDeclaredClassesImpl();
            int i = 0;
            while (i < classes.length) {
                if (Modifier.isPublic(((Class)classes[i]).getModifiers())) {
                    publicClasses.addElement(classes[i]);
                }
                ++i;
            }
            current = current.getSuperclass();
        }
        classes = new Class[publicClasses.size()];
        publicClasses.copyInto(classes);
        return classes;
    }

    public ClassLoader getClassLoader() {
        ClassLoader loader = this.getClassLoaderImpl();
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (loader == ClassLoader.systemClassLoader) {
                return null;
            }
            ClassLoader callersClassLoader = ClassLoader.callerClassLoader();
            if (callersClassLoader != null && callersClassLoader != loader && !callersClassLoader.isAncestorOf(loader)) {
                security.checkPermission(RuntimePermission.permissionToGetClassLoader);
            }
        }
        if (loader == ClassLoader.systemClassLoader) {
            return null;
        }
        return loader;
    }

    native ClassLoader getClassLoaderImpl();

    public native Class getComponentType();

    private void throwNoSuchMethodException(String name, Class[] types) throws NoSuchMethodException {
        StringBuffer error = new StringBuffer();
        error.append(this.getName()).append('.').append(name).append('(');
        if (types.length > 0) {
            error.append(types[0] == null ? null : types[0].getName());
            int i = 1;
            while (i < types.length) {
                error.append(", ").append(types[i] == null ? null : types[i].getName());
                ++i;
            }
        }
        error.append(')');
        throw new NoSuchMethodException(error.toString());
    }

    public Constructor getConstructor(Class[] parameterTypes) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0);
        if (parameterTypes == null || parameterTypes.length == 0) {
            Constructor rc = this.getConstructorImpl(EmptyParameters, "()V");
            if (rc == null) {
                this.throwNoSuchMethodException("<init>", EmptyParameters);
            }
            return rc;
        }
        int total = 3;
        String[] sigs = new String[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            if (parameterTypes[i] != null) {
                sigs[i] = parameterTypes[i].getSignature();
                total += sigs[i].length();
            } else {
                this.throwNoSuchMethodException("<init>", parameterTypes);
            }
            ++i;
        }
        StringBuffer signature = new StringBuffer(total);
        signature.append('(');
        int i2 = 0;
        while (i2 < parameterTypes.length) {
            signature.append(sigs[i2]);
            ++i2;
        }
        signature.append(")V");
        Constructor rc = this.getConstructorImpl((Class[])parameterTypes.clone(), signature.toString());
        if (rc == null) {
            this.throwNoSuchMethodException("<init>", parameterTypes);
        }
        return rc;
    }

    private native Constructor getConstructorImpl(Class[] var1, String var2);

    public Constructor[] getConstructors() throws SecurityException {
        this.checkMemberAccess(0);
        return this.getConstructorsImpl();
    }

    private native Constructor[] getConstructorsImpl();

    public Class[] getDeclaredClasses() throws SecurityException {
        this.checkMemberAccess(1);
        return this.getDeclaredClassesImpl();
    }

    private native Class[] getDeclaredClassesImpl();

    public Constructor getDeclaredConstructor(Class[] parameterTypes) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1);
        if (parameterTypes == null || parameterTypes.length == 0) {
            Constructor rc = this.getDeclaredConstructorImpl(EmptyParameters, "()V");
            if (rc == null) {
                this.throwNoSuchMethodException("<init>", EmptyParameters);
            }
            return rc;
        }
        int total = 3;
        String[] sigs = new String[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            if (parameterTypes[i] != null) {
                sigs[i] = parameterTypes[i].getSignature();
                total += sigs[i].length();
            } else {
                this.throwNoSuchMethodException("<init>", parameterTypes);
            }
            ++i;
        }
        StringBuffer signature = new StringBuffer(total);
        signature.append('(');
        int i2 = 0;
        while (i2 < parameterTypes.length) {
            signature.append(sigs[i2]);
            ++i2;
        }
        signature.append(")V");
        Constructor rc = this.getDeclaredConstructorImpl((Class[])parameterTypes.clone(), signature.toString());
        if (rc == null) {
            this.throwNoSuchMethodException("<init>", parameterTypes);
        }
        return rc;
    }

    private native Constructor getDeclaredConstructorImpl(Class[] var1, String var2);

    public Constructor[] getDeclaredConstructors() throws SecurityException {
        this.checkMemberAccess(1);
        return this.getDeclaredConstructorsImpl();
    }

    private native Constructor[] getDeclaredConstructorsImpl();

    public Field getDeclaredField(String name) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(1);
        return this.getDeclaredFieldImpl(name);
    }

    private native Field getDeclaredFieldImpl(String var1) throws NoSuchFieldException;

    public Field[] getDeclaredFields() throws SecurityException {
        this.checkMemberAccess(1);
        return this.getDeclaredFieldsImpl();
    }

    private native Field[] getDeclaredFieldsImpl();

    public Method getDeclaredMethod(String name, Class[] parameterTypes) throws NoSuchMethodException, SecurityException {
        Class[] params;
        String strSig;
        this.checkMemberAccess(1);
        if (name == null || parameterTypes == null || parameterTypes.length == 0) {
            strSig = "()";
            params = EmptyParameters;
        } else {
            strSig = this.getParameterTypesSignature(name, parameterTypes);
            params = (Class[])parameterTypes.clone();
            int i = 0;
            while (i < params.length) {
                Class parameterType = params[i];
                ClassLoader loader = this.getClassLoader();
                if (!parameterType.isPrimitive()) {
                    try {
                        if (Class.forName(parameterType.getName(), false, loader) != parameterType) {
                            this.throwNoSuchMethodException(name, parameterTypes);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.throwNoSuchMethodException(name, parameterTypes);
                    }
                }
                ++i;
            }
        }
        Method result = this.getDeclaredMethodImpl(name, params, strSig, null);
        if (result == null) {
            this.throwNoSuchMethodException(name, params);
        }
        Method bestCandidate = result;
        int maxDepth = result.getReturnType().getClassDepth();
        while ((result = this.getDeclaredMethodImpl(name, params, strSig, result)) != null) {
            int resultDepth = result.getReturnType().getClassDepth();
            if (resultDepth <= maxDepth) continue;
            bestCandidate = result;
            maxDepth = resultDepth;
        }
        return bestCandidate;
    }

    private native Method getDeclaredMethodImpl(String var1, Class[] var2, String var3, Method var4);

    public Method[] getDeclaredMethods() throws SecurityException {
        this.checkMemberAccess(1);
        return this.getDeclaredMethodsImpl();
    }

    private native Method[] getDeclaredMethodsImpl();

    public Class getDeclaringClass() {
        return this.getDeclaringClassImpl();
    }

    private native Class getDeclaringClassImpl();

    public Field getField(String name) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(0);
        return this.getFieldImpl(name);
    }

    private native Field getFieldImpl(String var1) throws NoSuchFieldException;

    public Field[] getFields() throws SecurityException {
        this.checkMemberAccess(0);
        return this.getFieldsImpl();
    }

    private native Field[] getFieldsImpl();

    public native Class[] getInterfaces();

    public Method getMethod(String name, Class[] parameterTypes) throws NoSuchMethodException, SecurityException {
        Class[] params;
        String strSig;
        this.checkMemberAccess(0);
        if (name == null || parameterTypes == null || parameterTypes.length == 0) {
            strSig = "()";
            params = EmptyParameters;
        } else {
            strSig = this.getParameterTypesSignature(name, parameterTypes);
            params = (Class[])parameterTypes.clone();
        }
        Method result = this.getMethodImpl(name, params, strSig);
        if (result == null) {
            this.throwNoSuchMethodException(name, params);
        }
        int i = 0;
        while (i < params.length) {
            Class parameterType = params[i];
            ClassLoader loader = result.getDeclaringClass().getClassLoader();
            if (!parameterType.isPrimitive()) {
                try {
                    if (Class.forName(parameterType.getName(), false, loader) != parameterType) {
                        this.throwNoSuchMethodException(name, parameterTypes);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.throwNoSuchMethodException(name, parameterTypes);
                }
            }
            ++i;
        }
        Method bestCandidate = result;
        int maxDepth = result.getReturnType().getClassDepth();
        Class declaringClass = result.getDeclaringClass();
        while ((result = declaringClass.getDeclaredMethodImpl(name, params, strSig, result)) != null) {
            int resultDepth;
            if ((result.getModifiers() & 1) == 0 || (resultDepth = result.getReturnType().getClassDepth()) <= maxDepth) continue;
            bestCandidate = result;
            maxDepth = resultDepth;
        }
        return bestCandidate;
    }

    private native Method getMethodImpl(String var1, Class[] var2, String var3);

    public Method[] getMethods() throws SecurityException {
        this.checkMemberAccess(0);
        if (this.isPrimitive()) {
            return new Method[0];
        }
        if (this.isInterface()) {
            return this.getInterfaceMethodsImpl();
        }
        int vCount = this.getVirtualMethodCountImpl();
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.reflect.Method");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Method[] methods = (Method[])clazz.allocateAndFillArray(vCount + this.getStaticMethodCountImpl());
        this.getVirtualMethodsImpl(methods, 0);
        this.getStaticMethodsImpl(methods, vCount);
        return methods;
    }

    private boolean methodsEqual(Method m1, Method m2) {
        Class[] m2Parms;
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        if (!m1.getReturnType().equals(m2.getReturnType())) {
            return false;
        }
        Class[] m1Parms = m1.getParameterTypes();
        if (m1Parms.length != (m2Parms = m2.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < m1Parms.length) {
            if (m1Parms[i] != m2Parms[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int getInterfaceMethodCountImpl() {
        int count = this.getDeclaredMethods().length;
        Class[] parents = this.getInterfaces();
        int i = 0;
        while (i < parents.length) {
            count += parents[i].getInterfaceMethodCountImpl();
            ++i;
        }
        return count;
    }

    private Method[] getInterfaceMethodsImpl() {
        Method[] scratch = new Method[this.getInterfaceMethodCountImpl()];
        Method[] local = this.getDeclaredMethods();
        int index = 0;
        int i = 0;
        while (i < local.length) {
            if (Modifier.isAbstract(local[i].getModifiers())) {
                scratch[index++] = local[i];
            } else {
                local[i] = null;
            }
            ++i;
        }
        Class[] parents = this.getInterfaces();
        i = 0;
        while (i < parents.length) {
            Method[] parentMethods = parents[i].getInterfaceMethodsImpl();
            int j = 0;
            while (j < local.length) {
                if (local[j] != null) {
                    int k = 0;
                    while (k < parentMethods.length) {
                        if (parentMethods[k] != null && this.methodsEqual(local[j], parentMethods[k])) {
                            parentMethods[k] = null;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            j = 0;
            while (j < parentMethods.length) {
                if (parentMethods[j] != null) {
                    scratch[index++] = parentMethods[j];
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < scratch.length) {
            if (scratch[i] != null) {
                int j = i + 1;
                while (j < scratch.length) {
                    if (scratch[j] != null && scratch[i].equals(scratch[j])) {
                        scratch[j] = null;
                    }
                    ++j;
                }
            }
            ++i;
        }
        int count = 0;
        i = 0;
        while (i < scratch.length) {
            if (scratch[i] != null) {
                ++count;
            }
            ++i;
        }
        Method[] unique = new Method[count];
        index = 0;
        i = 0;
        while (i < scratch.length) {
            if (scratch[i] != null) {
                unique[index++] = scratch[i];
            }
            ++i;
        }
        return unique;
    }

    private native int getVirtualMethodCountImpl();

    private native void getVirtualMethodsImpl(Method[] var1, int var2);

    private native int getStaticMethodCountImpl();

    private native void getStaticMethodsImpl(Method[] var1, int var2);

    private native Object[] allocateAndFillArray(int var1);

    public native int getModifiers();

    private native String getClassNameStringImpl();

    private native void setClassNameStringImpl(String var1);

    public String getName() {
        String name = this.getClassNameStringImpl();
        if (name != null) {
            return name;
        }
        name = this.getNameImpl().intern();
        this.setClassNameStringImpl(name);
        return name;
    }

    native String getNameImpl();

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain result;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToGetProtectionDomain);
        }
        if ((result = this.getPDImpl()) != null) {
            return result;
        }
        if (AllPermissionsPD == null) {
            Permissions collection = new Permissions();
            collection.add(new AllPermission());
            AllPermissionsPD = new ProtectionDomain(null, collection);
        }
        return AllPermissionsPD;
    }

    native ProtectionDomain getPDImpl();

    String getPackageName() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(0, index);
        }
        return "";
    }

    public URL getResource(String resName) {
        ClassLoader loader = this.getClassLoaderImpl();
        if (loader == ClassLoader.systemClassLoader) {
            return ClassLoader.getSystemResource(this.toResourceName(resName));
        }
        return loader.getResource(this.toResourceName(resName));
    }

    public InputStream getResourceAsStream(String resName) {
        ClassLoader loader = this.getClassLoaderImpl();
        if (loader == ClassLoader.systemClassLoader) {
            return ClassLoader.getSystemResourceAsStream(this.toResourceName(resName));
        }
        return loader.getResourceAsStream(this.toResourceName(resName));
    }

    private String getSignature() {
        if (this.isArray()) {
            return this.getName();
        }
        if (this.isPrimitive()) {
            if (this == Void.TYPE) {
                return "V";
            }
            if (this == Boolean.TYPE) {
                return "Z";
            }
            if (this == Byte.TYPE) {
                return "B";
            }
            if (this == Character.TYPE) {
                return "C";
            }
            if (this == Short.TYPE) {
                return "S";
            }
            if (this == Integer.TYPE) {
                return "I";
            }
            if (this == Long.TYPE) {
                return "J";
            }
            if (this == Float.TYPE) {
                return "F";
            }
            if (this == Double.TYPE) {
                return "D";
            }
        }
        String name = this.getName();
        return new StringBuffer(name.length() + 2).append('L').append(name).append(';').toString();
    }

    public Object[] getSigners() {
        return this.getClassLoaderImpl().getSigners(this);
    }

    public native Class getSuperclass();

    public native boolean isArray();

    public native boolean isAssignableFrom(Class var1);

    public native boolean isInstance(Object var1);

    public boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public native boolean isPrimitive();

    public Object newInstance() throws IllegalAccessException, InstantiationException {
        this.checkMemberAccess(0);
        return this.newInstanceImpl();
    }

    private Object newInstancePrototype(Class callerClass) throws InstantiationException {
        throw new InstantiationException(this);
    }

    private native Object newInstanceImpl() throws IllegalAccessException, InstantiationException;

    private String toResourceName(String resName) {
        if (resName.length() > 0 && resName.charAt(0) == '/') {
            return resName.substring(1);
        }
        String qualifiedClassName = this.getName();
        int classIndex = qualifiedClassName.lastIndexOf(46);
        if (classIndex == -1) {
            return resName;
        }
        return String.valueOf(qualifiedClassName.substring(0, classIndex + 1).replace('.', '/')) + resName;
    }

    public String toString() {
        if (this.isPrimitive()) {
            return this.getName();
        }
        return String.valueOf(this.isInterface() ? "interface " : "class ") + this.getName();
    }

    public Package getPackage() {
        return this.getClassLoaderImpl().getPackage(this.getPackageName());
    }

    public boolean desiredAssertionStatus() {
        ClassLoader cldr = this.getClassLoaderImpl();
        if (cldr != null) {
            return cldr.getClassAssertionStatus(this.getName());
        }
        return false;
    }

    static final native Class[] getStackClasses(int var0, boolean var1);

    private native int getClassDepth();

    private String getParameterTypesSignature(String name, Class[] parameterTypes) throws NoSuchMethodException {
        int total = 2;
        String[] sigs = new String[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            Class parameterType = parameterTypes[i];
            if (parameterType != null) {
                sigs[i] = parameterType.getSignature();
                total += sigs[i].length();
            } else {
                this.throwNoSuchMethodException(name, parameterTypes);
            }
            ++i;
        }
        StringBuffer signature = new StringBuffer(total);
        signature.append('(');
        int i2 = 0;
        while (i2 < parameterTypes.length) {
            signature.append(sigs[i2]);
            ++i2;
        }
        signature.append(')');
        return signature.toString();
    }
}

