/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.net.URL;

public class Package {
    private String name;
    private String specificationTitle;
    private String specificationVendor;
    private String specificationVersion;
    private String implementationTitle;
    private String implementationVendor;
    private String implementationVersion;
    private URL sealBase;

    Package(String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
        this.name = name;
        this.specificationTitle = specificationTitle;
        this.specificationVersion = specificationVersion;
        this.specificationVendor = specificationVendor;
        this.implementationTitle = implementationTitle;
        this.implementationVersion = implementationVersion;
        this.implementationVendor = implementationVendor;
        this.sealBase = sealBase;
    }

    public String getImplementationTitle() {
        return this.implementationTitle;
    }

    public String getImplementationVendor() {
        return this.implementationVendor;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getName() {
        return this.name;
    }

    public static Package getPackage(String packageName) {
        return ClassLoader.getStackClassLoader(1).getPackage(packageName);
    }

    public static Package[] getPackages() {
        return ClassLoader.getStackClassLoader(1).getPackages();
    }

    public String getSpecificationTitle() {
        return this.specificationTitle;
    }

    public String getSpecificationVendor() {
        return this.specificationVendor;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isCompatibleWith(String version) throws NumberFormatException {
        int part2;
        int end2;
        if (this.specificationVersion == null || version == null || this.specificationVersion.length() == 0 || version.length() == 0) {
            throw new NumberFormatException();
        }
        if (this.specificationVersion.equals(version)) {
            return true;
        }
        int length1 = this.specificationVersion.length();
        int length2 = version.length();
        int start2 = 0;
        int start1 = 0;
        do {
            int part1;
            int end1;
            if ((end1 = this.specificationVersion.indexOf(46, start1)) == -1) {
                end1 = length1;
            }
            if ((end2 = version.indexOf(46, start2)) == -1) {
                end2 = length2;
            }
            if ((part1 = Integer.parseInt(this.specificationVersion.substring(start1, end1))) < (part2 = Integer.parseInt(version.substring(start2, end2)))) {
                return false;
            }
            if (part1 > part2) {
                return true;
            }
            start1 = end1 + 1;
            start2 = end2 + 1;
            if (start2 < length2) continue;
            return true;
        } while (start1 < length1);
        while (start2 < length2) {
            end2 = version.indexOf(46, start2);
            if (end2 == -1) {
                end2 = length2;
            }
            if ((part2 = Integer.parseInt(version.substring(start2, end2))) > 0) {
                return false;
            }
            start2 = end2 + 1;
        }
        return true;
    }

    public boolean isSealed() {
        return this.sealBase != null;
    }

    public boolean isSealed(URL url) {
        return this.sealBase != null && this.sealBase.sameFile(url);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("package ");
        buffer.append(this.name);
        if (this.specificationTitle != null && this.specificationTitle.length() > 0) {
            buffer.append(", ");
            buffer.append(this.specificationTitle);
        }
        if (this.specificationVersion != null && this.specificationVersion.length() > 0) {
            buffer.append(", version ");
            buffer.append(this.specificationVersion);
        }
        return buffer.toString();
    }
}

