/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;

public final class DatagramPacket {
    byte[] data;
    int length;
    InetAddress address;
    int port;
    int offset = 0;

    public DatagramPacket(byte[] data, int length) {
        this(data, 0, length);
    }

    public DatagramPacket(byte[] data, int offset, int length) {
        this.setData(data, offset, length);
    }

    public DatagramPacket(byte[] data, int offset, int length, InetAddress host, int aPort) {
        this(data, offset, length);
        this.setPort(aPort);
        this.address = host;
    }

    public DatagramPacket(byte[] data, int length, InetAddress host, int port) {
        this(data, 0, length, host, port);
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized byte[] getData() {
        return this.data;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized void setAddress(InetAddress addr) {
        this.address = addr;
    }

    public synchronized void setData(byte[] buf, int anOffset, int aLength) {
        if (anOffset < 0 || anOffset > buf.length || aLength < 0 || aLength > buf.length - anOffset) {
            throw new IllegalArgumentException(Msg.getString("K002f"));
        }
        this.data = buf;
        this.offset = anOffset;
        this.length = aLength;
    }

    public synchronized void setData(byte[] buf) {
        this.length = buf.length;
        this.data = buf;
        this.offset = 0;
    }

    public synchronized void setLength(int len) {
        if (len < 0 || this.offset + len > this.data.length) {
            throw new IllegalArgumentException(Msg.getString("K002f"));
        }
        this.length = len;
    }

    public synchronized void setPort(int aPort) {
        if (aPort < 0 || aPort > 65535) {
            throw new IllegalArgumentException(Msg.getString("K0325", aPort));
        }
        this.port = aPort;
    }

    public DatagramPacket(byte[] data, int length, SocketAddress sockAddr) throws SocketException {
        this(data, 0, length);
        this.setSocketAddress(sockAddr);
    }

    public DatagramPacket(byte[] data, int offset, int length, SocketAddress sockAddr) throws SocketException {
        this(data, offset, length);
        this.setSocketAddress(sockAddr);
    }

    public SocketAddress getSocketAddress() {
        return new InetSocketAddress(this.getAddress(), this.getPort());
    }

    public void setSocketAddress(SocketAddress sockAddr) {
        if (!(sockAddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException(Msg.getString("K0316", sockAddr == null ? null : sockAddr.getClass()));
        }
        InetSocketAddress inetAddr = (InetSocketAddress)sockAddr;
        this.port = inetAddr.getPort();
        this.address = inetAddr.getAddress();
    }
}

