/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class DigestOutputStream
extends FilterOutputStream {
    protected MessageDigest digest;
    private boolean on;

    public DigestOutputStream(OutputStream out, MessageDigest digest) {
        super(out);
        this.setMessageDigest(digest);
        this.on(true);
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void on(boolean on) {
        this.on = on;
    }

    public void setMessageDigest(MessageDigest digest) {
        this.digest = digest;
    }

    public String toString() {
        StringBuffer answer = new StringBuffer("[Digest Output Stream]");
        if (this.digest != null) {
            answer.append(" ");
            answer.append(this.digest.toString());
        }
        if (this.on) {
            answer.append(", <on>");
        } else {
            answer.append(", <off>");
        }
        return answer.toString();
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        super.write(buffer, offset, length);
    }

    public void write(int oneByte) throws IOException {
        super.write(oneByte);
        if (this.on) {
            this.digest.engineUpdate((byte)oneByte);
        }
    }
}

