/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class KeyFactory {
    private static final String KEY_PREFIX = "KeyFactory.";
    private String algorithmName;
    private Provider provider;
    private KeyFactorySpi keyFactorySpi;

    protected KeyFactory(KeyFactorySpi keyFactorySpi, Provider provider, String algName) {
        this.setProvider(provider);
        this.setAlgorithm(algName);
        this.keyFactorySpi = keyFactorySpi;
    }

    private static KeyFactory createKeyFactory(Provider provider, Class algorithmClass, String algName) throws NoSuchAlgorithmException {
        try {
            KeyFactorySpi providedKeyFactory = (KeyFactorySpi)algorithmClass.newInstance();
            return new KeyFactory(providedKeyFactory, provider, algName);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        throw new NoSuchAlgorithmException(algName);
    }

    public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFactorySpi.engineGeneratePrivate(keySpec);
    }

    public final String getAlgorithm() {
        return this.algorithmName;
    }

    public static KeyFactory getInstance(String algorithmName, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (providerName == null) {
            throw new IllegalArgumentException();
        }
        if (algorithmName == null) {
            throw new IllegalArgumentException();
        }
        if (providerName.equals("")) {
            throw new IllegalArgumentException();
        }
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(providerName);
        }
        return KeyFactory.toKeyFactoryImplementation(algorithmName, provider);
    }

    public static KeyFactory getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (algorithm == null || provider == null) {
            throw new IllegalArgumentException();
        }
        return KeyFactory.toKeyFactoryImplementation(algorithm, provider);
    }

    public final KeySpec getKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        return this.keyFactorySpi.engineGetKeySpec(key, keySpec);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    void setAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    void setProvider(Provider provider) {
        this.provider = provider;
    }

    private static KeyFactory toKeyFactoryImplementation(String algorithmName) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Provider provider = providers[i];
            try {
                return KeyFactory.toKeyFactoryImplementation(algorithmName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(algorithmName);
    }

    private static KeyFactory toKeyFactoryImplementation(String algorithmName, Provider provider) throws NoSuchAlgorithmException {
        String keyFactoryClassName;
        try {
            keyFactoryClassName = provider.lookupProperty(KEY_PREFIX, algorithmName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        if (keyFactoryClassName == null) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        try {
            Class keyFactClass = Class.forName(keyFactoryClassName, true, provider.getClass().getClassLoader());
            return KeyFactory.createKeyFactory(provider, keyFactClass, algorithmName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
    }

    public final Key translateKey(Key key) throws InvalidKeyException {
        return this.keyFactorySpi.engineTranslateKey(key);
    }

    public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFactorySpi.engineGeneratePublic(keySpec);
    }

    public static KeyFactory getInstance(String algorithmName) throws NoSuchAlgorithmException {
        if (algorithmName == null) {
            throw new IllegalArgumentException();
        }
        return KeyFactory.toKeyFactoryImplementation(algorithmName);
    }
}

