/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;

public abstract class Signature
extends SignatureSpi {
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state;
    private static final String[] STATE_DESCRIPTION = new String[]{"UNINITIALIZED", "SIGN", "VERIFY"};
    private static final String KEY_PREFIX = "Signature.";
    private String algorithmName;
    private Provider provider;

    protected Signature(String algName) {
        this.setAlgorithm(algName);
        this.state = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final String getAlgorithm() {
        return this.algorithmName;
    }

    public static Signature getInstance(String algorithmName) throws NoSuchAlgorithmException {
        if (algorithmName == null) {
            throw new IllegalArgumentException();
        }
        return Signature.toSignatureImplementation(algorithmName);
    }

    public static Signature getInstance(String algorithmName, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (providerName == null) {
            throw new IllegalArgumentException();
        }
        if (algorithmName == null) {
            throw new IllegalArgumentException();
        }
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(providerName);
        }
        return Signature.toSignatureImplementation(algorithmName, provider);
    }

    public static Signature getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (algorithm == null || provider == null) {
            throw new IllegalArgumentException();
        }
        return Signature.toSignatureImplementation(algorithm, provider);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.state = 2;
        this.engineInitSign(privateKey);
    }

    public final void initSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.state = 2;
        this.engineInitSign(privateKey, random);
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.state = 3;
        this.engineInitVerify(publicKey);
    }

    public final void initVerify(Certificate certificate) throws InvalidKeyException {
        boolean[] keyUsage;
        X509Certificate x509;
        Set critical;
        this.state = 3;
        if (certificate instanceof X509Certificate && (critical = (x509 = (X509Certificate)certificate).getCriticalExtensionOIDs()) != null && !critical.isEmpty() && critical.contains("2.5.29.15") && !(keyUsage = x509.getKeyUsage())[0]) {
            throw new InvalidKeyException(Msg.getString("K00e4"));
        }
        this.engineInitVerify(certificate.getPublicKey());
    }

    void setAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public final void setParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.engineSetParameter(params);
    }

    public final AlgorithmParameters getParameters() {
        return this.engineGetParameters();
    }

    void setProvider(Provider provider) {
        this.provider = provider;
    }

    public final byte[] sign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException();
        }
        return this.engineSign();
    }

    public final int sign(byte[] buffer, int offset, int length) throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException();
        }
        return this.engineSign(buffer, offset, length);
    }

    private static Signature toSignatureImplementation(String algorithmName) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Provider provider = providers[i];
            try {
                return Signature.toSignatureImplementation(algorithmName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(algorithmName);
    }

    private static Signature toSignatureImplementation(String algorithmName, Provider provider) throws NoSuchAlgorithmException {
        String signatureClassName;
        try {
            signatureClassName = provider.lookupProperty(KEY_PREFIX, algorithmName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        if (signatureClassName == null) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        try {
            Class signatureClass = Class.forName(signatureClassName, true, provider.getClass().getClassLoader());
            SignatureSpi providedSignature = (SignatureSpi)signatureClass.newInstance();
            Signature signature = providedSignature instanceof Signature ? (Signature)providedSignature : new Wrapper(providedSignature, algorithmName);
            signature.setProvider(provider);
            return signature;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (ClassCastException classCastException) {}
        throw new NoSuchAlgorithmException(algorithmName);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(128);
        result.append(this.getAlgorithm());
        result.append(" Signature (");
        result.append(STATE_DESCRIPTION[this.state]);
        result.append(')');
        return result.toString();
    }

    public final void update(byte[] data) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException();
        }
        this.engineUpdate(data, 0, data.length);
    }

    public final void update(byte[] buffer, int offset, int length) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException();
        }
        this.engineUpdate(buffer, offset, length);
    }

    public final void update(byte b) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException();
        }
        this.engineUpdate(b);
    }

    public final boolean verify(byte[] signature) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException();
        }
        return this.engineVerify(signature);
    }

    public final boolean verify(byte[] signature, int offset, int length) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException();
        }
        return this.engineVerify(signature, offset, length);
    }

    private static class Wrapper
    extends Signature {
        SignatureSpi signatureProvider;

        Wrapper(SignatureSpi signatureProvider, String algorithmName) {
            super(algorithmName);
            this.signatureProvider = signatureProvider;
        }

        public Object clone() throws CloneNotSupportedException {
            Wrapper clone = new Wrapper((SignatureSpi)this.signatureProvider.clone(), this.getAlgorithm());
            clone.setProvider(this.getProvider());
            return clone;
        }

        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            this.signatureProvider.engineInitSign(privateKey);
        }

        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            this.signatureProvider.engineInitVerify(publicKey);
        }

        protected byte[] engineSign() throws SignatureException {
            return this.signatureProvider.engineSign();
        }

        protected void engineUpdate(byte[] buffer, int offset, int length) throws SignatureException {
            this.signatureProvider.engineUpdate(buffer, offset, length);
        }

        protected void engineUpdate(byte b) throws SignatureException {
            this.signatureProvider.engineUpdate(b);
        }

        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            return this.signatureProvider.engineVerify(sigBytes);
        }

        public String toString() {
            if (this.signatureProvider != null) {
                return this.signatureProvider.toString();
            }
            return super.toString();
        }
    }
}

