/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public abstract class Signer
extends Identity {
    private static final long serialVersionUID = -1763464102261361480L;
    PrivateKey privateKey;

    protected Signer() {
    }

    public Signer(String name) {
        super(name);
    }

    public Signer(String name, IdentityScope scope) throws KeyManagementException {
        super(name, scope);
    }

    public PrivateKey getPrivateKey() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("getSignerPrivateKey");
        }
        return this.privateKey;
    }

    public final void setKeyPair(KeyPair keyPair) throws InvalidParameterException, KeyException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("setSignerKeyPair");
        }
        PublicKey pubKey = keyPair.getPublic();
        PrivateKey priKey = keyPair.getPrivate();
        if (priKey == null || pubKey == null) {
            throw new InvalidParameterException();
        }
        this.setPublicKey(pubKey);
        this.privateKey = priKey;
    }

    public String toString() {
        return super.toString();
    }
}

