/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Vector;

public class ChoiceFormat
extends NumberFormat {
    private static final long serialVersionUID = 1795184449645032964L;
    private double[] choiceLimits;
    private String[] choiceFormats;

    public ChoiceFormat(double[] limits, String[] formats) {
        this.setChoices(limits, formats);
    }

    public ChoiceFormat(String template) {
        this.applyPattern(template);
    }

    public void applyPattern(String template) {
        boolean first = true;
        double[] limits = new double[5];
        Vector formats = new Vector();
        int length = template.length();
        int limitCount = 0;
        int index = 0;
        StringBuffer buffer = new StringBuffer();
        NumberFormat format = NumberFormat.getInstance();
        ParsePosition position = new ParsePosition(0);
        try {
            while (true) {
                double next;
                if ((index = this.skipWhitespace(template, index)) >= length) {
                    if (limitCount == limits.length) {
                        this.choiceLimits = limits;
                    } else {
                        this.choiceLimits = new double[limitCount];
                        System.arraycopy((Object)limits, 0, (Object)this.choiceLimits, 0, limitCount);
                    }
                    this.choiceFormats = new String[formats.size()];
                    int i = 0;
                    while (i < formats.size()) {
                        this.choiceFormats[i] = (String)formats.elementAt(i);
                        ++i;
                    }
                    return;
                }
                position.setIndex(index);
                Number value = format.parse(template, position);
                index = this.skipWhitespace(template, position.getIndex());
                if (position.getErrorIndex() != -1 || index >= length) {
                    throw new IllegalArgumentException();
                }
                char ch = template.charAt(index++);
                if (limitCount == limits.length) {
                    double[] newLimits = new double[limitCount * 2];
                    System.arraycopy((Object)limits, 0, (Object)newLimits, 0, limitCount);
                    limits = newLimits;
                }
                switch (ch) {
                    case '#': 
                    case '\u2264': {
                        next = value.doubleValue();
                        break;
                    }
                    case '<': {
                        if (first) {
                            throw new IllegalArgumentException();
                        }
                        next = ChoiceFormat.nextDouble(value.doubleValue());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                first = false;
                if (limitCount > 0 && next <= limits[limitCount - 1]) {
                    throw new IllegalArgumentException();
                }
                buffer.setLength(0);
                position.setIndex(index);
                ChoiceFormat.upTo(template, position, buffer, '|');
                index = position.getIndex();
                limits[limitCount++] = next;
                formats.addElement(buffer.toString());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.choiceFormats = null;
            this.choiceLimits = null;
            return;
        }
    }

    public Object clone() {
        ChoiceFormat clone = (ChoiceFormat)super.clone();
        clone.choiceLimits = (double[])this.choiceLimits.clone();
        clone.choiceFormats = (String[])this.choiceFormats.clone();
        return clone;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChoiceFormat)) {
            return false;
        }
        ChoiceFormat choice = (ChoiceFormat)object;
        return Arrays.equals(this.choiceLimits, choice.choiceLimits) && Arrays.equals(this.choiceFormats, choice.choiceFormats);
    }

    public StringBuffer format(double value, StringBuffer buffer, FieldPosition field) {
        if (Double.isNaN(value) || this.choiceLimits.length > 1 && value < this.choiceLimits[1]) {
            return buffer.append(this.choiceFormats[0]);
        }
        int i = 2;
        while (i < this.choiceLimits.length) {
            if (value >= this.choiceLimits[i - 1] && value < this.choiceLimits[i]) {
                return buffer.append(this.choiceFormats[i - 1]);
            }
            ++i;
        }
        return buffer.append(this.choiceFormats[this.choiceFormats.length - 1]);
    }

    public StringBuffer format(long value, StringBuffer buffer, FieldPosition field) {
        return this.format((double)value, buffer, field);
    }

    public Object[] getFormats() {
        return this.choiceFormats;
    }

    public double[] getLimits() {
        return this.choiceLimits;
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i < this.choiceLimits.length) {
            long v = Double.doubleToLongBits(this.choiceLimits[i]);
            hashCode += (int)(v ^ v >>> 32) + this.choiceFormats[i].hashCode();
            ++i;
        }
        return hashCode;
    }

    public static final double nextDouble(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return value;
        }
        long bits = value == 0.0 ? 0L : Double.doubleToLongBits(value);
        return Double.longBitsToDouble(value < 0.0 ? bits - 1L : bits + 1L);
    }

    public static double nextDouble(double value, boolean increment) {
        return increment ? ChoiceFormat.nextDouble(value) : ChoiceFormat.previousDouble(value);
    }

    public Number parse(String string, ParsePosition position) {
        int offset = position.getIndex();
        int i = 0;
        while (i < this.choiceFormats.length) {
            if (string.startsWith(this.choiceFormats[i], offset)) {
                position.setIndex(offset + this.choiceFormats[i].length());
                return new Double(this.choiceLimits[i]);
            }
            ++i;
        }
        position.setErrorIndex(offset);
        return new Double(Double.NaN);
    }

    public static final double previousDouble(double value) {
        if (value == Double.NEGATIVE_INFINITY) {
            return value;
        }
        long bits = value == 0.0 ? Long.MIN_VALUE : Double.doubleToLongBits(value);
        return Double.longBitsToDouble(value <= 0.0 ? bits + 1L : bits - 1L);
    }

    public void setChoices(double[] limits, String[] formats) {
        if (limits.length != formats.length) {
            throw new IllegalArgumentException();
        }
        this.choiceLimits = limits;
        this.choiceFormats = formats;
    }

    private int skipWhitespace(String string, int index) {
        int length = string.length();
        while (index < length && Character.isWhitespace(string.charAt(index))) {
            ++index;
        }
        return index;
    }

    public String toPattern() {
        if (this.choiceLimits == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.choiceLimits.length) {
            boolean quote;
            String previous = String.valueOf(ChoiceFormat.previousDouble(this.choiceLimits[i]));
            String limit = String.valueOf(this.choiceLimits[i]);
            if (previous.length() < limit.length()) {
                buffer.append(previous);
                buffer.append('<');
            } else {
                buffer.append(limit);
                buffer.append('#');
            }
            if (quote = this.choiceFormats[i].indexOf(124) != -1) {
                buffer.append('\'');
            }
            buffer.append(this.choiceFormats[i]);
            if (quote) {
                buffer.append('\'');
            }
            buffer.append('|');
            ++i;
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }
}

