/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.text.Normalizer;
import java.text.CharacterIterator;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RBCollationTables;

public class RuleBasedCollator
extends Collator {
    static final int CHARINDEX = 0x70000000;
    static final int EXPANDCHARINDEX = 0x7E000000;
    static final int CONTRACTCHARINDEX = 0x7F000000;
    static final int UNMAPPED = -1;
    private static final int COLLATIONKEYOFFSET = 1;
    private RBCollationTables tables = null;
    private StringBuffer primResult = null;
    private StringBuffer secResult = null;
    private StringBuffer terResult = null;
    private CollationElementIterator sourceCursor = null;
    private CollationElementIterator targetCursor = null;
    static /* synthetic */ Class class$0;

    public RuleBasedCollator(String rules) throws ParseException {
        this(rules, 1);
    }

    RuleBasedCollator(String rules, int decomp) throws ParseException {
        this.setStrength(2);
        this.setDecomposition(decomp);
        this.tables = new RBCollationTables(rules, decomp);
    }

    private RuleBasedCollator(RuleBasedCollator that) {
        this.setStrength(that.getStrength());
        this.setDecomposition(that.getDecomposition());
        this.tables = that.tables;
    }

    public String getRules() {
        return this.tables.getRules();
    }

    public CollationElementIterator getCollationElementIterator(String source) {
        return new CollationElementIterator(source, this);
    }

    public CollationElementIterator getCollationElementIterator(CharacterIterator source) {
        return new CollationElementIterator(source, this);
    }

    public synchronized int compare(String source, String target) {
        boolean initialCheckSecTer;
        int result = 0;
        if (this.sourceCursor == null) {
            this.sourceCursor = this.getCollationElementIterator(source);
        } else {
            this.sourceCursor.setText(source);
        }
        if (this.targetCursor == null) {
            this.targetCursor = this.getCollationElementIterator(target);
        } else {
            this.targetCursor.setText(target);
        }
        int sOrder = 0;
        int tOrder = 0;
        boolean checkSecTer = initialCheckSecTer = this.getStrength() >= 1;
        boolean checkTertiary = this.getStrength() >= 2;
        boolean gets = true;
        boolean gett = true;
        while (true) {
            short terTOrder;
            short terSOrder;
            short secTOrder;
            if (gets) {
                sOrder = this.sourceCursor.next();
            } else {
                gets = true;
            }
            if (gett) {
                tOrder = this.targetCursor.next();
            } else {
                gett = true;
            }
            if (sOrder == -1 || tOrder == -1) break;
            int pSOrder = CollationElementIterator.primaryOrder(sOrder);
            int pTOrder = CollationElementIterator.primaryOrder(tOrder);
            if (sOrder == tOrder) {
                if (!this.tables.isFrenchSec() || pSOrder == 0 || checkSecTer) continue;
                checkSecTer = initialCheckSecTer;
                checkTertiary = false;
                continue;
            }
            if (pSOrder != pTOrder) {
                if (sOrder == 0) {
                    gett = false;
                    continue;
                }
                if (tOrder == 0) {
                    gets = false;
                    continue;
                }
                if (pSOrder == 0) {
                    if (checkSecTer) {
                        result = 1;
                        checkSecTer = false;
                    }
                    gett = false;
                    continue;
                }
                if (pTOrder == 0) {
                    if (checkSecTer) {
                        result = -1;
                        checkSecTer = false;
                    }
                    gets = false;
                    continue;
                }
                if (pSOrder < pTOrder) {
                    return -1;
                }
                return 1;
            }
            if (!checkSecTer) continue;
            short secSOrder = CollationElementIterator.secondaryOrder(sOrder);
            if (secSOrder != (secTOrder = CollationElementIterator.secondaryOrder(tOrder))) {
                result = secSOrder < secTOrder ? -1 : 1;
                checkSecTer = false;
                continue;
            }
            if (!checkTertiary || (terSOrder = CollationElementIterator.tertiaryOrder(sOrder)) == (terTOrder = CollationElementIterator.tertiaryOrder(tOrder))) continue;
            result = terSOrder < terTOrder ? -1 : 1;
            checkTertiary = false;
        }
        if (sOrder != -1) {
            do {
                if (CollationElementIterator.primaryOrder(sOrder) != 0) {
                    return 1;
                }
                if (CollationElementIterator.secondaryOrder(sOrder) == 0 || !checkSecTer) continue;
                result = 1;
                checkSecTer = false;
            } while ((sOrder = this.sourceCursor.next()) != -1);
        } else if (tOrder != -1) {
            do {
                if (CollationElementIterator.primaryOrder(tOrder) != 0) {
                    return -1;
                }
                if (CollationElementIterator.secondaryOrder(tOrder) == 0 || !checkSecTer) continue;
                result = -1;
                checkSecTer = false;
            } while ((tOrder = this.targetCursor.next()) != -1);
        }
        if (result == 0 && this.getStrength() == 3) {
            Normalizer.Mode mode = Normalizer.getMode(this.getDecomposition());
            String sourceDecomposition = Normalizer.normalize(source, mode, 0);
            String targetDecomposition = Normalizer.normalize(target, mode, 0);
            result = sourceDecomposition.compareTo(targetDecomposition);
        }
        return result;
    }

    public synchronized CollationKey getCollationKey(String source) {
        if (source == null) {
            return null;
        }
        if (this.primResult == null) {
            this.primResult = new StringBuffer();
            this.secResult = new StringBuffer();
            this.terResult = new StringBuffer();
        } else {
            this.primResult.setLength(0);
            this.secResult.setLength(0);
            this.terResult.setLength(0);
        }
        int order = 0;
        boolean compareSec = this.getStrength() >= 1;
        boolean compareTer = this.getStrength() >= 2;
        int secOrder = -1;
        int terOrder = -1;
        int preSecIgnore = 0;
        if (this.sourceCursor == null) {
            this.sourceCursor = this.getCollationElementIterator(source);
        } else {
            this.sourceCursor.setText(source);
        }
        while ((order = this.sourceCursor.next()) != -1) {
            secOrder = CollationElementIterator.secondaryOrder(order);
            terOrder = CollationElementIterator.tertiaryOrder(order);
            if (!CollationElementIterator.isIgnorable(order)) {
                this.primResult.append((char)(CollationElementIterator.primaryOrder(order) + 1));
                if (compareSec) {
                    if (this.tables.isFrenchSec() && preSecIgnore < this.secResult.length()) {
                        RBCollationTables.reverse(this.secResult, preSecIgnore, this.secResult.length());
                    }
                    this.secResult.append((char)(secOrder + 1));
                    preSecIgnore = this.secResult.length();
                }
                if (!compareTer) continue;
                this.terResult.append((char)(terOrder + 1));
                continue;
            }
            if (compareSec && secOrder != 0) {
                this.secResult.append((char)(secOrder + this.tables.getMaxSecOrder() + 1));
            }
            if (!compareTer || terOrder == 0) continue;
            this.terResult.append((char)(terOrder + this.tables.getMaxTerOrder() + 1));
        }
        if (this.tables.isFrenchSec()) {
            if (preSecIgnore < this.secResult.length()) {
                RBCollationTables.reverse(this.secResult, preSecIgnore, this.secResult.length());
            }
            RBCollationTables.reverse(this.secResult, 0, this.secResult.length());
        }
        this.primResult.append('\u0000');
        this.secResult.append('\u0000');
        this.secResult.append(this.terResult.toString());
        this.primResult.append(this.secResult.toString());
        if (this.getStrength() == 3) {
            this.primResult.append('\u0000');
            Normalizer.Mode mode = Normalizer.getMode(this.getDecomposition());
            this.primResult.append(Normalizer.normalize(source, mode, 0));
        }
        return new CollationKey(source, this.primResult.toString());
    }

    public Object clone() {
        Class clazz = this.getClass();
        Class clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.text.RuleBasedCollator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return new RuleBasedCollator(this);
        }
        RuleBasedCollator result = (RuleBasedCollator)super.clone();
        result.primResult = null;
        result.secResult = null;
        result.terResult = null;
        result.sourceCursor = null;
        result.targetCursor = null;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RuleBasedCollator other = (RuleBasedCollator)obj;
        return this.getRules().equals(other.getRules());
    }

    public int hashCode() {
        return this.getRules().hashCode();
    }

    RBCollationTables getTables() {
        return this.tables;
    }
}

