/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.oti.util.ExtendedResourceBundle;
import com.ibm.oti.util.Msg;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Currency
implements Serializable {
    private static final long serialVersionUID = -158308464356906721L;
    private static Hashtable codesToCurrencies = new Hashtable();
    private String currencyCode;
    private static String currencyVars = "EURO, HK, PREEURO";
    private transient int defaultFractionDigits;

    private Currency(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public static Currency getInstance(String currencyCode) {
        Currency currency = (Currency)codesToCurrencies.get(currencyCode);
        if (currency == null) {
            ResourceBundle bundle = Locale.getBundle("ISO4CurrenciesToDigits", Locale.getDefault());
            currency = new Currency(currencyCode);
            String defaultFractionDigits = null;
            try {
                defaultFractionDigits = bundle.getString(currencyCode);
            }
            catch (MissingResourceException missingResourceException) {
                throw new IllegalArgumentException(Msg.getString("K0322", currencyCode));
            }
            currency.defaultFractionDigits = Integer.parseInt(defaultFractionDigits);
            codesToCurrencies.put(currencyCode, currency);
        }
        return currency;
    }

    public static Currency getInstance(Locale locale) {
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (!variant.equals("") && currencyVars.indexOf(variant) > -1) {
            country = String.valueOf(country) + "_" + variant;
        }
        ResourceBundle bundle = Locale.getBundle("ISO4Currencies", Locale.getDefault());
        String currencyCode = null;
        try {
            currencyCode = bundle.getString(country);
        }
        catch (MissingResourceException missingResourceException) {
            if (variant.equals("EURO")) {
                return Currency.getInstance("EUR");
            }
            throw new IllegalArgumentException(Msg.getString("K0323", locale.toString()));
        }
        if (currencyCode.equals("None")) {
            return null;
        }
        return Currency.getInstance(currencyCode);
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault());
    }

    public String getSymbol(Locale locale) {
        if (locale.getCountry().equals("")) {
            return this.currencyCode;
        }
        ExtendedResourceBundle localeBundle = (ExtendedResourceBundle)Locale.getBundle("Locale", locale);
        if (((String)localeBundle.getObject(com.ibm.oti.locale.Locale.INTL_CURRENCY_SYMBOL)).equals(this.currencyCode)) {
            return (String)localeBundle.getObject(com.ibm.oti.locale.Locale.CURRENCY_SYMBOL);
        }
        ResourceBundle bundle = null;
        try {
            bundle = Locale.getBundle("Currency", locale);
        }
        catch (MissingResourceException missingResourceException) {
            return this.currencyCode;
        }
        if (!bundle.getLocale().getCountry().equals(locale.getCountry())) {
            return this.currencyCode;
        }
        String result = (String)bundle.handleGetObject(this.currencyCode);
        if (result != null) {
            return result;
        }
        return this.currencyCode;
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    public String toString() {
        return this.currencyCode;
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }
}

