/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarInputStream
extends ZipInputStream {
    private Manifest manifest;
    private boolean eos = false;
    private JarEntry mEntry;
    private JarEntry jarEntry;
    private boolean isMeta;
    private JarVerifier verifier;
    private OutputStream verStream;

    public JarInputStream(InputStream stream, boolean verify) throws IOException {
        super(stream);
        if (verify) {
            this.verifier = new JarVerifier("JarInputStream");
        }
        if ((this.mEntry = this.getNextJarEntry()) == null) {
            return;
        }
        String name = this.mEntry.getName().toUpperCase();
        if (name.equals("META-INF/")) {
            this.mEntry = null;
            this.closeEntry();
            this.mEntry = this.getNextJarEntry();
            name = this.mEntry.getName().toUpperCase();
        }
        if (name.equals("META-INF/MANIFEST.MF")) {
            this.mEntry = null;
            this.manifest = new Manifest(this, verify);
            this.closeEntry();
            if (verify) {
                this.verifier.setManifest(this.manifest);
            }
        } else {
            Attributes temp = new Attributes(3);
            temp.map.put("hidden", null);
            this.mEntry.setAttributes(temp);
        }
    }

    public JarInputStream(InputStream stream) throws IOException {
        this(stream, true);
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public JarEntry getNextJarEntry() throws IOException {
        return (JarEntry)this.getNextEntry();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.mEntry != null) {
            return -1;
        }
        int r = super.read(buf, off, len);
        if (this.verStream != null && !this.eos) {
            if (r == -1) {
                this.eos = true;
                if (this.isMeta) {
                    this.verifier.addMetaEntry(this.jarEntry.getName(), ((ByteArrayOutputStream)this.verStream).toByteArray());
                    this.verifier.readCertificates();
                } else {
                    this.verifier.verifySignatures((JarVerifier.VerifierEntry)this.verStream, this.jarEntry);
                }
            } else {
                this.verStream.write(buf, off, r);
            }
        }
        return r;
    }

    public ZipEntry getNextEntry() throws IOException {
        this.eos = false;
        if (this.mEntry != null) {
            this.jarEntry = this.mEntry;
            this.mEntry = null;
            this.jarEntry.setAttributes(null);
            return this.jarEntry;
        }
        this.jarEntry = (JarEntry)super.getNextEntry();
        if (this.jarEntry == null) {
            return null;
        }
        if (this.verifier != null) {
            this.isMeta = this.jarEntry.getName().toUpperCase().startsWith("META-INF/");
            this.verStream = this.isMeta ? new ByteArrayOutputStream() : this.verifier.initEntry(this.jarEntry.getName());
        }
        return this.jarEntry;
    }

    protected ZipEntry createZipEntry(String name) {
        JarEntry entry = new JarEntry(name);
        if (this.manifest != null) {
            entry.setAttributes(this.manifest.getAttributes(name));
        }
        return entry;
    }
}

