/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.ibm.oti.util.Msg;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflaterOutputStream
extends FilterOutputStream {
    static final int BUF_SIZE = 512;
    protected byte[] buf;
    protected Deflater def;
    boolean done = false;

    public DeflaterOutputStream(OutputStream os, Deflater def) {
        this(os, def, 512);
    }

    public DeflaterOutputStream(OutputStream os) {
        this(os, new Deflater());
    }

    public DeflaterOutputStream(OutputStream os, Deflater def, int bsize) {
        super(os);
        if (os == null || def == null) {
            throw new NullPointerException();
        }
        if (bsize <= 0) {
            throw new IllegalArgumentException();
        }
        this.def = def;
        this.buf = new byte[bsize];
    }

    protected void deflate() throws IOException {
        int x = 0;
        do {
            x = this.def.deflate(this.buf);
            this.out.write(this.buf, 0, x);
        } while (!this.def.needsInput());
    }

    public void close() throws IOException {
        if (!this.def.finished()) {
            this.finish();
        }
        this.def.end();
        this.out.close();
    }

    public void finish() throws IOException {
        if (this.done) {
            return;
        }
        this.def.finish();
        int x = 0;
        while (!this.def.finished()) {
            if (this.def.needsInput()) {
                this.def.setInput(this.buf, 0, 0);
            }
            x = this.def.deflate(this.buf);
            this.out.write(this.buf, 0, x);
        }
        this.done = true;
    }

    public void write(int i) throws IOException {
        byte[] b = new byte[]{(byte)i};
        this.write(b, 0, 1);
    }

    public void write(byte[] buf, int off, int nbytes) throws IOException {
        if (this.done) {
            throw new IOException(Msg.getString("K0007"));
        }
        if (off <= buf.length && nbytes >= 0 && off >= 0 && buf.length - off >= nbytes) {
            if (!this.def.needsInput()) {
                throw new IOException();
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.def.setInput(buf, off, nbytes);
        this.deflate();
    }
}

