/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.ibm.oti.util.Msg;
import java.util.zip.DataFormatException;

public class Inflater {
    private boolean finished = false;
    private boolean needsDictionary = false;
    private boolean noHeader = false;
    private long streamHandle = -1L;
    private byte[] inputBuffer = null;
    int inRead = 0;
    int inLength = 0;

    static {
        Inflater.oneTimeInitialization();
    }

    private static native void oneTimeInitialization();

    public synchronized void end() {
        if (this.streamHandle != -1L) {
            this.endImpl(this.streamHandle);
            this.inRead = 0;
            this.inputBuffer = null;
            this.inLength = 0;
            this.streamHandle = -1L;
        }
    }

    private synchronized native void endImpl(long var1);

    protected void finalize() {
        this.end();
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized int getAdler() {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException();
        }
        return this.getAdlerImpl(this.streamHandle);
    }

    private synchronized native int getAdlerImpl(long var1);

    public synchronized int getRemaining() {
        return this.inLength - this.inRead;
    }

    public synchronized int getTotalIn() {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException();
        }
        return this.getTotalInImpl(this.streamHandle);
    }

    private synchronized native int getTotalInImpl(long var1);

    public synchronized int getTotalOut() {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException();
        }
        return this.getTotalOutImpl(this.streamHandle);
    }

    private synchronized native int getTotalOutImpl(long var1);

    public int inflate(byte[] buf) throws DataFormatException {
        return this.inflate(buf, 0, buf.length);
    }

    public synchronized int inflate(byte[] buf, int off, int nbytes) throws DataFormatException {
        if (off <= buf.length && nbytes >= 0 && off >= 0 && buf.length - off >= nbytes) {
            if (this.streamHandle == -1L) {
                throw new IllegalStateException();
            }
            boolean neededDict = this.needsDictionary;
            this.needsDictionary = false;
            int result = this.inflateImpl(buf, off, nbytes, this.streamHandle);
            if (this.needsDictionary && neededDict) {
                throw new DataFormatException(Msg.getString("K0324"));
            }
            return result;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private synchronized native int inflateImpl(byte[] var1, int var2, int var3, long var4);

    public Inflater() {
        this(false);
    }

    public Inflater(boolean noHeader) {
        this.noHeader = noHeader;
        this.streamHandle = this.createStream(noHeader);
    }

    public synchronized boolean needsDictionary() {
        if (this.inputBuffer == null) {
            throw new IllegalStateException();
        }
        return this.needsDictionary;
    }

    public synchronized boolean needsInput() {
        return this.inRead == this.inLength;
    }

    public synchronized void reset() {
        if (this.streamHandle == -1L) {
            throw new NullPointerException();
        }
        this.inputBuffer = null;
        this.finished = false;
        this.needsDictionary = false;
        this.inRead = 0;
        this.inLength = 0;
        this.resetImpl(this.streamHandle);
    }

    private synchronized native void resetImpl(long var1);

    public synchronized void setDictionary(byte[] buf) {
        this.setDictionary(buf, 0, buf.length);
    }

    public synchronized void setDictionary(byte[] buf, int off, int nbytes) {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException();
        }
        if (off > buf.length || nbytes < 0 || off < 0 || buf.length - off < nbytes) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.setDictionaryImpl(buf, off, nbytes, this.streamHandle);
    }

    private synchronized native void setDictionaryImpl(byte[] var1, int var2, int var3, long var4);

    public synchronized void setInput(byte[] buf) {
        this.setInput(buf, 0, buf.length);
    }

    public synchronized void setInput(byte[] buf, int off, int nbytes) {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException();
        }
        if (off > buf.length || nbytes < 0 || off < 0 || buf.length - off < nbytes) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.inputBuffer = buf;
        this.inRead = 0;
        this.inLength = nbytes;
        this.setInputImpl(buf, off, nbytes, this.streamHandle);
    }

    private synchronized native void setInputImpl(byte[] var1, int var2, int var3, long var4);

    private native long createStream(boolean var1);
}

