/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer;

import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeConnectionEvent;
import se.ericsson.cello.neal.NodeConnectionListener;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.fm.FmService;
import se.ericsson.wcdma.rbs.cabinetviewer.ConnectionStatusListener;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSessionController;

public class NealManager
implements NodeConnectionListener {
    private Node node = null;
    private final CvSessionController cvSessionController;
    private LauncherData launcherData;
    final List<ConnectionStatusListener> connectionListeners;

    public NealManager(LauncherData launcherData, CvSessionController cvSessionController) {
        this.launcherData = launcherData;
        this.cvSessionController = cvSessionController;
        this.connectionListeners = new ArrayList<ConnectionStatusListener>();
    }

    public void connectToNode() throws Exception {
        this.node = null;
        NodeServices nodeServices = (NodeServices)this.launcherData.launcher.runResource("/cello/emas/nodeservcfg.xml", this.launcherData.ipAddress, this.launcherData.properties, null);
        this.node = nodeServices.getNode();
        this.node.addConnectionListener((NodeConnectionListener)this);
    }

    public CmService getCmService() {
        return this.node.getCmService();
    }

    public FmService getFmService() {
        return this.node.getFmService();
    }

    public Node getNode() {
        return this.node;
    }

    public String getIpAddress() {
        return this.launcherData.ipAddress;
    }

    public void disconnectFromNode() {
        this.node.removeConnectionListener((NodeConnectionListener)this);
        this.connectionListeners.clear();
    }

    public void exitCabinetViewer() {
        if (this.cvSessionController != null) {
            Trace.observation(this, "Exiting the Cabinet Viewer session due to node restart!");
            this.cvSessionController.exit();
        }
        this.node = null;
        this.launcherData = null;
    }

    public void addConnectionListener(ConnectionStatusListener connectionStatusListener) {
        if (!this.connectionListeners.contains(connectionStatusListener)) {
            this.connectionListeners.add(connectionStatusListener);
        }
    }

    public void connectionLost(NodeConnectionEvent nodeConnectionEvent) {
        for (ConnectionStatusListener connectionStatusListener : this.connectionListeners) {
            connectionStatusListener.connectionLost();
        }
    }

    public void connectionRestored(NodeConnectionEvent nodeConnectionEvent) {
        for (ConnectionStatusListener connectionStatusListener : this.connectionListeners) {
            connectionStatusListener.reconnected();
        }
    }

    public static boolean isCausedByNodeRestarting(Throwable throwable) {
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (throwable2 instanceof NoRouteToHostException) {
                return false;
            }
            if (throwable2 instanceof ConnectException) {
                return false;
            }
            if (throwable2 instanceof NO_IMPLEMENT) {
                return false;
            }
            if (throwable2 instanceof NO_PERMISSION) {
                return false;
            }
            if (throwable2 instanceof SystemException) {
                return true;
            }
            if (throwable2 instanceof UserException) {
                return true;
            }
            if (throwable2 instanceof IOException) {
                return true;
            }
            if (!(throwable2 instanceof CmException)) continue;
            return true;
        }
        return false;
    }
}

