/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMoImpl;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.Observer;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.util.CachedTestMoImpl;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.mim.CabinetViewerMimModel;

public class CacheManager
implements Observer {
    final Map<String, CachedMo> mos;
    final NealManager nealManager;
    private CabinetViewerMimModel mimModel;

    public CacheManager(NealManager nealManager) {
        this.nealManager = nealManager;
        this.mos = Collections.synchronizedMap(new TreeMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMimData(CabinetViewerMimModel cabinetViewerMimModel) {
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.mimModel = cabinetViewerMimModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAttributeNamesAsArray(String string) {
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            return this.mimModel.getAttributeNames(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheMo(String string, Observer observer) throws Exception {
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            CachedMo cachedMo = this.getCachedMo(string);
            if (cachedMo != null) {
                return;
            }
            try {
                Object object;
                CmService cmService = this.getNode().getCmService();
                Mo mo = cmService.getMo(string);
                if (mo == null || !mo.exists()) {
                    return;
                }
                Mo mo2 = mo.getParent(null);
                CachedMo cachedMo2 = null;
                if (mo2 != null) {
                    object = mo2.getLdn();
                    CachedMo cachedMo3 = this.getCachedMo((String)object);
                    if (cachedMo3 == null) {
                        this.cacheMo((String)object, this);
                    }
                    cachedMo2 = this.getCachedMo((String)object);
                }
                object = this.ifTest() ? new CachedTestMoImpl(this, cachedMo2, mo) : new CachedMoImpl(this, cachedMo2, mo);
                if (cachedMo2 != null) {
                    cachedMo2.addChild((CachedMo)object);
                }
                this.addCachedMo((CachedMo)object);
            }
            catch (Exception exception) {
                Trace.error(this, exception.getMessage());
                throw new Exception(exception.getMessage(), exception);
            }
            finally {
                observer.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedMo getCachedMo(String string) {
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            return this.mos.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllCachedMos() {
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            ArrayList<CachedMo> arrayList = new ArrayList<CachedMo>(this.mos.values());
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CachedMo> getCachedMosOfType(String string) {
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            ArrayList<CachedMo> arrayList = new ArrayList<CachedMo>(this.mos.size());
            CachedMo[] cachedMoArray = this.mos.values().toArray(new CachedMo[0]);
            String string2 = null;
            for (int i = 0; i < cachedMoArray.length; ++i) {
                string2 = cachedMoArray[i].getMoType();
                if (!string2.equals(string)) continue;
                arrayList.add(cachedMoArray[i]);
            }
            arrayList.trimToSize();
            return arrayList;
        }
    }

    @Override
    public void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumCachedMos() {
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            return this.mos.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCachedMo(CachedMo cachedMo) {
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.mos.put(cachedMo.getLdn(), cachedMo);
        }
    }

    public Node getNode() {
        return this.nealManager.getNode();
    }

    private boolean ifTest() {
        return System.getProperty("MOM_TEST_IS_RUNNING") != null;
    }
}

