/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.log.availability;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.ConnectionFailedException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.FtpClient;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.FtpException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.FtpFactory;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.SaveLogs;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.log.availability.AvailabilityLogListener;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.log.availability.LogFetchEvent;

public class AvailabilityLogFetcher
extends Thread {
    private static final String AVAILABILITY_FILE_IN_RBS = "/c/logfiles/availability/CELLO_AVAILABILITY2_LOG.xml";
    private List<AvailabilityLogListener> listeners = new ArrayList<AvailabilityLogListener>();
    private FtpFactory ftpFactory;

    public AvailabilityLogFetcher(FtpFactory ftpFactory) {
        this.ftpFactory = ftpFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File file = null;
        LogFetchEvent logFetchEvent = null;
        FtpClient ftpClient = null;
        try {
            ftpClient = this.ftpFactory.newFtpClient();
            file = File.createTempFile("cabv", null);
            ftpClient.connect();
            ftpClient.get(AVAILABILITY_FILE_IN_RBS, file.getCanonicalPath());
            String string = SaveLogs.getFileContents(new FileInputStream(file));
            logFetchEvent = new LogFetchEvent(string);
        }
        catch (IOException iOException) {
            logFetchEvent = new LogFetchEvent("Unable get availability log", iOException);
        }
        catch (FtpException ftpException) {
            logFetchEvent = new LogFetchEvent("Unable get availability log", ftpException);
        }
        catch (ConnectionFailedException connectionFailedException) {
            logFetchEvent = new LogFetchEvent("Unable to connect to RBS", connectionFailedException);
        }
        catch (Exception exception) {
            logFetchEvent = new LogFetchEvent("Unable get availability log", exception);
        }
        finally {
            if (file != null) {
                file.delete();
            }
            if (ftpClient != null) {
                ftpClient.disconnect();
            }
            this.fireLogFetchComplete(logFetchEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLogFetchComplete(LogFetchEvent logFetchEvent) {
        AvailabilityLogFetcher availabilityLogFetcher = this;
        synchronized (availabilityLogFetcher) {
            if (logFetchEvent == null) {
                return;
            }
            for (AvailabilityLogListener availabilityLogListener : this.listeners) {
                availabilityLogListener.availabilityLogFetchComplete(logFetchEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AvailabilityLogListener availabilityLogListener) {
        AvailabilityLogFetcher availabilityLogFetcher = this;
        synchronized (availabilityLogFetcher) {
            this.listeners.add(availabilityLogListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners() {
        AvailabilityLogFetcher availabilityLogFetcher = this;
        synchronized (availabilityLogFetcher) {
            this.listeners.clear();
        }
    }
}

