/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.alarmlist;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;

public class AlarmlistHandler
extends Thread {
    private static AlarmlistHandler instance = null;
    private static String ALARMLIST_CONFIG = "ALARMLIST_CONFIG";
    private static List<LauncherData> launcherDataList = new LinkedList<LauncherData>();

    private AlarmlistHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            List<LauncherData> list = launcherDataList;
            synchronized (list) {
                if (launcherDataList != null && launcherDataList.size() > 0) {
                    Iterator<LauncherData> iterator = launcherDataList.iterator();
                    while (iterator.hasNext()) {
                        LauncherData launcherData = iterator.next();
                        try {
                            Trace.observation(this, "Start to runApplication in AlarmlistHandler thread");
                            String string = launcherData.properties.getProperty(ALARMLIST_CONFIG);
                            launcherData.launcher.runApplication(string, launcherData.ipAddress, launcherData.properties, null);
                        }
                        catch (LauncherException launcherException) {
                            Trace.error(this, "Failed to runApplication in AlarmlistHandler thread", launcherException);
                        }
                        finally {
                            iterator.remove();
                        }
                    }
                } else {
                    try {
                        launcherDataList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        launcherDataList.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlarmlistHandler getInstance() {
        List<LauncherData> list = launcherDataList;
        synchronized (list) {
            if (instance == null) {
                instance = new AlarmlistHandler();
                instance.start();
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLauncherData(LauncherData launcherData) {
        List<LauncherData> list = launcherDataList;
        synchronized (list) {
            launcherDataList.add(launcherData);
            launcherDataList.notifyAll();
        }
    }
}

