/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.BoardView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.SubrackLayout;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.UnitView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VerticalLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class SubrackView
extends VoView {
    public static final int POSITION_TOP = 0;
    public static final int POSITION_BOTTOM = 2;
    final int fanPosition = 0;
    private JPanel slotsPanel;
    VerticalLabel subrackLabel;
    private SubrackLayout subrackLayout = new SubrackLayout();
    private int slotsConditionalShift = 0;

    public SubrackView(VoData voData, SubrackLayout subrackLayout, Hashtable hashtable) {
        super(voData);
        this.copyProperties(hashtable);
        if (subrackLayout != null) {
            this.subrackLayout = subrackLayout;
        }
        this.setName(voData.getSpecificType() + " Subrack");
        this.setToolTipText(voData.getSpecificType() + " Subrack");
        this.buildSubrack();
    }

    public SubrackView(String string, Hashtable hashtable) {
        super(string + " Subrack");
        this.copyProperties(hashtable);
        this.buildSubrack();
    }

    @Override
    public void setLabel(String string) {
    }

    @Override
    public void setLedViewActive() {
    }

    @Override
    public void setStateViewActive() {
    }

    public void buildSubrack() {
        super.initialise();
        this.setLayout(new GridBagLayout());
        this.subrackLabel = new VerticalLabel(this.getName());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        super.add((Component)this.subrackLabel, gridBagConstraints);
        if (this.getProperties().get("CONTAINS_AUH_FIRST_POSITION") != null) {
            BoardView boardView = new BoardView("AUH");
            boardView.setInstallationState(1);
            this.add((Component)boardView, null);
            this.slotsConditionalShift = 1;
        }
    }

    public void addWithoutSlot(VoView voView) {
        this.slotsConditionalShift = 0;
        int n = this.subrackLayout.getNumberOfSlots() + 1;
        VoData voData = voView.getVoData();
        if (voData != null && voData.getProperty("POSITION_BOTTOM") != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            super.add((Component)voView, gridBagConstraints);
        } else {
            this.addToSlot(voView, n);
        }
    }

    public void addToSlot(VoView voView, int n) {
        int n2 = n;
        n2 += this.slotsConditionalShift;
        if (this.slotsPanel == null) {
            this.slotsPanel = new JPanel();
            this.slotsPanel.setLayout(this.subrackLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            if (this.getProperties().get("NON_STANDARD_SHALLOW") != null) {
                gridBagConstraints.insets = new Insets(1, 5, 1, 25);
            }
            this.slotsPanel.setBackground(this.deselectedBackgroundColor);
            this.slotsPanel.setForeground(this.deselectedForegroundColor);
            super.add((Component)this.slotsPanel, gridBagConstraints);
        }
        if (this.getProperties().get("NON_STANDARD_SHALLOW") != null) {
            this.slotsPanel.add((Component)voView, new Integer(n2 * 2 - 1));
        } else {
            this.slotsPanel.add((Component)voView, new Integer(n2));
            if (voView.getProperties().get("OCCUPIES_TWO_SLOTS") != null) {
                this.subrackLayout.setupWideSlot(n2, 2);
            }
        }
    }

    @Override
    public void select() {
        if (this.slotsPanel != null) {
            this.slotsPanel.setBackground(this.selectedBackgroundColor);
            this.slotsPanel.setForeground(this.selectedForegroundColor);
            super.select();
        }
    }

    @Override
    public void deSelect() {
        if (this.slotsPanel != null) {
            this.slotsPanel.setBackground(this.deselectedBackgroundColor);
            this.slotsPanel.setForeground(this.deselectedForegroundColor);
            super.deSelect();
        }
    }

    @Override
    public void add(Component component, Object object) {
        if (component instanceof BoardView) {
            int n = object instanceof Integer ? (Integer)object : this.subrackLayout.getNumberOfSlots() + 1;
            this.addToSlot((VoView)component, n);
        } else if (component instanceof UnitView) {
            UnitView unitView = (UnitView)component;
            VoData voData = unitView.getVoData();
            if (voData != null && voData.getSpecificType().equals("FAN")) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                super.add(component, gridBagConstraints);
            } else {
                super.add(component, object);
            }
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.slotsPanel == null) {
            return;
        }
        Component[] componentArray = this.slotsPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof VoView)) continue;
            VoView voView = (VoView)componentArray[i];
            voView.cleanUp();
        }
    }
}

