/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.ActionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.CurrentVisualHandler;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.HorizontalLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.StateOrLedPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoSelectionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class SupportUnitView
extends VoView {
    private HorizontalLabel unitLabel;
    private StateOrLedPanel stateOrLedPanel;
    private CurrentVisualHandler currentHandlerHandlerPanel = null;

    public SupportUnitView(ViewableObject viewableObject, Hashtable hashtable) {
        super(viewableObject);
        this.copyProperties(hashtable);
        this.setName(viewableObject.getProductName().replaceAll("[0-9]", "").trim());
        if (!viewableObject.isPrefixVisible()) {
            this.setToolTipText(viewableObject.getProductName().replaceAll("[0-9]", "").trim());
        }
        this.buildUnitGui();
    }

    public SupportUnitView(String string, Hashtable hashtable) {
        super(string);
        this.copyProperties(hashtable);
        this.buildUnitGui();
    }

    @Override
    public void setSelectionManager(VoSelectionManager voSelectionManager) {
        super.setSelectionManager(voSelectionManager);
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setSelectionManager(voSelectionManager);
        }
    }

    @Override
    public void setActionManager(ActionManager actionManager) {
        super.setActionManager(actionManager);
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setActionManager(actionManager);
        }
    }

    public void buildUnitGui() {
        super.initialise();
        this.setLayout(new GridBagLayout());
        if (this.getProperties().get("DCCU_EXTRA_GRAPHIC_HANDLE") != null) {
            this.buildDccExtraHandleUnitGui();
        } else {
            this.buildDefaultUnitGui();
        }
    }

    @Override
    public void setLedViewActive() {
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setLedViewActive();
        }
    }

    @Override
    public void setStateViewActive() {
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setStateViewActive();
        }
    }

    @Override
    public void setLabel(String string) {
        this.unitLabel.setText(string);
    }

    private void buildDccExtraHandleUnitGui() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.currentHandlerHandlerPanel = new CurrentVisualHandler();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.currentHandlerHandlerPanel.setBackground(this.getBackground());
        this.add((Component)this.currentHandlerHandlerPanel, gridBagConstraints);
        this.buildDefaultUnitGui();
    }

    private void buildDefaultUnitGui() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.unitLabel = new HorizontalLabel(this.getName());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.unitLabel, gridBagConstraints);
        VoData voData = this.getVoData();
        if (voData != null) {
            this.stateOrLedPanel = new StateOrLedPanel(voData, this.getToolTipText());
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.stateOrLedPanel, gridBagConstraints);
        }
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)jPanel, gridBagConstraints);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setBackground(color);
        }
        if (this.currentHandlerHandlerPanel != null) {
            this.currentHandlerHandlerPanel.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setForeground(color);
        }
        if (this.currentHandlerHandlerPanel != null) {
            this.currentHandlerHandlerPanel.setForeground(color);
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.cleanUp();
        }
    }
}

