/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class VerticalSubrackLayout
implements LayoutManager2 {
    public static final String NAME = "SUBRACK_LAYOUT";
    final List<Component> slotComponents = new ArrayList<Component>();

    public int getNumberOfSlots() {
        int n = this.slotComponents.size() - 1;
        if (n < 0) {
            return 0;
        }
        return n;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof Integer)) {
            throw new Error("constraint must be an Integer representing the slot number ");
        }
        int n = (Integer)object;
        if (n == 0) {
            n = 1;
        }
        this.ensureSize(n);
        this.slotComponents.set(n, component);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(1000, 1000);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        throw new UnsupportedOperationException("addLayoutComponent(String, Component) not supported");
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.slotComponents.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 1; i < this.slotComponents.size(); ++i) {
            serializable = this.slotComponents.get(i);
            if (serializable == null) continue;
            Dimension dimension = serializable.getPreferredSize();
            if (dimension.getWidth() > d) {
                d = dimension.getWidth();
            }
            if (!(dimension.getHeight() > d2)) continue;
            d2 = dimension.getHeight();
        }
        Insets insets = container.getInsets();
        d = d + (double)insets.top + (double)insets.bottom;
        d2 = d2 + (double)insets.left + (double)insets.right;
        serializable = new Dimension((int)d, (int)d2);
        return serializable;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        double d;
        int n = this.getNumberOfSlots();
        double d2 = d = container.getSize().getWidth();
        this.layoutSlots(container, n, d2);
    }

    private void layoutSlots(Container container, int n, double d) {
        double d2 = 0.0;
        int n2 = 0;
        for (int i = 1; i <= n; ++i) {
            Component component = this.slotComponents.get(i);
            double d3 = container.getHeight() / n;
            Dimension dimension = new Dimension((int)d, (int)d3);
            Point point = new Point((int)d2, n2);
            if (component != null) {
                component.setSize(dimension);
                component.setLocation(point);
            }
            n2 = (int)((double)n2 + d3);
        }
    }

    private void ensureSize(int n) {
        int n2 = this.slotComponents.size() - 1;
        if (n2 <= n) {
            for (int i = n2; i < n; ++i) {
                this.slotComponents.add(null);
            }
        }
    }
}

