/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.ActionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.GridMounting;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.NotifyUpdateManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.RbsLookAndFeel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.Selectable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoSelectionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public abstract class VoView
extends JPanel
implements Selectable {
    public static final String PROPERTY_IS_SELECTED = "VoView.isSelected";
    public static final int RELATIVE_SIZE_UNIT = 10;
    public static final int STATE_INSTALLED = 0;
    public static final int STATE_AUTONOMOUS = 1;
    public static final int STATE_NOT_INSTALLED = 2;
    private VoData voData;
    private Dimension relativeSize = new Dimension(1, 1);
    private ActionManager actionManager;
    private VoSelectionManager selectionManager;
    private VoViewMouseListener mouseListener;
    protected Color deselectedBackgroundColor = RbsLookAndFeel.COLOR_INSTALLED;
    protected Color deselectedForegroundColor = RbsLookAndFeel.COLOR_NAME_LABEL;
    protected Color deselectedBorderColor = RbsLookAndFeel.COLOR_DESELECTED_BORDER;
    protected Color selectedBackgroundColor = RbsLookAndFeel.COLOR_SELECTED_FILL;
    protected Color selectedForegroundColor = RbsLookAndFeel.COLOR_NAME_LABEL;
    protected Color selectedBorderColor = RbsLookAndFeel.COLOR_SELECTED_BORDER;
    private Hashtable propertiesHash = new Hashtable();

    public VoView(VoData voData) {
        this.voData = voData;
        if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("false")) {
            this.setName(this.voData.getSpecificType());
        }
        String string = this.voData.getFullName();
        if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
            this.setName(string);
        }
        this.setToolTipText(string);
        if (this.voData.getProperty("NOTIFY_UPDATE") != null) {
            this.voData.addVoDataListener(new NotifyUpdateManager(this));
        }
    }

    public VoView(String string) {
        this.setName(string);
    }

    public abstract void setLabel(String var1);

    public void initialise() {
        this.setLayout(new GridBagLayout());
        this.setFont(RbsLookAndFeel.FONT_NAME_LABEL);
        this.setBorder(BorderFactory.createLineBorder(this.deselectedBorderColor));
        this.setForeground(this.deselectedForegroundColor);
        this.setBackground(this.deselectedBackgroundColor);
        this.setOpaque(true);
        this.mouseListener = new VoViewMouseListener();
        this.addMouseListener(this.mouseListener);
    }

    public abstract void setLedViewActive();

    public abstract void setStateViewActive();

    public Insets getViewInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public void cleanUp() {
        this.removeMouseListener(this.mouseListener);
    }

    public void copyProperties(Hashtable hashtable) {
        if (hashtable != null) {
            this.propertiesHash = hashtable;
        }
    }

    public Hashtable getProperties() {
        return this.propertiesHash;
    }

    @Override
    public String getName() {
        if (this.voData == null) {
            return super.getName();
        }
        String string = this.voData.getCustomLable();
        if (!"".equals(string)) {
            return string;
        }
        return super.getName();
    }

    protected VoViewMouseListener getVoViewMouseListener() {
        return this.mouseListener;
    }

    public void setInstallationState(int n) {
        switch (n) {
            case 2: {
                this.setBackground(RbsLookAndFeel.COLOR_NOT_INSTALLED);
                this.setEnabled(false);
                break;
            }
            case 1: {
                this.setBackground(RbsLookAndFeel.COLOR_AUTONOMOUS_UNIT);
                this.setEnabled(false);
                break;
            }
            case 0: {
                this.setBackground(RbsLookAndFeel.COLOR_INSTALLED);
                this.setEnabled(true);
                break;
            }
        }
    }

    public void setRelativeSize(int n, int n2) {
        this.relativeSize = new Dimension(n, n2);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getMinimumSize();
        int n = (int)this.relativeSize.getWidth() * 10;
        int n2 = (int)this.relativeSize.getHeight() * 10;
        if (dimension.getWidth() > (double)n) {
            n = (int)dimension.getWidth();
        }
        if (dimension.getHeight() > (double)n2) {
            n2 = (int)dimension.getHeight();
        }
        return new Dimension(n, n2);
    }

    @Override
    public void setSelectionManager(VoSelectionManager voSelectionManager) {
        this.selectionManager = voSelectionManager;
    }

    public void setActionManager(ActionManager actionManager) {
        this.actionManager = actionManager;
    }

    @Override
    public void select() {
        this.setBorder(BorderFactory.createLineBorder(this.selectedBorderColor));
        this.setBackground(this.selectedBackgroundColor);
        this.setForeground(this.selectedForegroundColor);
        this.firePropertyChange(PROPERTY_IS_SELECTED, false, true);
        this.repaint();
    }

    @Override
    public void deSelect() {
        this.setBorder(BorderFactory.createLineBorder(this.deselectedBorderColor));
        this.setBackground(this.deselectedBackgroundColor);
        this.setForeground(this.deselectedForegroundColor);
        this.firePropertyChange(PROPERTY_IS_SELECTED, true, false);
        this.repaint();
    }

    public VoData getVoData() {
        return this.voData;
    }

    protected void setColorScheme(Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        if (color != null) {
            this.deselectedBackgroundColor = color;
        }
        if (color2 != null) {
            this.deselectedForegroundColor = color2;
        }
        if (color3 != null) {
            this.deselectedBorderColor = color3;
        }
        if (color4 != null) {
            this.selectedBackgroundColor = color4;
        }
        if (color5 != null) {
            this.selectedForegroundColor = color5;
        }
        if (color6 != null) {
            this.selectedBorderColor = color6;
        }
    }

    @Override
    public void add(Component component, Object object) {
        if (object instanceof GridMounting) {
            GridMounting gridMounting = (GridMounting)object;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridMounting.getGridX();
            gridBagConstraints.gridy = gridMounting.getGridY();
            gridBagConstraints.gridwidth = gridMounting.getGridW();
            gridBagConstraints.gridheight = gridMounting.getGridH();
            gridBagConstraints.weightx = gridMounting.getRelativeWidth();
            gridBagConstraints.weighty = gridMounting.getRelativeHeight();
            gridBagConstraints.fill = 1;
            super.add(component, gridBagConstraints);
        } else {
            super.add(component, object);
        }
        if (component instanceof PropertyChangeListener) {
            this.addPropertyChangeListener((PropertyChangeListener)((Object)component));
        }
    }

    public void selectionPressed() {
        if (this.isEnabled()) {
            VoSelectionManager voSelectionManager = this.selectionManager;
            VoData voData = this.voData;
            if (voSelectionManager != null) {
                voSelectionManager.setSelection(voData);
            }
        }
    }

    class VoViewMouseListener
    extends MouseAdapter {
        VoViewMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            VoView.this.selectionPressed();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isPopUpTrigger(mouseEvent)) {
                this.popUp(mouseEvent);
            }
        }

        public boolean isPopUpTrigger(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                return true;
            }
            int n = mouseEvent.getModifiers();
            return n == 4;
        }

        public void popUp(MouseEvent mouseEvent) {
            if (VoView.this.actionManager == null) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            Action[] actionArray = VoView.this.actionManager.getOnlyEnabledActions();
            for (int i = 0; i < actionArray.length; ++i) {
                jPopupMenu.add(actionArray[i]);
            }
            jPopupMenu.show(VoView.this, mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

